/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.delimited.identifiers;

import org.apache.openjpa.jdbc.sql.DB2Dictionary;
import org.apache.openjpa.jdbc.sql.DerbyDictionary;
import org.apache.openjpa.persistence.OpenJPAEntityManager;
import org.apache.openjpa.persistence.OpenJPAEntityManagerFactorySPI;
import org.apache.openjpa.persistence.delimited.identifiers.EntityA;
import org.apache.openjpa.persistence.test.SQLListenerTestCase;

public class TestDelimitedIdentifiers
extends SQLListenerTestCase {
    OpenJPAEntityManager em;
    int id = 0;
    EntityA entityA;

    public void setUp() throws Exception {
        this.setSupportedDatabases(DerbyDictionary.class, DB2Dictionary.class);
        if (this.isTestsDisabled()) {
            return;
        }
        super.setUp(EntityA.class, DROP_TABLES);
        TestDelimitedIdentifiers.assertNotNull((Object)this.emf);
        this.em = this.emf.createEntityManager();
        TestDelimitedIdentifiers.assertNotNull((Object)this.em);
    }

    protected OpenJPAEntityManagerFactorySPI createEMF(Object ... props) {
        return this.createNamedEMF("delimited-identifiers", props);
    }

    public void createEntityA(int id) {
        this.entityA = new EntityA(id, "aName");
        this.entityA.setSecName("sec name");
        this.entityA.addCollectionSet("xxx");
        this.entityA.addCollectionSet("yyy");
        this.entityA.addCollectionDelimSet("aaa");
        this.entityA.addCollectionDelimSet("bbb");
    }

    public void testTableName() {
        ++this.id;
        this.createEntityA(this.id);
        this.em.getTransaction().begin();
        this.em.persist((Object)this.entityA);
        this.em.getTransaction().commit();
        int genId = this.entityA.getId();
        this.em.clear();
        this.em.getTransaction().begin();
        EntityA eA = (EntityA)this.em.find(EntityA.class, (Object)genId);
        TestDelimitedIdentifiers.assertEquals((String)"aName", (String)eA.getName());
        this.em.getTransaction().commit();
        this.em.close();
    }
}

