/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.delimited.identifiers;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.persistence.CollectionTable;
import javax.persistence.Column;
import javax.persistence.ElementCollection;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.MapKeyColumn;
import javax.persistence.SecondaryTable;
import javax.persistence.Table;
import javax.persistence.TableGenerator;
import javax.persistence.UniqueConstraint;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Entity
@Table(name="\"primary entityF\"", schema="\"delim id\"", uniqueConstraints={@UniqueConstraint(columnNames={"\"f name\"", "f_nonDelimName"})})
@SecondaryTable(name="\"secondary entityF\"", schema="\"delim id\"", uniqueConstraints={@UniqueConstraint(name="\"sec unq\"", columnNames={"\"secondary name\""})})
public class EntityF {
    @TableGenerator(name="f_id_gen", table="\"f_id_gen\"", schema="\"delim id\"", pkColumnName="\"gen_pk\"", valueColumnName="\"gen_value\"")
    @GeneratedValue(strategy=GenerationType.TABLE, generator="f_id_gen")
    @Id
    private int id;
    @Column(name="\"f name\"", columnDefinition="char(15)")
    private String name;
    @Column(name="f_nonDelimName")
    private String nonDelimName;
    @Column(name="\"secondary name\"", table="\"secondary entityF\"")
    private String secName;
    @ElementCollection
    @CollectionTable
    private Set<String> cSet = new HashSet<String>();
    @ElementCollection
    @CollectionTable(name="\"collectionDelimSet\"", schema="\"delim id\"")
    private Set<String> collectionDelimSet = new HashSet<String>();
    @ElementCollection
    @MapKeyColumn
    private Map<String, String> cMap = new HashMap<String, String>();
    @ElementCollection
    @MapKeyColumn(name="\"mapKey\"", columnDefinition="varchar(20)", table="\"d colmap\"")
    private Map<String, String> dcMap = new HashMap<String, String>();

    public EntityF(String name) {
        this.name = name;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getNonDelimName() {
        return this.nonDelimName;
    }

    public void setNonDelimName(String nonDelimName) {
        this.nonDelimName = nonDelimName;
    }

    public String getSecName() {
        return this.secName;
    }

    public void setSecName(String secName) {
        this.secName = secName;
    }

    public Set<String> getCollectionSet() {
        return this.cSet;
    }

    public void setCollectionSet(Set<String> collectionSet) {
        this.cSet = collectionSet;
    }

    public void addCollectionSet(String item) {
        this.cSet.add(item);
    }

    public Set<String> getCollectionDelimSet() {
        return this.collectionDelimSet;
    }

    public void setCollectionDelimSet(Set<String> collectionDelimSet) {
        this.collectionDelimSet = collectionDelimSet;
    }

    public void addCollectionDelimSet(String item) {
        this.collectionDelimSet.add(item);
    }

    public Map<String, String> getCollectionMap() {
        return this.cMap;
    }

    public void setCollectionMap(Map<String, String> collectionMap) {
        this.cMap = collectionMap;
    }

    public void addCollectionMap(String key, String value) {
        this.cMap.put(key, value);
    }

    public Map<String, String> getDelimCollectionMap() {
        return this.dcMap;
    }

    public void setDelimCollectionMap(Map<String, String> delimCollectionMap) {
        this.dcMap = delimCollectionMap;
    }

    public void addDelimCollectionMap(String key, String value) {
        this.dcMap.put(key, value);
    }
}

