/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.datacache.common.apps;

import java.util.ArrayList;
import java.util.List;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import org.apache.openjpa.persistence.PersistentCollection;
import org.apache.openjpa.persistence.datacache.common.apps.EmbeddedEntity;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Entity
public class EmbeddingOwnerEntity {
    @Id
    @GeneratedValue
    private long id;
    @PersistentCollection(elementEmbedded=true, elementType=EmbeddedEntity.class, fetch=FetchType.LAZY)
    private List<EmbeddedEntity> members;

    public List<EmbeddedEntity> getMembers() {
        return this.members;
    }

    public void addMember(EmbeddedEntity member) {
        if (this.members == null) {
            this.members = new ArrayList<EmbeddedEntity>();
        }
        this.members.add(member);
    }

    public void removeMember(EmbeddedEntity member) {
        if (this.members != null) {
            this.members.remove(member);
        }
    }

    public EmbeddedEntity removeMember(int member) {
        return this.members != null ? this.members.remove(member) : null;
    }

    public long getId() {
        return this.id;
    }
}

