/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.datacache;

import javax.persistence.EntityManager;
import org.apache.openjpa.datacache.CacheStatistics;
import org.apache.openjpa.persistence.OpenJPAEntityManagerFactorySPI;
import org.apache.openjpa.persistence.StoreCache;
import org.apache.openjpa.persistence.StoreCacheImpl;
import org.apache.openjpa.persistence.datacache.CachedPerson;
import org.apache.openjpa.persistence.test.SingleEMFTestCase;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestStatistics
extends SingleEMFTestCase {
    private static final boolean L2Cached = true;
    private static final boolean L1Cached = true;
    private static CachedPerson person;
    private EntityManager em;
    private StoreCache cache;
    CacheStatistics stats;

    @Override
    public void setUp() {
        super.setUp(CLEAR_TABLES, CachedPerson.class, "openjpa.DataCache", "true(EnableStatistics=true)", "openjpa.QueryCache", "true", "openjpa.RemoteCommitProvider", "sjvm");
        this.cache = this.emf.getStoreCache();
        TestStatistics.assertNotNull((Object)this.cache);
        this.stats = this.cache.getStatistics();
        TestStatistics.assertNotNull((Object)this.stats);
        this.em = this.emf.createEntityManager();
        person = this.createData();
        this.stats.reset();
        this.em.clear();
    }

    public void testDefaultSettings() {
        Object[] props = new Object[]{"openjpa.DataCache", "true", "openjpa.RemoteCommitProvider", "sjvm"};
        OpenJPAEntityManagerFactorySPI emf1 = this.createNamedEMF("second-persistence-unit", props);
        TestStatistics.assertFalse((boolean)emf1.getStoreCache().getStatistics().isEnabled());
    }

    public void testFind() {
        TestStatistics.assertTrue((boolean)this.cache.getStatistics().isEnabled());
        Integer pid = person.getId();
        this.assertCached(person, pid, false, true);
        long[] before = this.snapshot();
        CachedPerson p = (CachedPerson)this.em.find(CachedPerson.class, (Object)pid);
        long[] after = this.snapshot();
        this.assertDelta(before, after, 1L, 1L, 0L);
        this.assertCached(p, pid, true, true);
    }

    public void testMultipleUnits() {
        Object[] props = new String[]{"openjpa.DataCache", "true", "openjpa.RemoteCommitProvider", "sjvm"};
        OpenJPAEntityManagerFactorySPI emf1 = this.createNamedEMF("test", props);
        OpenJPAEntityManagerFactorySPI emf2 = this.createNamedEMF("empty-pu", props);
        TestStatistics.assertNotSame((Object)emf1, (Object)emf2);
        TestStatistics.assertNotSame((Object)emf1.getStoreCache(), (Object)emf2.getStoreCache());
        TestStatistics.assertNotSame((Object)emf1.getStoreCache().getStatistics(), (Object)emf2.getStoreCache().getStatistics());
        TestStatistics.assertNotSame((Object)((StoreCacheImpl)emf1.getStoreCache()).getDelegate(), (Object)((StoreCacheImpl)emf2.getStoreCache()).getDelegate());
    }

    CachedPerson createData() {
        this.em.getTransaction().begin();
        CachedPerson p = new CachedPerson();
        p.setId((int)System.currentTimeMillis());
        this.em.persist((Object)p);
        this.em.getTransaction().commit();
        return p;
    }

    long[] snapshot() {
        return new long[]{this.stats.getReadCount(), this.stats.getHitCount(), this.stats.getWriteCount()};
    }

    long[] snapshot(Class<?> cls) {
        return new long[]{this.stats.getReadCount(cls), this.stats.getHitCount(cls), this.stats.getWriteCount(cls)};
    }

    void assertDelta(long[] before, long[] after, long readDelta, long hitDelta, long writeDelta) {
        TestStatistics.assertEquals((String)"READ count mismatch", (long)readDelta, (long)(after[0] - before[0]));
        TestStatistics.assertEquals((String)"HIT count mismatch", (long)hitDelta, (long)(after[1] - before[1]));
        TestStatistics.assertEquals((String)"WRITE count mismatch", (long)writeDelta, (long)(after[2] - before[2]));
    }

    void assertCached(Object o, Object oid, boolean l1, boolean l2) {
        boolean l1a = this.em.contains(o);
        boolean l2a = this.cache.contains(o.getClass(), oid);
        if (l1 != l1a) {
            TestStatistics.fail((String)("Expected " + (l1 ? "" : "not") + " to find instance " + o.getClass().getSimpleName() + ":" + oid + " in L1 cache"));
        }
        if (l2 != l2a) {
            TestStatistics.fail((String)("Expected " + (l2 ? "" : "not") + " to find instance " + o.getClass().getSimpleName() + ":" + oid + " in L2 cache"));
        }
    }

    void print(String msg, CacheStatistics stats) {
        System.err.println(msg + stats + " H:" + stats.getHitCount() + " R:" + stats.getReadCount() + " W:" + stats.getWriteCount());
    }
}

