/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.datacache;

import java.util.Collection;
import java.util.HashMap;
import javax.persistence.EntityManagerFactory;
import org.apache.openjpa.kernel.Broker;
import org.apache.openjpa.kernel.BrokerFactory;
import org.apache.openjpa.kernel.Query;
import org.apache.openjpa.persistence.JPAFacadeHelper;
import org.apache.openjpa.persistence.OpenJPAEntityManagerFactory;
import org.apache.openjpa.persistence.common.utils.AbstractTestCase;
import org.apache.openjpa.persistence.datacache.CacheTestBroker;
import org.apache.openjpa.persistence.datacache.CacheTestHelper;
import org.apache.openjpa.persistence.datacache.common.apps.CacheObjectA;
import org.apache.openjpa.persistence.datacache.common.apps.CacheObjectE;
import org.apache.openjpa.persistence.datacache.common.apps.CacheObjectJ;

public class TestPCParametersInQueries
extends AbstractTestCase {
    private BrokerFactory _factory;
    private Object _eId;

    public TestPCParametersInQueries(String test) {
        super(test, "datacachecactusapp");
    }

    public void setUp() {
        this.deleteAll(CacheObjectA.class);
        HashMap<String, String> propsMap = new HashMap<String, String>();
        propsMap.put("openjpa.DataCache", "true");
        propsMap.put("openjpa.RemoteCommitProvider", "sjvm");
        propsMap.put("openjpa.BrokerImpl", CacheTestBroker.class.getName());
        OpenJPAEntityManagerFactory emf = this.getEmf(propsMap);
        this._factory = JPAFacadeHelper.toBrokerFactory((EntityManagerFactory)emf);
        Broker broker = this._factory.newBroker();
        broker.begin();
        CacheObjectE e = new CacheObjectE("bar");
        CacheObjectJ j = new CacheObjectJ("foo", e);
        broker.persist((Object)j, null);
        broker.persist((Object)e, null);
        broker.commit();
        this._eId = broker.getObjectId((Object)e);
        broker.close();
    }

    public void testPCParameter() {
        Broker broker = this._factory.newBroker();
        broker.begin();
        CacheObjectE e = (CacheObjectE)broker.find(this._eId, true, null);
        Query q = broker.newQuery("javax.persistence.JPQL", (Object)("select a from " + CacheObjectJ.class.getSimpleName() + " a where a.e = :param"));
        Collection c = (Collection)q.execute(new Object[]{e});
        CacheTestHelper.iterate(c);
        Object o = c.iterator().next();
        TestPCParametersInQueries.assertTrue((boolean)(o instanceof CacheObjectJ));
        CacheTestHelper.assertInCache(this, q, Boolean.TRUE, new Object[]{e});
        q = broker.newQuery("javax.persistence.JPQL", (Object)("select a from " + CacheObjectJ.class.getSimpleName() + " a where a.e = :param"));
        c = (Collection)q.execute(new Object[]{e});
        Object o2 = c.iterator().next();
        TestPCParametersInQueries.assertTrue((boolean)(o2 instanceof CacheObjectJ));
        TestPCParametersInQueries.assertTrue((o == o2 ? 1 : 0) != 0);
        broker.commit();
        broker.close();
    }
}

