/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.datacache;

import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import javax.persistence.EntityManagerFactory;
import org.apache.openjpa.kernel.Broker;
import org.apache.openjpa.kernel.BrokerFactory;
import org.apache.openjpa.kernel.Query;
import org.apache.openjpa.persistence.JPAFacadeHelper;
import org.apache.openjpa.persistence.OpenJPAEntityManagerFactory;
import org.apache.openjpa.persistence.common.utils.AbstractTestCase;
import org.apache.openjpa.persistence.datacache.CacheTestBroker;
import org.apache.openjpa.persistence.datacache.CacheTestHelper;
import org.apache.openjpa.persistence.datacache.common.apps.CacheObjectA;
import org.apache.openjpa.persistence.datacache.common.apps.CacheObjectAChild1;

public class TestMutableParameters
extends AbstractTestCase {
    private BrokerFactory _factory;
    private Date _startDate;

    public TestMutableParameters(String test) {
        super(test, "datacachecactusapp");
    }

    public void setUp() throws Exception {
        this.deleteAll(CacheObjectA.class);
        HashMap<String, String> propsMap = new HashMap<String, String>();
        propsMap.put("openjpa.DataCache", "true");
        propsMap.put("openjpa.RemoteCommitProvider", "sjvm");
        propsMap.put("openjpa.BrokerImpl", CacheTestBroker.class.getName());
        OpenJPAEntityManagerFactory emf = this.getEmf(propsMap);
        this._factory = JPAFacadeHelper.toBrokerFactory((EntityManagerFactory)emf);
        this._startDate = new SimpleDateFormat("dd/MM/yyyy").parse("01/01/1990");
        Broker broker = this._factory.newBroker();
        broker.begin();
        for (int i = 0; i < 50; ++i) {
            CacheObjectAChild1 o = new CacheObjectAChild1("", "JPQL2Queries", i);
            o.setDate(this._startDate);
            broker.persist((Object)o, null);
        }
        broker.commit();
        broker.close();
        CacheTestHelper.cacheManager(this._factory).getSystemQueryCache().clear();
    }

    public void tearDown() throws Exception {
        try {
            this._factory.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        super.tearDown();
    }

    public void testMutatedDateParameter() {
        Broker broker = this._factory.newBroker();
        Query q = broker.newQuery("javax.persistence.JPQL", (Object)("select a from " + CacheObjectAChild1.class.getSimpleName() + " a where a.date < :p_date"));
        Date d = new Date();
        Collection c = (Collection)q.execute(new Object[]{d});
        CacheTestHelper.iterate(c);
        int initialSize = c.size();
        CacheTestHelper.assertInCache(this, q, Boolean.TRUE, new Object[]{d});
        d.setTime(this._startDate.getTime());
        CacheTestHelper.assertInCache(this, q, Boolean.FALSE, new Object[]{d});
        c = (Collection)q.execute(new Object[]{d});
        TestMutableParameters.assertFalse((boolean)new Integer(initialSize).equals(new Integer(c.size())));
    }
}

