/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.datacache;

import java.util.Map;
import org.apache.openjpa.persistence.OpenJPAEntityManagerSPI;
import org.apache.openjpa.persistence.datacache.common.apps.M2MEntityE;
import org.apache.openjpa.persistence.datacache.common.apps.M2MEntityF;
import org.apache.openjpa.persistence.test.SingleEMFTestCase;

public class TestM2MInDataCache
extends SingleEMFTestCase {
    public void setUp() {
        this.setUp("openjpa.DataCache", "true", "openjpa.RemoteCommitProvider", "sjvm", M2MEntityE.class, M2MEntityF.class, CLEAR_TABLES);
    }

    public void testM2MDataCache() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        em.getTransaction().begin();
        M2MEntityE e1 = new M2MEntityE();
        e1.setId(1);
        e1.setName("ABC");
        em.persist((Object)e1);
        M2MEntityE e2 = new M2MEntityE();
        e2.setId(2);
        e2.setName("DEF");
        em.persist((Object)e2);
        M2MEntityF f1 = new M2MEntityF();
        f1.setId(10);
        em.persist((Object)f1);
        M2MEntityF f2 = new M2MEntityF();
        f2.setId(20);
        em.persist((Object)f2);
        e1.getEntityF().put(f1.getId(), f1);
        e1.getEntityF().put(f2.getId(), f2);
        e2.getEntityF().put(f1.getId(), f1);
        e2.getEntityF().put(f2.getId(), f2);
        f1.getEntityE().put(e1.getName(), e1);
        f1.getEntityE().put(e2.getName(), e2);
        f2.getEntityE().put(e1.getName(), e1);
        f2.getEntityE().put(e2.getName(), e2);
        em.getTransaction().commit();
        em.close();
        em = this.emf.createEntityManager();
        try {
            M2MEntityE e1a = (M2MEntityE)em.find(M2MEntityE.class, (Object)1);
            Map<Integer, M2MEntityF> entityf1 = e1a.getEntityF();
            M2MEntityE e2a = (M2MEntityE)em.find(M2MEntityE.class, (Object)2);
            Map<Integer, M2MEntityF> entityf2 = e2a.getEntityF();
            M2MEntityF f1a = (M2MEntityF)em.find(M2MEntityF.class, (Object)10);
            Map<String, M2MEntityE> entitye1 = f1a.getEntityE();
            M2MEntityF f2a = (M2MEntityF)em.find(M2MEntityF.class, (Object)20);
            Map<String, M2MEntityE> entitye2 = f2a.getEntityE();
        }
        catch (Exception e) {
            TestM2MInDataCache.fail((String)"Fail to get a Map field when DataCache is on");
        }
    }
}

