/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.datacache;

import java.util.ArrayList;
import javax.persistence.Cache;
import org.apache.openjpa.persistence.ArgumentException;
import org.apache.openjpa.persistence.OpenJPAEntityManagerSPI;
import org.apache.openjpa.persistence.StoreCache;
import org.apache.openjpa.persistence.datacache.CachedEmployee;
import org.apache.openjpa.persistence.datacache.CachedManager;
import org.apache.openjpa.persistence.datacache.CachedPerson;
import org.apache.openjpa.persistence.test.SingleEMFTestCase;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestJPACache
extends SingleEMFTestCase {
    @Override
    public void setUp() {
        super.setUp(CachedPerson.class, CachedManager.class, CachedEmployee.class, "openjpa.DataCache", "true", "openjpa.RemoteCommitProvider", "sjvm");
    }

    private void populate() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        em.getTransaction().begin();
        CachedPerson p = new CachedPerson();
        p.setFirstName("John");
        p.setLastName("Doe");
        p.setId(10);
        em.persist((Object)p);
        p = new CachedPerson();
        p.setFirstName("Jane");
        p.setLastName("Doe");
        p.setId(11);
        em.persist((Object)p);
        CachedManager m = new CachedManager();
        m.setFirstName("Joan");
        m.setLastName("Baker");
        m.setId(12);
        m.setEmployees(new ArrayList<CachedEmployee>());
        em.persist((Object)m);
        CachedEmployee e = new CachedEmployee();
        e.setFirstName("Jim");
        e.setFirstName("Smith");
        e.setManager(m);
        e.setId(13);
        m.getEmployees().add(e);
        em.persist((Object)e);
        e = new CachedEmployee();
        e.setFirstName("Jeff");
        e.setFirstName("Parker");
        e.setId(14);
        e.setManager(m);
        m.getEmployees().add(e);
        em.persist((Object)e);
        em.getTransaction().commit();
        em.close();
    }

    public void testInterfacesReturned() {
        Cache cache = this.emf.getCache();
        TestJPACache.assertNotNull((String)"Cache is not enabled", (Object)cache);
        TestJPACache.assertTrue((boolean)(cache instanceof Cache));
        TestJPACache.assertTrue((boolean)(cache instanceof StoreCache));
    }

    public void testContains() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        em.getTransaction().begin();
        CachedPerson p = new CachedPerson();
        p.setFirstName("John");
        p.setLastName("Doe");
        p.setId(1);
        this.assertNotInCache(CachedPerson.class, 1);
        em.persist((Object)p);
        this.assertNotInCache(CachedPerson.class, 1);
        em.flush();
        this.assertNotInCache(CachedPerson.class, 1);
        em.getTransaction().commit();
        this.assertInCache(CachedPerson.class, 1);
        em.close();
    }

    public void testEvictInstance() {
        this.populate();
        this.assertInCache(CachedPerson.class, 10);
        this.assertInCache(CachedPerson.class, 11);
        this.assertNotInCache(CachedPerson.class, 1);
        this.emf.getCache().evict(CachedPerson.class, (Object)11);
        this.assertInCache(CachedPerson.class, 10);
        this.assertNotInCache(CachedPerson.class, 11);
        this.assertNotInCache(CachedPerson.class, 1);
    }

    public void testEvictClass() {
        this.populate();
        this.assertInCache(CachedPerson.class, 10);
        this.assertInCache(CachedPerson.class, 11);
        this.assertInCache(CachedEmployee.class, 13);
        this.assertInCache(CachedEmployee.class, 14);
        this.assertInCache(CachedManager.class, 12);
        this.emf.getCache().evict(CachedPerson.class);
        this.assertNotInCache(CachedPerson.class, 10);
        this.assertNotInCache(CachedPerson.class, 11);
        this.assertNotInCache(CachedEmployee.class, 13);
        this.assertNotInCache(CachedEmployee.class, 14);
        this.assertNotInCache(CachedManager.class, 12);
    }

    public void testEvictAll() {
        this.populate();
        this.assertInCache(CachedPerson.class, 10);
        this.assertInCache(CachedPerson.class, 11);
        this.assertInCache(CachedEmployee.class, 13);
        this.assertInCache(CachedEmployee.class, 14);
        this.assertInCache(CachedManager.class, 12);
        this.emf.getCache().evictAll();
        this.assertNotInCache(CachedPerson.class, 10);
        this.assertNotInCache(CachedPerson.class, 11);
        this.assertNotInCache(CachedEmployee.class, 13);
        this.assertNotInCache(CachedEmployee.class, 14);
        this.assertNotInCache(CachedManager.class, 12);
    }

    public void testContainsNullEntity() {
        try {
            this.emf.getCache().contains(null, (Object)1);
            TestJPACache.fail((String)"Expected ArgumentException when calling  contains(<null>, <nonNull>)");
        }
        catch (ArgumentException argumentException) {
            // empty catch block
        }
    }

    public void testContainsNonEntityClass() {
        try {
            this.emf.getCache().contains(Object.class, (Object)1);
            TestJPACache.fail((String)"Expected ArgumentException when calling contains(<nonEntityClass>, <nonNull>");
        }
        catch (ArgumentException argumentException) {
            // empty catch block
        }
    }

    public void testContainsNullPrimaryKey() {
        TestJPACache.assertFalse((boolean)this.emf.getCache().contains(CachedPerson.class, null));
    }

    public void testContainsNegativePrimaryKey() {
        TestJPACache.assertFalse((boolean)this.emf.getCache().contains(CachedPerson.class, (Object)-1));
    }

    public void testContainsInvalidPrimaryKeyType() {
        TestJPACache.assertFalse((boolean)this.emf.getCache().contains(CachedPerson.class, (Object)"abcd"));
    }

    public void testEvictNullInstance() {
        try {
            this.emf.getCache().evict(null, (Object)1);
            TestJPACache.fail((String)"Expected ArgumentException when calling evict(<null>, <id");
        }
        catch (ArgumentException argumentException) {
            // empty catch block
        }
    }

    public void testEvictNonEntityInstance() {
        try {
            this.emf.getCache().evict(Object.class, (Object)1);
            TestJPACache.fail((String)"Expected ArgumentException when calling evict(<null>, <id");
        }
        catch (ArgumentException argumentException) {
            // empty catch block
        }
    }

    public void testEvictNullPrimaryKey() {
        this.emf.getCache().evict(CachedPerson.class, null);
    }

    public void testEvictNegativePrimaryKey() {
        this.emf.getCache().evict(CachedPerson.class, (Object)-1);
    }

    public void testEvictInvalidPrimaryKeyType() {
        this.emf.getCache().evict(CachedPerson.class, (Object)"abcd");
    }

    public void testEvictNullClass() {
        try {
            this.emf.getCache().evict(null);
            TestJPACache.fail((String)"Expected ArgumentException when calling evict(<null>");
        }
        catch (ArgumentException argumentException) {
            // empty catch block
        }
    }

    public void testEvictNonEntity() {
        try {
            this.emf.getCache().evict(Object.class);
            TestJPACache.fail((String)"Expected ArgumentException when calling evict(<nonEntity>");
        }
        catch (ArgumentException argumentException) {
            // empty catch block
        }
    }

    public void testIllegalStateExceptionAfterClose() {
        this.emf.close();
        try {
            this.emf.getCache();
            TestJPACache.fail((String)"Expected IllegalStateException");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public void testIllegalStateExceptionGetAfterClose() {
        this.emf.getCache();
        this.emf.close();
        try {
            this.emf.getCache();
            TestJPACache.fail((String)"Expected IllegalStateException");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    private void assertInCache(Class<?> cls, Object primaryKey) {
        TestJPACache.assertTrue((String)String.format("%s:%s should exist in cache", cls.toString(), primaryKey.toString()), (boolean)this.emf.getCache().contains(cls, primaryKey));
    }

    private void assertNotInCache(Class<?> cls, Object primaryKey) {
        TestJPACache.assertFalse((String)String.format("%s:%s should not exist in cache", cls.toString(), primaryKey.toString()), (boolean)this.emf.getCache().contains(cls, primaryKey));
    }
}

