/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.datacache;

import java.util.HashMap;
import java.util.Map;
import org.apache.openjpa.persistence.OpenJPAEntityManagerFactorySPI;
import org.apache.openjpa.persistence.OpenJPAEntityManagerSPI;
import org.apache.openjpa.persistence.datacache.MapEmbeddable;
import org.apache.openjpa.persistence.datacache.MapHolder;
import org.apache.openjpa.persistence.test.AbstractCachedEMFTestCase;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestEntitiesAsKeys
extends AbstractCachedEMFTestCase {
    OpenJPAEntityManagerFactorySPI emf = this.createEMF(MapHolder.class, MapEmbeddable.class, "openjpa.DataCache", "true", "openjpa.RemoteCommitProvider", "sjvm", "openjpa.RuntimeUnenhancedClasses", "unsupported");

    public void setUp() {
        this.populate();
    }

    public void populate() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        em.getTransaction().begin();
        em.createQuery("Delete from MapHolder").executeUpdate();
        em.getTransaction().commit();
        em.getTransaction().begin();
        MapHolder mh = new MapHolder();
        mh.setId(10);
        mh.setEmbeddableMap(this.getEmbeddableMap(1, 2, 3, 4, 5, 6, 7, 8));
        em.persist((Object)mh);
        em.getTransaction().commit();
        em.close();
    }

    public void testMapContents() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        MapHolder mh = (MapHolder)em.find(MapHolder.class, (Object)10);
        mh.getEmbeddableMap();
        TestEntitiesAsKeys.assertNotNull((Object)mh);
        for (MapEmbeddable o : mh.getEmbeddableMap().keySet()) {
            TestEntitiesAsKeys.assertTrue((String)("Expected key to be instanceof MapEmbeddable but was " + o.getClass().getCanonicalName()), (boolean)(o instanceof MapEmbeddable));
        }
        for (MapEmbeddable o : mh.getEmbeddableMap().values()) {
            TestEntitiesAsKeys.assertTrue((String)("Expected value to be instanceof MapEmbeddable but was " + o.getClass().getCanonicalName()), (boolean)(o instanceof MapEmbeddable));
        }
        em.close();
    }

    private Map<MapEmbeddable, MapEmbeddable> getEmbeddableMap(Integer ... integers) {
        HashMap<MapEmbeddable, MapEmbeddable> rval = new HashMap<MapEmbeddable, MapEmbeddable>();
        TestEntitiesAsKeys.assertEquals((int)0, (int)(integers.length % 2));
        for (int i = 0; i < integers.length; i += 2) {
            rval.put(new MapEmbeddable(integers[i]), new MapEmbeddable(integers[i + 1]));
        }
        return rval;
    }
}

