/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.datacache;

import java.util.List;
import javax.persistence.EntityManager;
import org.apache.openjpa.persistence.OpenJPAEntityManagerFactorySPI;
import org.apache.openjpa.persistence.OpenJPAEntityManagerSPI;
import org.apache.openjpa.persistence.OpenJPAPersistence;
import org.apache.openjpa.persistence.StoreCacheImpl;
import org.apache.openjpa.persistence.datacache.common.apps.EmbeddedEntity;
import org.apache.openjpa.persistence.datacache.common.apps.EmbeddingOwnerEntity;
import org.apache.openjpa.persistence.test.SingleEMFTestCase;

public class TestEmbeddedCollection
extends SingleEMFTestCase {
    private static final int SIZE = 4;
    private static OpenJPAEntityManagerFactorySPI emf = null;

    public void setUp() throws Exception {
        if (emf == null) {
            super.setUp("openjpa.jdbc.SynchronizeMappings", "buildSchema", "openjpa.RuntimeUnenhancedClasses", "unsupported", "openjpa.DataCache", "true", "openjpa.RemoteCommitProvider", "sjvm", "openjpa.jdbc.UpdateManager", "constraint", EmbeddingOwnerEntity.class, EmbeddedEntity.class, CLEAR_TABLES);
            emf = ((SingleEMFTestCase)this).emf;
            this.createData();
        }
        TestEmbeddedCollection.assertNotNull((Object)emf);
        TestEmbeddedCollection.assertNotNull((Object)emf.getStoreCache());
        TestEmbeddedCollection.assertTrue((boolean)this.isDataCacheActive(emf));
    }

    boolean isDataCacheActive(OpenJPAEntityManagerFactorySPI emf) {
        return ((StoreCacheImpl)emf.getStoreCache()).getDelegate() != null && emf.getConfiguration().getDataCacheManagerInstance().getSystemDataCache() != null;
    }

    public void tearDown() throws Exception {
    }

    public void createData() {
        EmbeddingOwnerEntity owner = new EmbeddingOwnerEntity();
        for (int i = 0; i < 4; ++i) {
            EmbeddedEntity member = new EmbeddedEntity();
            member.setMarker("Member-" + i);
            owner.addMember(member);
        }
        OpenJPAEntityManagerSPI em = emf.createEntityManager();
        em.getTransaction().begin();
        em.persist((Object)owner);
        em.getTransaction().commit();
        Object id = OpenJPAPersistence.cast((EntityManager)em).getObjectId((Object)owner);
        em.clear();
        EmbeddingOwnerEntity test = (EmbeddingOwnerEntity)em.find(EmbeddingOwnerEntity.class, id);
        TestEmbeddedCollection.assertNotNull((Object)test);
        List<EmbeddedEntity> members = test.getMembers();
        TestEmbeddedCollection.assertNotNull(members);
        TestEmbeddedCollection.assertEquals((int)4, (int)members.size());
        for (int i = 0; i < 4; ++i) {
            members.get(i).getMarker().equals("Member-" + i);
        }
    }

    public void testRemoveMemberFromEmbeddedCollection() {
        OpenJPAEntityManagerSPI em = emf.createEntityManager();
        em.getTransaction().begin();
        List result = em.createQuery("SELECT p FROM EmbeddingOwnerEntity p").getResultList();
        TestEmbeddedCollection.assertNotNull((Object)result);
        TestEmbeddedCollection.assertFalse((boolean)result.isEmpty());
        EmbeddingOwnerEntity owner = (EmbeddingOwnerEntity)result.get(0);
        Long id = owner.getId();
        TestEmbeddedCollection.assertTrue((boolean)emf.getStoreCache().contains(EmbeddingOwnerEntity.class, (Object)id));
        List<EmbeddedEntity> members = owner.getMembers();
        members.remove(0);
        owner.removeMember(0);
        owner.removeMember(members.get(0));
        em.getTransaction().commit();
        TestEmbeddedCollection.assertEquals((int)owner.getMembers().size(), (int)1);
    }
}

