/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.datacache;

import javax.persistence.EntityManager;
import javax.persistence.LockModeType;
import org.apache.openjpa.persistence.EntityManagerImpl;
import org.apache.openjpa.persistence.EntityNotFoundException;
import org.apache.openjpa.persistence.OpenJPAEntityManagerFactorySPI;
import org.apache.openjpa.persistence.OpenJPAEntityManagerSPI;
import org.apache.openjpa.persistence.StoreCache;
import org.apache.openjpa.persistence.StoreCacheImpl;
import org.apache.openjpa.persistence.common.utils.AbstractTestCase;
import org.apache.openjpa.persistence.datacache.common.apps.PObject;
import org.apache.openjpa.persistence.querycache.common.apps.BidirectionalOne2OneOwned;
import org.apache.openjpa.persistence.querycache.common.apps.BidirectionalOne2OneOwner;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestDataCacheBehavesIdentical
extends AbstractTestCase {
    private static OpenJPAEntityManagerFactorySPI emfWithDataCache;
    private static OpenJPAEntityManagerFactorySPI emfWithoutDataCache;
    private static final boolean WITH_DATACACHE = true;
    private static final boolean CONSISTENT = true;
    private static final boolean DIRTY = true;
    private static final boolean REFRESH_FROM_DATACACHE = true;
    private static final LockModeType NOLOCK;
    private static final Class<?> ENTITY_NOT_FOUND_ERROR;
    private static final Class<?> NO_ERROR;
    private static final String MARKER_DATACACHE = "in DataCache";
    private static final String MARKER_DATABASE = "in Database";
    private static final String MARKER_CACHE = "in Object Cache";
    private static final String MARKER_DIRTY_CACHE = "in Object Cache (dirty)";
    private static long ID_COUNTER;

    public void setUp() throws Exception {
        super.setUp();
        if (emfWithDataCache == null) {
            emfWithDataCache = this.createEMF("openjpa.jdbc.SynchronizeMappings", "buildSchema", "openjpa.RuntimeUnenhancedClasses", "unsupported", "openjpa.DataCache", "true", "openjpa.RemoteCommitProvider", "sjvm", "openjpa.jdbc.UpdateManager", "constraint", PObject.class, BidirectionalOne2OneOwner.class, BidirectionalOne2OneOwned.class, CLEAR_TABLES);
            emfWithoutDataCache = this.createEMF("openjpa.RuntimeUnenhancedClasses", "unsupported", "openjpa.DataCache", "false", "openjpa.jdbc.UpdateManager", "constraint", PObject.class, BidirectionalOne2OneOwned.class, BidirectionalOne2OneOwner.class, CLEAR_TABLES);
            TestDataCacheBehavesIdentical.assertNotNull((Object)emfWithDataCache);
            TestDataCacheBehavesIdentical.assertNotNull((Object)emfWithoutDataCache);
            TestDataCacheBehavesIdentical.assertNotNull((Object)emfWithDataCache.getStoreCache());
            TestDataCacheBehavesIdentical.assertNotNull((Object)emfWithoutDataCache.getStoreCache());
            TestDataCacheBehavesIdentical.assertTrue((boolean)this.isDataCacheActive(emfWithDataCache));
            TestDataCacheBehavesIdentical.assertFalse((boolean)this.isDataCacheActive(emfWithoutDataCache));
        }
    }

    boolean isDataCacheActive(OpenJPAEntityManagerFactorySPI emf) {
        return ((StoreCacheImpl)emf.getStoreCache()).getDelegate() != null && emf.getConfiguration().getDataCacheManagerInstance().getSystemDataCache() != null;
    }

    public void createBidirectionalRelation(EntityManager em, long id, boolean consistent) {
        BidirectionalOne2OneOwner owner1 = new BidirectionalOne2OneOwner();
        BidirectionalOne2OneOwned owned1 = new BidirectionalOne2OneOwned();
        BidirectionalOne2OneOwner owner2 = new BidirectionalOne2OneOwner();
        BidirectionalOne2OneOwned owned2 = new BidirectionalOne2OneOwned();
        owner1.setId(id++);
        owned1.setId(id++);
        owner2.setId(id++);
        owned2.setId(id++);
        owner1.setName("Owner1");
        owned1.setName("Owned1");
        owned2.setName("Owned2");
        owner2.setName("Owner2");
        owner1.setOwned(owned1);
        owner2.setOwned(owned2);
        if (consistent) {
            owned1.setOwner(owner1);
            owned2.setOwner(owner2);
        } else {
            owned1.setOwner(owner2);
            owned2.setOwner(owner1);
        }
        em.getTransaction().begin();
        em.persist((Object)owner1);
        em.persist((Object)owned1);
        em.persist((Object)owner2);
        em.persist((Object)owned2);
        em.getTransaction().commit();
        em.clear();
    }

    public void verifyBidirectionalRelation(boolean useDataCache, boolean createConsistent, boolean expectConsistent) {
        OpenJPAEntityManagerSPI em = useDataCache ? emfWithDataCache.createEntityManager() : emfWithoutDataCache.createEntityManager();
        long id = ID_COUNTER++;
        ID_COUNTER += 4L;
        this.createBidirectionalRelation((EntityManager)em, id, createConsistent);
        BidirectionalOne2OneOwner owner1 = (BidirectionalOne2OneOwner)em.find(BidirectionalOne2OneOwner.class, (Object)id);
        BidirectionalOne2OneOwned owned1 = (BidirectionalOne2OneOwned)em.find(BidirectionalOne2OneOwned.class, (Object)(id + 1L));
        BidirectionalOne2OneOwner owner2 = (BidirectionalOne2OneOwner)em.find(BidirectionalOne2OneOwner.class, (Object)(id + 2L));
        BidirectionalOne2OneOwned owned2 = (BidirectionalOne2OneOwned)em.find(BidirectionalOne2OneOwned.class, (Object)(id + 3L));
        TestDataCacheBehavesIdentical.assertNotNull((Object)owner1);
        TestDataCacheBehavesIdentical.assertNotNull((Object)owner2);
        TestDataCacheBehavesIdentical.assertNotNull((Object)owned1);
        TestDataCacheBehavesIdentical.assertNotNull((Object)owned2);
        TestDataCacheBehavesIdentical.assertEquals((Object)owner1, (Object)(expectConsistent ? owner1.getOwned().getOwner() : owner2.getOwned().getOwner()));
        TestDataCacheBehavesIdentical.assertEquals((Object)owner2, (Object)(expectConsistent ? owner2.getOwned().getOwner() : owner1.getOwned().getOwner()));
        TestDataCacheBehavesIdentical.assertEquals((Object)owned1, (Object)owner1.getOwned());
        TestDataCacheBehavesIdentical.assertEquals((Object)(expectConsistent ? owner1 : owner2), (Object)owned1.getOwner());
        TestDataCacheBehavesIdentical.assertEquals((Object)owned2, (Object)owner2.getOwned());
        TestDataCacheBehavesIdentical.assertEquals((Object)(expectConsistent ? owner2 : owner1), (Object)owned2.getOwner());
    }

    public void testConsitentBidirectionalRelationIsPreservedWithDataCache() {
        this.verifyBidirectionalRelation(true, true, true);
    }

    public void testConsitentBidirectionalRelationIsPreservedWithoutDataCache() {
        this.verifyBidirectionalRelation(false, true, true);
    }

    public void testInconsitentBidirectionalRelationIsPreservedWithDataCache() {
        this.verifyBidirectionalRelation(true, false, false);
    }

    public void testInconsitentBidirectionalRelationIsNotPreservedWithoutDataCache() {
        this.verifyBidirectionalRelation(false, false, true);
    }

    public void verifyRefresh(boolean useDataCache, LockModeType lock, boolean makeDirtyBeforeRefresh, boolean refreshFromDataCache, String expected) {
        OpenJPAEntityManagerFactorySPI emf = useDataCache ? emfWithDataCache : emfWithoutDataCache;
        emf.getConfiguration().setRefreshFromDataCache(refreshFromDataCache);
        OpenJPAEntityManagerSPI em = emf.createEntityManager();
        em.getTransaction().begin();
        PObject pc = new PObject();
        pc.setName(useDataCache ? MARKER_DATACACHE : MARKER_CACHE);
        em.persist((Object)pc);
        em.getTransaction().commit();
        Long oid = pc.getId();
        StoreCache dataCache = emf.getStoreCache();
        TestDataCacheBehavesIdentical.assertEquals((boolean)useDataCache, (boolean)dataCache.contains(PObject.class, (Object)oid));
        em.getTransaction().begin();
        String sql = "UPDATE L2_PObject SET NAME='in Database' WHERE id=" + oid;
        em.createNativeQuery(sql).executeUpdate();
        em.getTransaction().commit();
        TestDataCacheBehavesIdentical.assertEquals((String)(useDataCache ? MARKER_DATACACHE : MARKER_CACHE), (String)pc.getName());
        em.getTransaction().begin();
        if (makeDirtyBeforeRefresh) {
            pc.setName(MARKER_DIRTY_CACHE);
        }
        TestDataCacheBehavesIdentical.assertEquals((boolean)makeDirtyBeforeRefresh, (boolean)em.isDirty((Object)pc));
        if (lock != null) {
            ((EntityManagerImpl)em).getFetchPlan().setReadLockMode(lock);
        }
        em.refresh((Object)pc);
        TestDataCacheBehavesIdentical.assertEquals((String)expected, (String)pc.getName());
        em.getTransaction().commit();
    }

    String getExpectedMarker(boolean useDataCache, LockModeType lock, boolean makeDirtyBeforeRefresh) {
        if (useDataCache) {
            return lock != null ? MARKER_DATABASE : MARKER_DATACACHE;
        }
        return MARKER_DATABASE;
    }

    public void testDirtyRefreshWithNoLockHitsDatabase() {
        this.verifyRefresh(true, NOLOCK, true, false, MARKER_DATABASE);
    }

    public void testDirtyRefreshWithNoLockHitsDataCache() {
        this.verifyRefresh(true, NOLOCK, true, true, MARKER_DATACACHE);
    }

    public void testCleanRefreshWithNoLockDoesNotHitDatabase() {
        this.verifyRefresh(true, NOLOCK, false, false, MARKER_DATACACHE);
    }

    public void testCleanRefreshWithNoLockHitsDataCache() {
        this.verifyRefresh(true, NOLOCK, false, true, MARKER_DATACACHE);
    }

    public void testDirtyRefreshWithReadLockHitsDatabase() {
        this.verifyRefresh(true, LockModeType.READ, true, true, MARKER_DATABASE);
        this.verifyRefresh(true, LockModeType.READ, true, false, MARKER_DATABASE);
    }

    public void testCleanRefreshWithReadLockDoesNotHitDatabase() {
        this.verifyRefresh(true, LockModeType.READ, false, true, MARKER_DATACACHE);
        this.verifyRefresh(true, LockModeType.READ, false, false, MARKER_DATACACHE);
    }

    public void testDirtyRefreshWithWriteLockHitsDatabase() {
        this.verifyRefresh(true, LockModeType.WRITE, true, true, MARKER_DATABASE);
        this.verifyRefresh(true, LockModeType.WRITE, true, false, MARKER_DATABASE);
    }

    public void testCleanRefreshWithWriteLockDoesNotHitDatabase() {
        this.verifyRefresh(true, LockModeType.WRITE, false, true, MARKER_DATACACHE);
        this.verifyRefresh(true, LockModeType.WRITE, false, false, MARKER_DATACACHE);
    }

    public void testDirtyRefreshWithoutDataCacheAlwaysHitsDatabase() {
        this.verifyRefresh(false, NOLOCK, true, true, MARKER_DATABASE);
        this.verifyRefresh(false, LockModeType.READ, true, true, MARKER_DATABASE);
        this.verifyRefresh(false, LockModeType.WRITE, true, true, MARKER_DATABASE);
        this.verifyRefresh(false, NOLOCK, true, false, MARKER_DATABASE);
        this.verifyRefresh(false, LockModeType.READ, true, false, MARKER_DATABASE);
        this.verifyRefresh(false, LockModeType.WRITE, true, false, MARKER_DATABASE);
    }

    public void testCleanRefreshWithoutDataCacheDoesNotHitDatabase() {
        this.verifyRefresh(false, NOLOCK, false, true, MARKER_CACHE);
        this.verifyRefresh(false, LockModeType.READ, false, true, MARKER_CACHE);
        this.verifyRefresh(false, LockModeType.WRITE, false, true, MARKER_CACHE);
        this.verifyRefresh(false, NOLOCK, false, false, MARKER_CACHE);
        this.verifyRefresh(false, LockModeType.READ, false, false, MARKER_CACHE);
        this.verifyRefresh(false, LockModeType.WRITE, false, false, MARKER_CACHE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void verifyDeleteDetectionOnRefresh(boolean useDataCache, boolean dirty, LockModeType lock, Class<?> expectedExceptionType) {
        OpenJPAEntityManagerFactorySPI emf = useDataCache ? emfWithDataCache : emfWithoutDataCache;
        OpenJPAEntityManagerSPI em = emf.createEntityManager();
        em.getTransaction().begin();
        PObject pc = new PObject();
        pc.setName(useDataCache ? MARKER_DATACACHE : MARKER_CACHE);
        em.persist((Object)pc);
        em.getTransaction().commit();
        Long oid = pc.getId();
        StoreCache dataCache = emf.getStoreCache();
        TestDataCacheBehavesIdentical.assertEquals((boolean)useDataCache, (boolean)dataCache.contains(PObject.class, (Object)oid));
        em.getTransaction().begin();
        String sql = "DELETE FROM L2_PObject WHERE id=" + oid;
        em.createNativeQuery(sql).executeUpdate();
        em.getTransaction().commit();
        TestDataCacheBehavesIdentical.assertTrue((boolean)em.contains((Object)pc));
        TestDataCacheBehavesIdentical.assertEquals((boolean)useDataCache, (boolean)dataCache.contains(PObject.class, (Object)oid));
        em.getTransaction().begin();
        em.getFetchPlan().setReadLockMode(lock);
        if (dirty) {
            pc.setName("Dirty Name");
        }
        try {
            em.refresh((Object)pc);
            if (expectedExceptionType != null) {
                TestDataCacheBehavesIdentical.fail((String)("expected " + expectedExceptionType.getSimpleName() + " for PObject:" + oid));
            }
        }
        catch (Exception ex) {
            boolean expectedException;
            boolean bl = expectedException = expectedExceptionType != null && expectedExceptionType.isAssignableFrom(ex.getClass());
            if (!expectedException) {
                ex.printStackTrace();
                String error = expectedExceptionType == null ? "no exception" : expectedExceptionType.getName();
                TestDataCacheBehavesIdentical.fail((String)("expected " + error + " for PObject:" + oid));
            }
        }
        finally {
            em.getTransaction().rollback();
        }
    }

    public void testDeleteIsNotDetectedOnCleanRefreshWithoutLockWithDataCache() {
        this.verifyDeleteDetectionOnRefresh(true, false, NOLOCK, NO_ERROR);
    }

    public void testDeleteIsDetectedOnCleanRefreshWithLockWithDataCache() {
        this.verifyDeleteDetectionOnRefresh(true, false, LockModeType.READ, ENTITY_NOT_FOUND_ERROR);
        this.verifyDeleteDetectionOnRefresh(true, false, LockModeType.WRITE, ENTITY_NOT_FOUND_ERROR);
    }

    public void testDeleteIsDetectedOnDirtyRefreshWithoutLockWithDataCache() {
        this.verifyDeleteDetectionOnRefresh(true, true, NOLOCK, ENTITY_NOT_FOUND_ERROR);
    }

    public void testDeleteIsDetectedOnDirtyRefreshWithLockWithDataCache() {
        this.verifyDeleteDetectionOnRefresh(true, true, LockModeType.READ, ENTITY_NOT_FOUND_ERROR);
        this.verifyDeleteDetectionOnRefresh(true, true, LockModeType.WRITE, ENTITY_NOT_FOUND_ERROR);
    }

    public void testDeleteIsDetectedOnDirtyRefreshWitDataCache() {
        this.verifyDeleteDetectionOnRefresh(true, true, LockModeType.READ, ENTITY_NOT_FOUND_ERROR);
        this.verifyDeleteDetectionOnRefresh(true, true, LockModeType.WRITE, ENTITY_NOT_FOUND_ERROR);
    }

    public void testDeleteIsDetectedOnCleanRefreshWithoutLockWithoutDataCache() {
        this.verifyDeleteDetectionOnRefresh(false, false, NOLOCK, ENTITY_NOT_FOUND_ERROR);
    }

    public void testDeleteIsDetectedOnCleanRefreshWithLockWithoutDataCache() {
        this.verifyDeleteDetectionOnRefresh(false, false, LockModeType.READ, ENTITY_NOT_FOUND_ERROR);
        this.verifyDeleteDetectionOnRefresh(false, false, LockModeType.WRITE, ENTITY_NOT_FOUND_ERROR);
    }

    static {
        NOLOCK = null;
        ENTITY_NOT_FOUND_ERROR = EntityNotFoundException.class;
        NO_ERROR = null;
        ID_COUNTER = System.currentTimeMillis();
    }
}

