/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.datacache;

import java.util.ArrayList;
import java.util.HashMap;
import javax.persistence.Persistence;
import javax.persistence.Query;
import org.apache.openjpa.jdbc.meta.ClassMapping;
import org.apache.openjpa.persistence.OpenJPAEntityManagerFactorySPI;
import org.apache.openjpa.persistence.OpenJPAEntityManagerSPI;
import org.apache.openjpa.persistence.StoreCache;
import org.apache.openjpa.persistence.datacache.Item;
import org.apache.openjpa.persistence.datacache.Order;
import org.apache.openjpa.persistence.datacache.Purchase;
import org.apache.openjpa.persistence.test.AbstractCachedEMFTestCase;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestCacheExclusions
extends AbstractCachedEMFTestCase {
    private OpenJPAEntityManagerFactorySPI emf = null;
    private static String[] ITEM_NAMES = new String[]{"Cup", "pen", "pencil", "phone", "laptop", "keyboard", "mouse"};
    private static final String _tSep = ";";
    Item[] items = new Item[ITEM_NAMES.length];
    Order o1;
    Order o2;
    Purchase p;

    public void populate() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        em.getTransaction().begin();
        int n = 0;
        for (String s : ITEM_NAMES) {
            this.items[n] = new Item();
            this.items[n].setName(s);
            this.items[n].setId(n);
            em.persist((Object)this.items[n++]);
        }
        this.p = new Purchase();
        this.p.setOrders(new ArrayList<Order>());
        this.o1 = new Order();
        this.o1.setItem((Item)em.find(Item.class, (Object)1));
        this.o1.setQuantity(2);
        this.o1.setPurchase(this.p);
        this.p.getOrders().add(this.o1);
        this.o2 = new Order();
        this.o2.setItem((Item)em.find(Item.class, (Object)4));
        this.o2.setQuantity(23);
        this.o2.setPurchase(this.p);
        this.p.getOrders().add(this.o2);
        em.persist((Object)this.p);
        em.getTransaction().commit();
        em.close();
    }

    @Override
    public void tearDown() throws Exception {
        if (this.emf != null) {
            OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
            em.getTransaction().begin();
            for (ClassMapping mapping : (ClassMapping[])this.emf.getConfiguration().getMetaDataRepositoryInstance().getMetaDatas()) {
                Query q = em.createNativeQuery("DROP TABLE " + mapping.getTable().getName());
                q.executeUpdate();
            }
            em.getTransaction().commit();
            em.close();
            this.emf.close();
        }
        this.emf = null;
        super.tearDown();
    }

    public void testCacheAll() {
        this.getEntityManagerFactoryCacheSettings(null, null);
        this.populate();
        StoreCache cache = this.emf.getStoreCache();
        this.assertCacheContents(cache, true, true, true);
    }

    public void testCacheItems() {
        this.getEntityManagerFactoryCacheSettings(new Class[]{Item.class}, null);
        this.populate();
        StoreCache cache = this.emf.getStoreCache();
        this.assertCacheContents(cache, false, false, true);
    }

    public void testCacheItemsAndPurchases() {
        this.getEntityManagerFactoryCacheSettings(new Class[]{Item.class, Purchase.class}, null);
        this.populate();
        StoreCache cache = this.emf.getStoreCache();
        this.assertCacheContents(cache, true, false, true);
    }

    public void testCacheItemsAndOrders() {
        this.getEntityManagerFactoryCacheSettings(new Class[]{Item.class, Order.class}, null);
        this.populate();
        StoreCache cache = this.emf.getStoreCache();
        this.assertCacheContents(cache, false, true, true);
    }

    public void testCachePurchasesAndOrders() {
        this.getEntityManagerFactoryCacheSettings(new Class[]{Purchase.class, Order.class}, null);
        this.populate();
        StoreCache cache = this.emf.getStoreCache();
        this.assertCacheContents(cache, true, true, false);
    }

    public void testExcludePurchases() {
        this.getEntityManagerFactoryCacheSettings(null, new Class[]{Purchase.class});
        this.populate();
        StoreCache cache = this.emf.getStoreCache();
        this.assertCacheContents(cache, false, true, true);
    }

    public void testExcludeOrders() {
        this.getEntityManagerFactoryCacheSettings(null, new Class[]{Order.class});
        this.populate();
        StoreCache cache = this.emf.getStoreCache();
        this.assertCacheContents(cache, true, false, true);
    }

    public void testExcludeItems() {
        this.getEntityManagerFactoryCacheSettings(null, new Class[]{Item.class});
        this.populate();
        StoreCache cache = this.emf.getStoreCache();
        this.assertCacheContents(cache, true, true, false);
    }

    public void testExcludeOrdersAndPurchases() {
        this.getEntityManagerFactoryCacheSettings(null, new Class[]{Order.class, Purchase.class});
        this.populate();
        StoreCache cache = this.emf.getStoreCache();
        this.assertCacheContents(cache, false, false, true);
    }

    public void testIncludePurchaseItemExcludePurchase() {
        try {
            this.getEntityManagerFactoryCacheSettings(new Class[]{Purchase.class, Item.class}, new Class[]{Purchase.class});
            this.populate();
            TestCacheExclusions.fail((String)"Shouldn't be able to create an EMF with an entity in both Types and ExcludedTypes");
            StoreCache cache = this.emf.getStoreCache();
            this.assertCacheContents(cache, false, false, true);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public OpenJPAEntityManagerFactorySPI getEntityManagerFactoryCacheSettings(Class<?>[] includedTypes, Class<?>[] excludedTypes) {
        StringBuilder includes = new StringBuilder();
        if (includedTypes != null && includedTypes.length > 0) {
            includes.append("Types=");
            for (Class<?> c : includedTypes) {
                includes.append(c.getName());
                includes.append(_tSep);
            }
            includes.setLength(includes.length() - 1);
        }
        StringBuilder excludes = new StringBuilder();
        if (excludedTypes != null && excludedTypes.length > 0) {
            excludes.append("ExcludedTypes=");
            for (Class<?> c : excludedTypes) {
                excludes.append(c.getName());
                excludes.append(_tSep);
            }
            excludes.setLength(excludes.length() - 1);
        }
        StringBuilder dataCacheSettings = new StringBuilder();
        boolean hasIncludeOrExclude = includes.length() > 0 || excludes.length() > 0;
        dataCacheSettings.append("true" + (hasIncludeOrExclude ? "(" : ""));
        if (hasIncludeOrExclude) {
            dataCacheSettings.append((CharSequence)includes);
            if (includes.length() > 0 && excludes.length() > 0) {
                dataCacheSettings.append(",");
            }
            dataCacheSettings.append((CharSequence)excludes);
            dataCacheSettings.append(")");
        }
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("openjpa.DataCache", dataCacheSettings.toString());
        props.put("openjpa.RemoteCommitProvider", "sjvm");
        props.put("openjpa.MetaDataFactory", "jpa(Types=" + Item.class.getName() + _tSep + Purchase.class.getName() + _tSep + Order.class.getName() + ")");
        this.emf = (OpenJPAEntityManagerFactorySPI)Persistence.createEntityManagerFactory((String)"test", props);
        return this.emf;
    }

    public void assertCacheContents(StoreCache cache, boolean expectPurchase, boolean expectOrders, boolean expectItems) {
        TestCacheExclusions.assertEquals((String)("Expected purchases to " + (expectPurchase ? "" : "not ") + "exist in the cache"), (boolean)expectPurchase, (boolean)cache.contains(Purchase.class, (Object)this.p.getId()));
        TestCacheExclusions.assertEquals((String)("Expected Orders to " + (expectOrders ? "" : "not ") + "exist in the cache"), (boolean)expectOrders, (boolean)cache.contains(Order.class, (Object)this.o1.getId()));
        TestCacheExclusions.assertEquals((String)("Expected Orders to " + (expectOrders ? "" : "not ") + "exist in the cache"), (boolean)expectOrders, (boolean)cache.contains(Order.class, (Object)this.o2.getId()));
        for (int i = 0; i < ITEM_NAMES.length; ++i) {
            TestCacheExclusions.assertEquals((String)("Expected Items to " + (expectItems ? "" : "not ") + "exist in the cache"), (boolean)expectItems, (boolean)cache.contains(Item.class, (Object)this.items[i].getId()));
        }
    }
}

