/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.datacache;

import java.util.Arrays;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import org.apache.openjpa.datacache.DataCache;
import org.apache.openjpa.datacache.DataCachePCData;
import org.apache.openjpa.meta.ClassMetaData;
import org.apache.openjpa.persistence.JPAFacadeHelper;
import org.apache.openjpa.persistence.OpenJPAEntityManagerSPI;
import org.apache.openjpa.persistence.OpenJPAPersistence;
import org.apache.openjpa.persistence.StoreCacheImpl;
import org.apache.openjpa.persistence.simple.AllFieldTypes;
import org.apache.openjpa.persistence.test.SingleEMFTestCase;

public class TestArrayFieldsInDataCache
extends SingleEMFTestCase {
    private static final String[] STRINGS = new String[]{"a", "b", "c"};
    private static final int[] INTS = new int[]{1, 2, 3};
    private Object jpaOid;
    private Object internalOid;

    public void setUp() {
        this.setUp("openjpa.DataCache", "true", "openjpa.RemoteCommitProvider", "sjvm", AllFieldTypes.class);
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        em.getTransaction().begin();
        AllFieldTypes aft = new AllFieldTypes();
        aft.setArrayOfStrings(STRINGS);
        aft.setArrayOfInts(INTS);
        em.persist((Object)aft);
        em.getTransaction().commit();
        this.jpaOid = OpenJPAPersistence.cast((EntityManager)em).getObjectId((Object)aft);
        this.internalOid = JPAFacadeHelper.toBroker((EntityManager)em).getObjectId((Object)aft);
        em.close();
    }

    public void testArrayOfStrings() {
        StoreCacheImpl storeCache = (StoreCacheImpl)OpenJPAPersistence.cast((EntityManagerFactory)this.emf).getStoreCache();
        DataCache cache = storeCache.getDelegate();
        DataCachePCData data = cache.get(this.internalOid);
        ClassMetaData meta = JPAFacadeHelper.getMetaData((EntityManagerFactory)this.emf, AllFieldTypes.class);
        Object cachedFieldData = data.getData(meta.getField("arrayOfStrings").getIndex());
        TestArrayFieldsInDataCache.assertTrue((boolean)cachedFieldData.getClass().isArray());
        TestArrayFieldsInDataCache.assertEquals(String.class, cachedFieldData.getClass().getComponentType());
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        AllFieldTypes aft = (AllFieldTypes)em.find(AllFieldTypes.class, this.jpaOid);
        TestArrayFieldsInDataCache.assertTrue((boolean)Arrays.equals(STRINGS, aft.getArrayOfStrings()));
        TestArrayFieldsInDataCache.assertNotSame((Object)STRINGS, (Object)aft.getArrayOfStrings());
        em.close();
    }

    public void testArrayOfInts() {
        StoreCacheImpl storeCache = (StoreCacheImpl)OpenJPAPersistence.cast((EntityManagerFactory)this.emf).getStoreCache();
        DataCache cache = storeCache.getDelegate();
        DataCachePCData data = cache.get(this.internalOid);
        ClassMetaData meta = JPAFacadeHelper.getMetaData((EntityManagerFactory)this.emf, AllFieldTypes.class);
        Object cachedFieldData = data.getData(meta.getField("arrayOfInts").getIndex());
        TestArrayFieldsInDataCache.assertTrue((boolean)cachedFieldData.getClass().isArray());
        TestArrayFieldsInDataCache.assertEquals(Integer.TYPE, cachedFieldData.getClass().getComponentType());
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        AllFieldTypes aft = (AllFieldTypes)em.find(AllFieldTypes.class, this.jpaOid);
        TestArrayFieldsInDataCache.assertTrue((boolean)Arrays.equals(INTS, aft.getArrayOfInts()));
        TestArrayFieldsInDataCache.assertNotSame((Object)INTS, (Object)aft.getArrayOfInts());
        em.close();
    }
}

