/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.criteria;

import java.util.HashMap;
import java.util.Map;
import javax.persistence.CollectionTable;
import javax.persistence.Column;
import javax.persistence.ElementCollection;
import javax.persistence.Embedded;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.MapKeyJoinColumn;
import javax.persistence.Table;
import org.apache.openjpa.persistence.criteria.Address;
import org.apache.openjpa.persistence.criteria.Movie;

@Entity
@Table(name="CR_VSTR")
public class VideoStore {
    @Id
    @GeneratedValue
    private int id;
    private String name;
    @Embedded
    private Address location;
    @ElementCollection
    @CollectionTable(name="INVENTORY", joinColumns={@JoinColumn(name="STORE")})
    @Column(name="COPIES_IN_STOCK")
    @MapKeyJoinColumn(name="MOVIE", referencedColumnName="ID")
    private Map<Movie, Integer> videoInventory = new HashMap<Movie, Integer>();

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Map getVideoInventory() {
        return this.videoInventory;
    }

    public void addToVideoInventory(Movie movie, Integer inventory) {
        this.videoInventory.put(movie, inventory);
    }

    public Address getLocation() {
        return this.location;
    }

    public void setLocation(Address location) {
        this.location = location;
    }
}

