/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.criteria;

import javax.persistence.criteria.CollectionJoin;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Join;
import javax.persistence.criteria.JoinType;
import javax.persistence.criteria.ListJoin;
import javax.persistence.criteria.MapJoin;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import javax.persistence.criteria.SetJoin;
import javax.persistence.metamodel.Bindable;
import org.apache.openjpa.persistence.criteria.A;
import org.apache.openjpa.persistence.criteria.A_;
import org.apache.openjpa.persistence.criteria.B;
import org.apache.openjpa.persistence.criteria.B_;
import org.apache.openjpa.persistence.criteria.C;
import org.apache.openjpa.persistence.criteria.C_;
import org.apache.openjpa.persistence.criteria.D;
import org.apache.openjpa.persistence.criteria.D_;
import org.apache.openjpa.persistence.criteria.JoinDomainTestCase;

public class TestJoinCondition
extends JoinDomainTestCase {
    public void testSingleAttributeJoinModel() {
        CriteriaQuery cq = this.cb.createQuery();
        Root a = cq.from(A.class);
        Join b = a.join(A_.b);
        TestJoinCondition.assertTrue((boolean)(b.getModel() instanceof Bindable));
        TestJoinCondition.assertSame(B.class, (Object)b.getJavaType());
    }

    public void testCollectionJoinModel() {
        CriteriaQuery cq = this.cb.createQuery();
        Root c = cq.from(C.class);
        CollectionJoin d = c.join(C_.coll);
        TestJoinCondition.assertSame(D.class, (Object)d.getJavaType());
    }

    public void testSetJoinModel() {
        CriteriaQuery cq = this.cb.createQuery();
        Root c = cq.from(C.class);
        SetJoin d = c.join(C_.set);
        TestJoinCondition.assertSame(D.class, (Object)d.getJavaType());
    }

    public void testListJoinModel() {
        CriteriaQuery cq = this.cb.createQuery();
        Root c = cq.from(C.class);
        ListJoin d = c.join(C_.list);
        TestJoinCondition.assertSame(D.class, (Object)d.getJavaType());
    }

    public void testInnerJoinSingleAttributeWithoutCondition() {
        String jpql = "select a from A a INNER JOIN a.b b";
        CriteriaQuery c = this.cb.createQuery(A.class);
        c.from(A.class).join(A_.b, JoinType.INNER);
        this.assertEquivalence(c, jpql);
    }

    public void testCrossJoinWithoutCondition() {
        String jpql = "select a from A a, C c";
        CriteriaQuery cq = this.cb.createQuery(A.class);
        Root a = cq.from(A.class);
        Root c = cq.from(C.class);
        cq.select((Selection)a);
        this.assertEquivalence(cq, jpql);
    }

    public void testCrossJoinWithoutCondition1() {
        String jpql = "select a, c from A a, C c";
        CriteriaQuery cq = this.cb.createQuery();
        Root a = cq.from(A.class);
        Root c = cq.from(C.class);
        cq.multiselect(new Selection[]{a, c});
        this.assertEquivalence(cq, jpql);
    }

    public void testCrossJoin() {
        String jpql = "select a from A a, C c where a.name=c.name";
        CriteriaQuery cq = this.cb.createQuery(A.class);
        Root a = cq.from(A.class);
        Root c = cq.from(C.class);
        cq.where((Expression)this.cb.equal((Expression)a.get(A_.name), (Expression)c.get(C_.name)));
        cq.select((Selection)a);
        this.assertEquivalence(cq, jpql);
    }

    public void testInnerJoinSingleAttribute() {
        String jpql = "select a from A a INNER JOIN a.b b WHERE a.id=b.age";
        CriteriaQuery cq = this.cb.createQuery(A.class);
        Root a = cq.from(A.class);
        Join b = a.join(A_.b);
        cq.where((Expression)this.cb.equal((Expression)a.get(A_.id), (Expression)b.get(B_.age)));
        this.assertEquivalence(cq, jpql);
    }

    public void testOuterJoinSingleAttributeWithoutCondition() {
        String jpql = "select a from A a LEFT JOIN a.b b";
        CriteriaQuery cq = this.cb.createQuery(A.class);
        Root a = cq.from(A.class);
        Join b = a.join(A_.b, JoinType.LEFT);
        this.assertEquivalence(cq, jpql);
    }

    public void testOuterJoinSingleAttribute() {
        String jpql = "select a from A a LEFT JOIN a.b b where a.id=b.age";
        CriteriaQuery cq = this.cb.createQuery(A.class);
        Root a = cq.from(A.class);
        Join b = a.join(A_.b, JoinType.LEFT);
        cq.where((Expression)this.cb.equal((Expression)a.get(A_.id), (Expression)b.get(B_.age)));
        this.assertEquivalence(cq, jpql);
    }

    public void testSetJoinWithoutCondition() {
        String jpql = "select c from C c JOIN c.set d";
        CriteriaQuery c = this.cb.createQuery(C.class);
        c.from(C.class).join(C_.set);
        this.assertEquivalence(c, jpql);
    }

    public void testListJoinWithoutCondition() {
        String jpql = "select c from C c JOIN c.list d";
        CriteriaQuery c = this.cb.createQuery(C.class);
        c.from(C.class).join(C_.list);
        this.assertEquivalence(c, jpql);
    }

    public void testCollectionJoinWithoutCondition() {
        String jpql = "select c from C c JOIN c.coll d";
        CriteriaQuery c = this.cb.createQuery(C.class);
        c.from(C.class).join(C_.coll);
        this.assertEquivalence(c, jpql);
    }

    public void testMapJoinWithoutCondition() {
        String jpql = "select c from C c JOIN c.map d";
        CriteriaQuery c = this.cb.createQuery(C.class);
        c.from(C.class).join(C_.map);
        this.assertEquivalence(c, jpql);
    }

    public void testKeyExpression() {
        String jpql = "select c from C c JOIN c.map d where KEY(d)=33";
        CriteriaQuery cq = this.cb.createQuery(C.class);
        Root c = cq.from(C.class);
        MapJoin d = c.join(C_.map);
        cq.where((Expression)this.cb.equal((Expression)d.key(), (Object)33));
        this.assertEquivalence(cq, jpql);
    }

    public void testValueExpression() {
        String jpql = "select c from C c JOIN c.map d where VALUE(d).name='xy'";
        CriteriaQuery cq = this.cb.createQuery(C.class);
        Root c = cq.from(C.class);
        MapJoin d = c.join(C_.map);
        cq.where((Expression)this.cb.equal((Expression)d.value().get(D_.name), (Object)"xy"));
        this.assertEquivalence(cq, jpql);
    }

    public void testFetchJoin() {
        String jpql = "select a from A a JOIN FETCH a.b";
        CriteriaQuery cq = this.cb.createQuery(A.class);
        Root a = cq.from(A.class);
        a.fetch(A_.b);
        this.assertEquivalence(cq, jpql);
    }

    public void testOuterFetchJoin() {
        String jpql = "select a from A a LEFT JOIN FETCH a.b";
        CriteriaQuery cq = this.cb.createQuery(A.class);
        Root a = cq.from(A.class);
        a.fetch(A_.b, JoinType.LEFT);
        this.assertEquivalence(cq, jpql);
    }
}

