/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.criteria;

import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.List;
import javax.persistence.Query;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Order;
import javax.persistence.criteria.Root;
import org.apache.openjpa.kernel.Filters;
import org.apache.openjpa.persistence.criteria.AbstractCriteriaTestCase;
import org.apache.openjpa.persistence.criteria.CriteriaTest;
import org.apache.openjpa.persistence.criteria.Dependent;
import org.apache.openjpa.persistence.criteria.DependentId;
import org.apache.openjpa.persistence.criteria.Dependent_;
import org.apache.openjpa.persistence.criteria.OpenJPACriteriaQuery;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestDateStringConversion
extends CriteriaTest {
    private static final String OPEN_BRACKET = "{";
    private static final String CLOSE_BRACKET = "}";
    private static final String SINGLE_QUOTE = "'";

    void createData(String name) {
        long now = System.currentTimeMillis();
        long tomorrow = now + 86400000L + 1L;
        Date date = new Date(tomorrow);
        DependentId id = new DependentId();
        id.setEffDate(date);
        id.setName(name);
        Dependent pc = new Dependent();
        pc.setId(id);
        pc.setEndDate(date);
        this.em.getTransaction().begin();
        this.em.persist((Object)pc);
        this.em.getTransaction().commit();
    }

    public void testDateString() {
        this.createData("testDateString");
        long now = System.currentTimeMillis();
        String dateString = this.createJDBCEscapeString(new Date(now));
        String tsString = this.createJDBCEscapeString(new Timestamp(now));
        String jpql = "select d from Dependent d where d.endDate >= " + tsString + " ORDER BY d.endDate";
        OpenJPACriteriaQuery c = this.cb.createQuery(Dependent.class);
        Root d = c.from(Dependent.class);
        c.where((Expression)this.cb.greaterThanOrEqualTo((Expression)d.get(Dependent_.endDate), this.cb.literal((Object)dateString).as(Date.class)));
        c.orderBy(new Order[]{this.cb.asc((Expression)d.get(Dependent_.endDate))});
        this.assertSameResult((CriteriaQuery<Dependent>)c, jpql);
    }

    public void testDateStringAsParameter() {
        this.createData("testDateStringAsParameter");
        long now = System.currentTimeMillis();
        Date earlier = new Date(now - 1000L);
        final String dateString = this.createJDBCEscapeString(earlier);
        String jpql = "select d from Dependent d where d.endDate >= :dateString ORDER BY d.endDate";
        OpenJPACriteriaQuery c = this.cb.createQuery(Dependent.class);
        Root d = c.from(Dependent.class);
        c.where((Expression)this.cb.greaterThanOrEqualTo((Expression)d.get(Dependent_.endDate), this.cb.parameter(String.class, "dateString").as(Date.class)));
        c.orderBy(new Order[]{this.cb.asc((Expression)d.get(Dependent_.endDate))});
        this.assertEquivalence(new AbstractCriteriaTestCase.QueryDecorator(){

            public void decorate(Query q) {
                q.setParameter("dateString", (Object)dateString);
            }
        }, (CriteriaQuery<?>)c, jpql);
    }

    String createJDBCEscapeString(Object time) {
        String key = "";
        if (time instanceof Date) {
            key = "d ";
        } else if (time instanceof Time) {
            key = "t ";
        } else if (time instanceof Timestamp) {
            key = "ts ";
        } else {
            TestDateStringConversion.fail((String)("Wrong object " + time + " of " + time.getClass() + " for JDBC conversion"));
        }
        return OPEN_BRACKET + key + SINGLE_QUOTE + time.toString() + SINGLE_QUOTE + CLOSE_BRACKET;
    }

    public void testJDBCEscapeSyntaxTimestamp() {
        Timestamp ts = new Timestamp(System.currentTimeMillis());
        String s = "{ts '" + ts.toString() + "'}";
        TestDateStringConversion.assertTrue((boolean)Filters.isJDBCTemporalSyntax((String)s));
        TestDateStringConversion.assertNotNull((Object)Filters.parseJDBCTemporalSyntax((String)s));
        Object converted = Filters.convert((Object)s, Timestamp.class);
        TestDateStringConversion.assertTrue((boolean)(converted instanceof Timestamp));
        TestDateStringConversion.assertEquals((String)("Original=" + s + " Converted " + converted), (String)ts.toString(), (String)converted.toString());
    }

    public void testJDBCEscapeSyntaxTime() {
        Time t = new Time(System.currentTimeMillis());
        String s = "{t '" + t.toString() + "'}";
        TestDateStringConversion.assertTrue((boolean)Filters.isJDBCTemporalSyntax((String)s));
        TestDateStringConversion.assertNotNull((Object)Filters.parseJDBCTemporalSyntax((String)s));
        Object converted = Filters.convert((Object)s, Time.class);
        TestDateStringConversion.assertTrue((boolean)(converted instanceof Time));
        TestDateStringConversion.assertEquals((String)("Original=" + s + " Converted " + converted), (String)t.toString(), (String)converted.toString());
    }

    public void testJDBCEscapeSyntaxDate() {
        Date d = new Date(System.currentTimeMillis());
        String s = "{d '" + d.toString() + "'}";
        TestDateStringConversion.assertTrue((boolean)Filters.isJDBCTemporalSyntax((String)s));
        TestDateStringConversion.assertNotNull((Object)Filters.parseJDBCTemporalSyntax((String)s));
        Object converted = Filters.convert((Object)s, Date.class);
        TestDateStringConversion.assertTrue((boolean)(converted instanceof Date));
        TestDateStringConversion.assertEquals((String)("Original=" + s + " Converted " + converted), (String)d.toString(), (String)converted.toString());
    }

    void assertSameResult(CriteriaQuery<Dependent> c, String jpql) {
        List jResult = this.em.createQuery(jpql).getResultList();
        List cResult = this.em.createQuery(c).getResultList();
        TestDateStringConversion.assertFalse((boolean)jResult.isEmpty());
        TestDateStringConversion.assertEquals((int)cResult.size(), (int)jResult.size());
        for (int i = 0; i < jResult.size(); ++i) {
            TestDateStringConversion.assertEquals((Object)((Dependent)jResult.get(i)).getEndDate(), (Object)((Dependent)cResult.get(i)).getEndDate());
        }
    }
}

