/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.criteria;

import java.io.IOException;
import java.io.StreamTokenizer;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StringComparison {
    private static List<String> _reserved = Arrays.asList("ALL", "AND", "ANY", "AS", "ASC", "AVG", "BETWEEN", "BIT_LENGTH", "BY", "CASE", "CHAR_LENGTH", "CHARACTER_LENGTH", "CLASS", "COALESCE", "COUNT", "CURRENT_DATE", "CURRENT_TIME", "CURRENT_TIMESTAMP", "DELETE", "DESC", "DISTINCT", "EMPTY", "ENTRY", "EXISTS", "FALSE", "FETCH", "FROM", "GROUP", "HAVING", "IN", "INDEX", "INNER", "IS", "JOIN", "KEY", "LEFT", "LIKE", "LOWER", "MAX", "MEMBER", "MIN", "MOD", "NEW", "NOT", "NULL", "NULLIF", "OBJECT", "OF", "OR", "ORDER", "OUTER", "POSITION", "SELECT", "SOME", "SUM", "THEN", "TRIM", "TRUE", "TYPE", "UNKNOWN", "UPDATE", "UPPER", "VALUE", "WHEN", "WHERE");

    private boolean isReservedWord(String s) {
        return _reserved.contains(s.toUpperCase());
    }

    public List<String> tokenize(String s) throws IOException {
        int ttype;
        ArrayList<String> list = new ArrayList<String>();
        StreamTokenizer tok = new StreamTokenizer(new StringReader(s));
        tok.resetSyntax();
        tok.wordChars(97, 122);
        tok.wordChars(48, 57);
        tok.wordChars(65, 90);
        tok.wordChars(39, 39);
        tok.wordChars(61, 61);
        tok.wordChars(62, 62);
        tok.wordChars(60, 60);
        tok.wordChars(33, 33);
        tok.wordChars(46, 46);
        while ((ttype = tok.nextToken()) != -1) {
            if (ttype != -3) continue;
            list.add(tok.sval);
        }
        return list;
    }

    public boolean compare(String s1, String s2) {
        try {
            List<String> list1 = this.tokenize(s1);
            List<String> list2 = this.tokenize(s2);
            if (list1.size() != list2.size()) {
                System.err.println("Unequal tokens " + list1.size() + "!=" + list2.size());
                return false;
            }
            for (int i = 0; i < list1.size(); ++i) {
                boolean match;
                String a = list1.get(i);
                String b = list2.get(i);
                boolean bl = match = this.isReservedWord(a) ? a.equalsIgnoreCase(b) : a.equals(b);
                if (match) continue;
                System.err.println("[" + a + "] does not match [" + b + "]");
                return false;
            }
            return true;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    public static void main(String[] args) throws Exception {
        StringComparison c = new StringComparison();
        String s1 = "SELECT DISTINCT o FROM Order AS o JOIN o.lineItems AS l WHERE l.shipped != FALSE and l.name like 'hello'";
        String s2 = "select DISTINCT o FROM Order AS o  JOIN o.lineItems AS  l WHERE l.shipped !=  FALSE and l.name like 'hello'";
        boolean match = c.compare(s1, s2);
        if (!match) {
            System.err.println(s1);
            System.err.println(c.tokenize(s1));
            System.err.println(s2);
            System.err.println(c.tokenize(s2));
        }
    }
}

