/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.conf;

import java.util.HashMap;
import javax.persistence.EntityExistsException;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.RollbackException;
import org.apache.openjpa.persistence.ArgumentException;
import org.apache.openjpa.persistence.conf.Person;
import org.apache.openjpa.persistence.test.AbstractPersistenceTestCase;

public class TestSwitchConnection
extends AbstractPersistenceTestCase {
    private String defaultJndiName = "jdbc/mocked";
    private String[] jndiNames = new String[]{"jdbc/mocked1"};

    protected void init(String cfName) {
        EntityManagerFactory emf = this.getEmf("openjpa.ConnectionFactoryName", cfName, true);
        EntityManager em = emf.createEntityManager();
        em.getTransaction().begin();
        em.createQuery("Delete from confPerson").executeUpdate();
        em.getTransaction().commit();
        em.close();
        emf.close();
    }

    protected void setUp() {
        this.init(this.defaultJndiName);
        this.init(this.jndiNames[0]);
    }

    protected EntityManagerFactory getEmf(String cfPropertyName, String cfPropertyValue) {
        return this.getEmf(cfPropertyName, cfPropertyValue, false);
    }

    protected EntityManagerFactory getEmf(String cfPropertyName, String cfPropertyValue, boolean syncMappings) {
        if (syncMappings) {
            return this.createEMF("openjpa.jdbc.SynchronizeMappings", "buildSchema", "openjpa.ConnectionDriverName", "", cfPropertyName, cfPropertyValue);
        }
        return this.createEMF("openjpa.ConnectionDriverName", "", cfPropertyName, cfPropertyValue);
    }

    protected EntityManager getEm(EntityManagerFactory emf, String name, String value) {
        HashMap<String, String> props = new HashMap<String, String>();
        props.put(name, value);
        return emf.createEntityManager(props);
    }

    public String getPersistenceUnitName() {
        return "TestCfSwitching";
    }

    public void testConnectionFactoryName() {
        this.overridePropertyOnEM("openjpa.ConnectionFactoryName", this.jndiNames[0]);
    }

    public void testJtaDataSource() {
        this.overridePropertyOnEM("javax.persistence.jtaDataSource", this.jndiNames[0]);
    }

    public void overridePropertyOnEM(String name, String value) {
        EntityManagerFactory emf = this.getEmf(name, this.defaultJndiName);
        TestSwitchConnection.assertNotNull((Object)emf);
        EntityManager em = emf.createEntityManager();
        TestSwitchConnection.assertNotNull((Object)em);
        EntityManager em1 = this.getEm(emf, name, value);
        TestSwitchConnection.assertNotNull((Object)em1);
        em.getTransaction().begin();
        em.persist((Object)new Person(1, "em"));
        em.getTransaction().commit();
        em1.getTransaction().begin();
        em1.persist((Object)new Person(1, "em1"));
        em1.getTransaction().commit();
        em.clear();
        em1.clear();
        Person p = (Person)em.find(Person.class, (Object)1);
        Person p1 = (Person)em1.find(Person.class, (Object)1);
        TestSwitchConnection.assertNotSame((Object)p, (Object)p1);
        TestSwitchConnection.assertEquals((String)"em", (String)p.getName());
        TestSwitchConnection.assertEquals((String)"em1", (String)p1.getName());
        em.clear();
        em1.clear();
        em.getTransaction().begin();
        em.persist((Object)new Person(1));
        try {
            em.getTransaction().commit();
            TestSwitchConnection.fail((String)"Should not be able to commit the same row a second time");
        }
        catch (RollbackException rbe) {
            TestSwitchConnection.assertTrue((boolean)(rbe.getCause() instanceof EntityExistsException));
        }
        em1.getTransaction().begin();
        em1.persist((Object)new Person(1));
        try {
            em1.getTransaction().commit();
            TestSwitchConnection.fail((String)"Should not be able to commit the same row a second time");
        }
        catch (RollbackException rbe) {
            TestSwitchConnection.assertTrue((boolean)(rbe.getCause() instanceof EntityExistsException));
        }
        em.close();
        em1.close();
        emf.close();
    }

    public void testInvalidCfName() throws Exception {
        EntityManagerFactory emf = null;
        try {
            emf = this.getEmf("openjpa.ConnectionFactoryName", this.defaultJndiName);
            this.getEm(emf, "openjpa.ConnectionFactoryName", "jdbc/NotReal");
            TestSwitchConnection.fail((String)"Expected an excepton when creating an EM with a bogus JNDI name");
        }
        catch (ArgumentException e) {
            TestSwitchConnection.assertTrue((boolean)e.isFatal());
            TestSwitchConnection.assertTrue((boolean)e.getMessage().contains("jdbc/NotReal"));
            TestSwitchConnection.assertTrue((boolean)e.getMessage().contains("EntityManager"));
        }
    }

    public void testDataCache() {
        EntityManagerFactory emf = null;
        emf = this.getEmf("openjpa.DataCache", "true");
        try {
            this.getEm(emf, "openjpa.ConnectionFactoryName", "jdbc/NotReal");
            TestSwitchConnection.fail((String)"Expected an excepton when creating an EM with a bogus JNDI name");
        }
        catch (ArgumentException e) {
            TestSwitchConnection.assertTrue((boolean)e.isFatal());
            TestSwitchConnection.assertTrue((boolean)e.getMessage().contains("jdbc/NotReal"));
            TestSwitchConnection.assertTrue((boolean)e.getMessage().contains("L2 Cache"));
        }
    }

    public void testQueryCache() {
        EntityManagerFactory emf = null;
        emf = this.getEmf("openjpa.QueryCache", "true");
        try {
            this.getEm(emf, "openjpa.ConnectionFactoryName", "jdbc/NotReal");
            TestSwitchConnection.fail((String)"Expected an excepton when creating an EM with a bogus JNDI name");
        }
        catch (ArgumentException e) {
            TestSwitchConnection.assertTrue((boolean)e.isFatal());
            TestSwitchConnection.assertTrue((boolean)e.getMessage().contains("jdbc/NotReal"));
            TestSwitchConnection.assertTrue((boolean)e.getMessage().contains("openjpa.QueryCache"));
        }
    }

    public void testSyncMappings() {
        EntityManagerFactory emf = null;
        emf = this.getEmf("openjpa.jdbc.SynchronizeMappings", "buildSchema");
        try {
            this.getEm(emf, "openjpa.ConnectionFactoryName", "jdbc/NotReal");
            TestSwitchConnection.fail((String)"Expected an excepton when creating an EM with a bogus JNDI name");
        }
        catch (ArgumentException e) {
            TestSwitchConnection.assertTrue((boolean)e.isFatal());
            TestSwitchConnection.assertTrue((boolean)e.getMessage().contains("jdbc/NotReal"));
            TestSwitchConnection.assertTrue((boolean)e.getMessage().contains("openjpa.jdbc.SynchronizeMappings"));
        }
    }
}

