/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.compat;

import org.apache.openjpa.conf.OpenJPAVersion;
import org.apache.openjpa.persistence.OpenJPAEntityManagerSPI;
import org.apache.openjpa.persistence.OpenJPAQuery;
import org.apache.openjpa.persistence.callbacks.Message;
import org.apache.openjpa.persistence.callbacks.MessageListenerImpl;
import org.apache.openjpa.persistence.test.SingleEMFTestCase;

public class TestMessageListener
extends SingleEMFTestCase {
    public void setUp() {
        this.setUp(Message.class, "openjpa.Compatibility", "default", DROP_TABLES);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testUpdateInPreUpdate() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        try {
            em.getTransaction().begin();
            MessageListenerImpl.resetCounters();
            Message message = new Message("Hello Persistence!");
            TestMessageListener.assertNull((String)"Test message's created field to be null.", (Object)message.getCreated());
            TestMessageListener.assertNull((String)"Test message's updated field to be null.", (Object)message.getUpdated());
            em.persist((Object)message);
            this.assertStatus(1, 0, 0, 0, 0, 0, 0);
            TestMessageListener.assertNotNull((String)"Test message's created field being set.", (Object)message.getCreated());
            TestMessageListener.assertNotNull((String)"Test message's updated field being set.", (Object)message.getUpdated());
            OpenJPAQuery q = em.createQuery("select m from Message m where m.id=" + message.getId());
            Message m = (Message)q.getSingleResult();
            TestMessageListener.assertEquals((String)"Test first expected message.", (String)"Hello Persistence!", (String)m.getMessage());
            TestMessageListener.assertNotNull((String)"Test message's created field being set.", (Object)m.getCreated());
            TestMessageListener.assertNotNull((String)"Test message's updated field being set.", (Object)m.getUpdated());
            this.assertStatus(1, 1, 0, 0, 0, 0, 0);
            message = new Message("Hello Persistence 2!");
            TestMessageListener.assertNull((String)"Test message's created field to be null.", (Object)message.getCreated());
            TestMessageListener.assertNull((String)"Test message's updated field to be null.", (Object)message.getUpdated());
            em.persist((Object)message);
            this.assertStatus(2, 1, 0, 0, 0, 0, 0);
            TestMessageListener.assertNotNull((String)"Test message's created field being set.", (Object)message.getCreated());
            TestMessageListener.assertNotNull((String)"Test message's updated field being set.", (Object)message.getUpdated());
            em.getTransaction().commit();
            if (OpenJPAVersion.MAJOR_RELEASE >= 2 || OpenJPAVersion.MAJOR_RELEASE == 1 && OpenJPAVersion.MINOR_RELEASE >= 3) {
                this.assertStatus(2, 2, 0, 0, 0, 0, 0);
            } else {
                this.assertStatus(2, 2, 1, 1, 0, 0, 0);
            }
            em.getTransaction().begin();
            message = (Message)em.find(Message.class, (Object)message.getId());
            message.setMessage("Update field and trigger pre/postUpdate");
            em.getTransaction().commit();
            if (OpenJPAVersion.MAJOR_RELEASE >= 2 || OpenJPAVersion.MAJOR_RELEASE == 1 && OpenJPAVersion.MINOR_RELEASE >= 3) {
                this.assertStatus(2, 2, 1, 1, 0, 0, 0);
            } else {
                this.assertStatus(2, 2, 2, 2, 0, 0, 0);
            }
        }
        finally {
            if (em != null && em.getTransaction().isActive()) {
                em.getTransaction().rollback();
            }
            if (em != null && em.isOpen()) {
                em.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testUpdateInPreUpdate2() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        try {
            em.getTransaction().begin();
            MessageListenerImpl.resetCounters();
            Message message = new Message("Hello Persistence!");
            TestMessageListener.assertNull((String)"Test message's created field to be null.", (Object)message.getCreated());
            TestMessageListener.assertNull((String)"Test message's updated field to be null.", (Object)message.getUpdated());
            em.persist((Object)message);
            this.assertStatus(1, 0, 0, 0, 0, 0, 0);
            TestMessageListener.assertNotNull((String)"Test message's created field being set.", (Object)message.getCreated());
            TestMessageListener.assertNotNull((String)"Test message's updated field being set.", (Object)message.getUpdated());
            OpenJPAQuery q = em.createQuery("select m from Message m where m.id=" + message.getId());
            Message m = (Message)q.getSingleResult();
            TestMessageListener.assertEquals((String)"Test first expected message.", (String)"Hello Persistence!", (String)m.getMessage());
            TestMessageListener.assertNotNull((String)"Test message's created field being set.", (Object)m.getCreated());
            TestMessageListener.assertNotNull((String)"Test message's updated field being set.", (Object)m.getUpdated());
            this.assertStatus(1, 1, 0, 0, 0, 0, 0);
            message = new Message("Hello Persistence 2!");
            TestMessageListener.assertNull((String)"Test message's created field to be null.", (Object)message.getCreated());
            TestMessageListener.assertNull((String)"Test message's updated field to be null.", (Object)message.getUpdated());
            em.persist((Object)message);
            this.assertStatus(2, 1, 0, 0, 0, 0, 0);
            TestMessageListener.assertNotNull((String)"Test message's created field being set.", (Object)message.getCreated());
            TestMessageListener.assertNotNull((String)"Test message's updated field being set.", (Object)message.getUpdated());
            message.setMessage("Combined Create and Update triggers");
            if (OpenJPAVersion.MAJOR_RELEASE >= 2 || OpenJPAVersion.MAJOR_RELEASE == 1 && OpenJPAVersion.MINOR_RELEASE >= 3) {
                this.assertStatus(2, 1, 0, 0, 0, 0, 0);
            } else {
                this.assertStatus(2, 1, 1, 1, 0, 0, 0);
            }
            em.getTransaction().commit();
            if (OpenJPAVersion.MAJOR_RELEASE >= 2 || OpenJPAVersion.MAJOR_RELEASE == 1 && OpenJPAVersion.MINOR_RELEASE >= 3) {
                this.assertStatus(2, 2, 0, 0, 0, 0, 0);
            } else {
                this.assertStatus(2, 2, 1, 1, 0, 0, 0);
            }
            em.getTransaction().begin();
            message = (Message)em.find(Message.class, (Object)message.getId());
            message.setMessage("Update field and trigger pre/postUpdate");
            em.getTransaction().commit();
            if (OpenJPAVersion.MAJOR_RELEASE >= 2 || OpenJPAVersion.MAJOR_RELEASE == 1 && OpenJPAVersion.MINOR_RELEASE >= 3) {
                this.assertStatus(2, 2, 1, 1, 0, 0, 0);
            } else {
                this.assertStatus(2, 2, 2, 2, 0, 0, 0);
            }
        }
        finally {
            if (em != null && em.getTransaction().isActive()) {
                em.getTransaction().rollback();
            }
            if (em != null && em.isOpen()) {
                em.close();
            }
        }
    }

    private void assertStatus(int prePersist, int postPersist, int preUpdate, int postUpdate, int preRemove, int postRemove, int postLoad) {
        TestMessageListener.assertEquals((String)"prePersist", (int)prePersist, (int)MessageListenerImpl.prePersistCount);
        TestMessageListener.assertEquals((String)"postPersist", (int)postPersist, (int)MessageListenerImpl.postPersistCount);
        TestMessageListener.assertEquals((String)"preUpdate", (int)preUpdate, (int)MessageListenerImpl.preUpdateCount);
        TestMessageListener.assertEquals((String)"postUpdate", (int)postUpdate, (int)MessageListenerImpl.postUpdateCount);
        TestMessageListener.assertEquals((String)"preRemove", (int)preRemove, (int)MessageListenerImpl.preRemoveCount);
        TestMessageListener.assertEquals((String)"postRemove", (int)postRemove, (int)MessageListenerImpl.postRemoveCount);
        TestMessageListener.assertEquals((String)"postLoad", (int)postLoad, (int)MessageListenerImpl.postLoadCount);
    }
}

