/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.compat;

import java.util.ArrayList;
import java.util.Collection;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.IdClass;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import org.apache.openjpa.persistence.compat.DepartmentId;
import org.apache.openjpa.persistence.compat.FullTimeEmployee;
import org.apache.openjpa.persistence.compat.PartTimeEmployee;
import org.apache.openjpa.persistence.jdbc.ElementClassCriteria;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Entity
@Table(name="DEPT")
@IdClass(value=DepartmentId.class)
public class Department {
    @Id
    private String name;
    @OneToMany(mappedBy="dept", cascade={CascadeType.PERSIST})
    @ElementClassCriteria
    private Collection<PartTimeEmployee> partTimeEmployees;
    @OneToMany(mappedBy="dept", cascade={CascadeType.PERSIST})
    @ElementClassCriteria
    private Collection<FullTimeEmployee> fullTimeEmployees;

    public Collection<FullTimeEmployee> getFullTimeEmployees() {
        return this.fullTimeEmployees;
    }

    public void addEmployee(FullTimeEmployee e) {
        if (this.fullTimeEmployees == null) {
            this.fullTimeEmployees = new ArrayList<FullTimeEmployee>();
        }
        this.fullTimeEmployees.add(e);
        e.setDept(this);
    }

    public Collection<PartTimeEmployee> getPartTimeEmployees() {
        return this.partTimeEmployees;
    }

    public void addEmployee(PartTimeEmployee e) {
        if (this.partTimeEmployees == null) {
            this.partTimeEmployees = new ArrayList<PartTimeEmployee>();
        }
        this.partTimeEmployees.add(e);
        e.setDept(this);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }
}

