/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.common.utils;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.apache.openjpa.lib.log.LogFactoryImpl;
import org.apache.openjpa.persistence.common.utils.AbstractTestCase;

public class BufferedLogFactory
extends LogFactoryImpl {
    private int bufferSize = 10000;
    private List buffer = new ArrayList();
    private List disallowedMessages = new LinkedList();

    protected LogFactoryImpl.LogImpl newLogImpl() {
        return new BufferedLog();
    }

    public List getBuffer() {
        return Collections.unmodifiableList(this.buffer);
    }

    public void clear() {
        this.buffer.clear();
    }

    public void clearDisallowedMessages() {
        this.disallowedMessages.clear();
    }

    public void addDisallowedMessage(String regexp) {
        this.disallowedMessages.add(regexp);
    }

    public boolean removeDisallowedMessage(String regexp) {
        return this.disallowedMessages.remove(regexp);
    }

    public List getDisallowedMessages() {
        return Collections.unmodifiableList(this.disallowedMessages);
    }

    public void assertLogMessage(String regex) {
        AbstractTestCase.assertMatches(regex, this.getBuffer());
    }

    public void assertNoLogMessage(String regex) {
        AbstractTestCase.assertNotMatches(regex, this.getBuffer());
    }

    public void setBufferSize(int bufferSize) {
        this.bufferSize = bufferSize;
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    public class BufferedLog
    extends LogFactoryImpl.LogImpl {
        public BufferedLog() {
            super((LogFactoryImpl)BufferedLogFactory.this);
        }

        protected void log(short level, String message, Throwable t) {
            super.log(level, message, t);
            BufferedLogFactory.this.buffer.add(message);
            while (BufferedLogFactory.this.buffer.size() > BufferedLogFactory.this.getBufferSize()) {
                BufferedLogFactory.this.buffer.iterator().remove();
            }
            if (BufferedLogFactory.this.disallowedMessages.size() > 0) {
                for (String regex : BufferedLogFactory.this.disallowedMessages) {
                    AbstractTestCase.assertNotMatches(regex, message);
                }
            }
        }
    }
}

