/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.callbacks;

import java.util.HashSet;
import javax.persistence.EntityManager;
import javax.persistence.RollbackException;
import org.apache.openjpa.enhance.PersistenceCapable;
import org.apache.openjpa.persistence.OpenJPAEntityManagerSPI;
import org.apache.openjpa.persistence.OpenJPAPersistence;
import org.apache.openjpa.persistence.callbacks.ExceptionsFromCallbacksEntity;
import org.apache.openjpa.persistence.test.SingleEMFTestCase;

public class TestExceptionsFromCallbacks
extends SingleEMFTestCase {
    public static boolean testRunning = false;

    public void setUp() {
        HashSet<String> needEnhancement = new HashSet<String>();
        needEnhancement.add("testPostUpdateExceptionDuringFlushWithNewInstance");
        needEnhancement.add("testPreUpdateExceptionDuringFlushWithExistingFlushedInstance");
        needEnhancement.add("testPreUpdateExceptionDuringCommitWithExistingFlushedInstance");
        needEnhancement.add("testPostUpdateExceptionDuringFlushWithExistingFlushedInstance");
        needEnhancement.add("testPostUpdateExceptionDuringCommitWithExistingFlushedInstance");
        if (!PersistenceCapable.class.isAssignableFrom(ExceptionsFromCallbacksEntity.class) && needEnhancement.contains(this.getName())) {
            TestExceptionsFromCallbacks.fail((String)"this test method does not work without enhancement");
        }
        this.setUp(ExceptionsFromCallbacksEntity.class, CLEAR_TABLES);
        testRunning = true;
    }

    public void tearDown() throws Exception {
        testRunning = false;
        super.tearDown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testPrePersistException() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        em.getTransaction().begin();
        ExceptionsFromCallbacksEntity o = new ExceptionsFromCallbacksEntity();
        o.setThrowOnPrePersist(true);
        try {
            em.persist((Object)o);
            TestExceptionsFromCallbacks.fail((String)"persist should have failed");
        }
        catch (ExceptionsFromCallbacksEntity.CallbackTestException cte) {
            TestExceptionsFromCallbacks.assertTrue((boolean)em.getTransaction().isActive());
            TestExceptionsFromCallbacks.assertTrue((boolean)em.getTransaction().getRollbackOnly());
        }
        finally {
            if (em.getTransaction().isActive()) {
                em.getTransaction().rollback();
            }
            em.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testPrePersistExceptionOnMerge() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        em.getTransaction().begin();
        ExceptionsFromCallbacksEntity o = new ExceptionsFromCallbacksEntity();
        o.setThrowOnPrePersist(true);
        try {
            em.merge((Object)o);
            TestExceptionsFromCallbacks.fail((String)"merge should have failed");
        }
        catch (ExceptionsFromCallbacksEntity.CallbackTestException cte) {
            TestExceptionsFromCallbacks.assertTrue((boolean)em.getTransaction().isActive());
            TestExceptionsFromCallbacks.assertTrue((boolean)em.getTransaction().getRollbackOnly());
        }
        finally {
            if (em.getTransaction().isActive()) {
                em.getTransaction().rollback();
            }
            em.close();
        }
    }

    public void testPostPersistExceptionDuringFlush() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        em.getTransaction().begin();
        ExceptionsFromCallbacksEntity o = new ExceptionsFromCallbacksEntity();
        o.setThrowOnPostPersist(true);
        em.persist((Object)o);
        this.mutateAndFlush((EntityManager)em, o);
    }

    private void mutateAndFlush(EntityManager em, ExceptionsFromCallbacksEntity o) {
        o.setStringField("foo");
        this.flush(em);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void flush(EntityManager em) {
        try {
            em.flush();
            TestExceptionsFromCallbacks.fail((String)"flush should have failed");
        }
        catch (ExceptionsFromCallbacksEntity.CallbackTestException cte) {
            TestExceptionsFromCallbacks.assertTrue((boolean)em.getTransaction().isActive());
            TestExceptionsFromCallbacks.assertTrue((boolean)em.getTransaction().getRollbackOnly());
        }
        finally {
            if (em.getTransaction().isActive()) {
                em.getTransaction().rollback();
            }
            em.close();
        }
    }

    public void testPostPersistExceptionDuringCommit() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        em.getTransaction().begin();
        ExceptionsFromCallbacksEntity o = new ExceptionsFromCallbacksEntity();
        o.setThrowOnPostPersist(true);
        em.persist((Object)o);
        this.mutateAndCommit((EntityManager)em, o);
    }

    private void mutateAndCommit(EntityManager em, ExceptionsFromCallbacksEntity o) {
        o.setStringField("foo");
        this.commit(em);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void commit(EntityManager em) {
        try {
            em.getTransaction().commit();
            TestExceptionsFromCallbacks.fail((String)"commit should have failed");
        }
        catch (RollbackException re) {
            TestExceptionsFromCallbacks.assertEquals(ExceptionsFromCallbacksEntity.CallbackTestException.class, re.getCause().getClass());
            TestExceptionsFromCallbacks.assertFalse((boolean)em.getTransaction().isActive());
        }
        finally {
            if (em.getTransaction().isActive()) {
                em.getTransaction().rollback();
            }
            em.close();
        }
    }

    public void testPrePersistExceptionDuringFlushWithNewFlushedInstance() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        em.getTransaction().begin();
        ExceptionsFromCallbacksEntity o = new ExceptionsFromCallbacksEntity();
        em.persist((Object)o);
        em.flush();
        o.setThrowOnPrePersist(true);
        o.setStringField("foo");
        em.flush();
        em.getTransaction().commit();
        em.close();
    }

    public void testPrePersistExceptionDuringCommitWithNewFlushedInstance() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        em.getTransaction().begin();
        ExceptionsFromCallbacksEntity o = new ExceptionsFromCallbacksEntity();
        em.persist((Object)o);
        em.flush();
        o.setThrowOnPrePersist(true);
        o.setStringField("foo");
        em.getTransaction().commit();
        em.close();
    }

    public void testPostPersistExceptionDuringFlushWithNewFlushedInstance() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        em.getTransaction().begin();
        ExceptionsFromCallbacksEntity o = new ExceptionsFromCallbacksEntity();
        em.persist((Object)o);
        em.flush();
        o.setThrowOnPostPersist(true);
        o.setStringField("foo");
        em.flush();
        em.getTransaction().commit();
        em.close();
    }

    public void testPostPersistExceptionDuringCommitWithNewFlushedInstance() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        em.getTransaction().begin();
        ExceptionsFromCallbacksEntity o = new ExceptionsFromCallbacksEntity();
        em.persist((Object)o);
        em.flush();
        o.setThrowOnPostPersist(true);
        o.setStringField("foo");
        em.getTransaction().commit();
        em.close();
    }

    public void testPreUpdateExceptionWithNewInstance() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        em.getTransaction().begin();
        ExceptionsFromCallbacksEntity o = new ExceptionsFromCallbacksEntity();
        o.setThrowOnPreUpdate(true);
        em.persist((Object)o);
        o.setStringField("foo");
        em.getTransaction().commit();
        em.close();
    }

    public void testPostUpdateExceptionDuringFlushWithNewInstance() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        em.getTransaction().begin();
        ExceptionsFromCallbacksEntity o = new ExceptionsFromCallbacksEntity();
        o.setThrowOnPostUpdate(true);
        em.persist((Object)o);
        o.setStringField("foo");
        em.flush();
        em.getTransaction().commit();
        em.close();
    }

    public void testPostUpdateExceptionDuringCommitWithNewInstance() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        em.getTransaction().begin();
        ExceptionsFromCallbacksEntity o = new ExceptionsFromCallbacksEntity();
        o.setThrowOnPostUpdate(true);
        em.persist((Object)o);
        o.setStringField("foo");
        em.getTransaction().commit();
        em.close();
    }

    public void testPreUpdateExceptionDuringFlushWithNewFlushedInstance() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        em.getTransaction().begin();
        ExceptionsFromCallbacksEntity o = new ExceptionsFromCallbacksEntity();
        em.persist((Object)o);
        em.flush();
        o.setThrowOnPreUpdate(true);
        this.mutateAndFlush((EntityManager)em, o);
    }

    public void testPreUpdateExceptionDuringCommitWithNewFlushedInstance() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        em.getTransaction().begin();
        ExceptionsFromCallbacksEntity o = new ExceptionsFromCallbacksEntity();
        em.persist((Object)o);
        em.flush();
        o.setThrowOnPreUpdate(true);
        this.mutateAndCommit((EntityManager)em, o);
    }

    public void testPostUpdateExceptionDuringFlushWithNewFlushedInstance() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        em.getTransaction().begin();
        ExceptionsFromCallbacksEntity o = new ExceptionsFromCallbacksEntity();
        em.persist((Object)o);
        em.flush();
        o.setThrowOnPostUpdate(true);
        this.mutateAndFlush((EntityManager)em, o);
    }

    public void testPostUpdateExceptionDuringCommitWithNewFlushedInstance() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        em.getTransaction().begin();
        ExceptionsFromCallbacksEntity o = new ExceptionsFromCallbacksEntity();
        em.persist((Object)o);
        em.flush();
        o.setThrowOnPostUpdate(true);
        this.mutateAndCommit((EntityManager)em, o);
    }

    public void testPreUpdateExceptionDuringFlushWithExistingInstance() {
        Object oid = this.insert("new instance");
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        em.getTransaction().begin();
        ExceptionsFromCallbacksEntity o = (ExceptionsFromCallbacksEntity)em.find(ExceptionsFromCallbacksEntity.class, oid);
        o.setThrowOnPreUpdate(true);
        this.mutateAndFlush((EntityManager)em, o);
    }

    private Object insert(String s) {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        em.getTransaction().begin();
        ExceptionsFromCallbacksEntity o = new ExceptionsFromCallbacksEntity();
        o.setStringField(s);
        em.persist((Object)o);
        em.getTransaction().commit();
        em.close();
        return o.getId();
    }

    public void testPreUpdateExceptionDuringCommitWithExistingInstance() {
        Object oid = this.insert("new instance");
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        em.getTransaction().begin();
        ExceptionsFromCallbacksEntity o = (ExceptionsFromCallbacksEntity)em.find(ExceptionsFromCallbacksEntity.class, oid);
        o.setThrowOnPreUpdate(true);
        this.mutateAndCommit((EntityManager)em, o);
    }

    public void testPostUpdateExceptionDuringFlushWithExistingInstance() {
        Object oid = this.insert("new instance");
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        em.getTransaction().begin();
        ExceptionsFromCallbacksEntity o = (ExceptionsFromCallbacksEntity)em.find(ExceptionsFromCallbacksEntity.class, oid);
        o.setThrowOnPostUpdate(true);
        this.mutateAndFlush((EntityManager)em, o);
    }

    public void testPostUpdateExceptionDuringCommitWithExistingInstance() {
        Object oid = this.insert("new instance");
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        em.getTransaction().begin();
        ExceptionsFromCallbacksEntity o = (ExceptionsFromCallbacksEntity)em.find(ExceptionsFromCallbacksEntity.class, oid);
        o.setThrowOnPostUpdate(true);
        this.mutateAndCommit((EntityManager)em, o);
    }

    public void testPreUpdateExceptionDuringFlushWithExistingFlushedInstance() {
        Object oid = this.insert("new instance");
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        em.getTransaction().begin();
        ExceptionsFromCallbacksEntity o = (ExceptionsFromCallbacksEntity)em.find(ExceptionsFromCallbacksEntity.class, oid);
        o.setStringField("foo");
        em.flush();
        o.setThrowOnPreUpdate(true);
        em.flush();
        em.getTransaction().commit();
        em.close();
    }

    public void testPreUpdateExceptionDuringCommitWithExistingFlushedInstance() {
        Object oid = this.insert("new instance");
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        em.getTransaction().begin();
        ExceptionsFromCallbacksEntity o = (ExceptionsFromCallbacksEntity)em.find(ExceptionsFromCallbacksEntity.class, oid);
        o.setStringField("foo");
        em.flush();
        o.setThrowOnPreUpdate(true);
        em.getTransaction().commit();
        em.close();
    }

    public void testPostUpdateExceptionDuringFlushWithExistingFlushedInstance() {
        Object oid = this.insert("new instance");
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        em.getTransaction().begin();
        ExceptionsFromCallbacksEntity o = (ExceptionsFromCallbacksEntity)em.find(ExceptionsFromCallbacksEntity.class, oid);
        o.setStringField("foo");
        em.flush();
        o.setThrowOnPostUpdate(true);
        em.flush();
        em.getTransaction().commit();
        em.close();
    }

    public void testPostUpdateExceptionDuringCommitWithExistingFlushedInstance() {
        Object oid = this.insert("new instance");
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        em.getTransaction().begin();
        ExceptionsFromCallbacksEntity o = (ExceptionsFromCallbacksEntity)em.find(ExceptionsFromCallbacksEntity.class, oid);
        o.setStringField("foo");
        em.flush();
        o.setThrowOnPostUpdate(true);
        em.getTransaction().commit();
        em.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testPostLoadException() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        em.getTransaction().begin();
        ExceptionsFromCallbacksEntity o = new ExceptionsFromCallbacksEntity();
        o.setThrowOnPostLoad(true);
        em.persist((Object)o);
        em.getTransaction().commit();
        Object oid = OpenJPAPersistence.cast((EntityManager)em).getObjectId((Object)o);
        em.close();
        em = this.emf.createEntityManager();
        em.getTransaction().begin();
        try {
            em.find(ExceptionsFromCallbacksEntity.class, oid);
            TestExceptionsFromCallbacks.fail((String)"find should have failed");
        }
        catch (ExceptionsFromCallbacksEntity.CallbackTestException cte) {
            TestExceptionsFromCallbacks.assertTrue((boolean)em.getTransaction().isActive());
            TestExceptionsFromCallbacks.assertTrue((boolean)em.getTransaction().getRollbackOnly());
        }
        finally {
            if (em.getTransaction().isActive()) {
                em.getTransaction().rollback();
            }
            em.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testPreDeleteException() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        em.getTransaction().begin();
        ExceptionsFromCallbacksEntity o = new ExceptionsFromCallbacksEntity();
        em.persist((Object)o);
        em.flush();
        o.setThrowOnPreRemove(true);
        try {
            em.remove((Object)o);
        }
        catch (ExceptionsFromCallbacksEntity.CallbackTestException cte) {
            TestExceptionsFromCallbacks.assertTrue((boolean)em.getTransaction().isActive());
            TestExceptionsFromCallbacks.assertTrue((boolean)em.getTransaction().getRollbackOnly());
        }
        finally {
            if (em.getTransaction().isActive()) {
                em.getTransaction().rollback();
            }
            em.close();
        }
    }

    public void testPostDeleteExceptionDuringFlush() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        em.getTransaction().begin();
        ExceptionsFromCallbacksEntity o = new ExceptionsFromCallbacksEntity();
        em.persist((Object)o);
        em.flush();
        o.setThrowOnPostRemove(true);
        try {
            em.remove((Object)o);
        }
        catch (ExceptionsFromCallbacksEntity.CallbackTestException e) {
            em.getTransaction().rollback();
            em.close();
            TestExceptionsFromCallbacks.fail((String)"PostRemove is being called too soon (before SQL is issued)");
        }
        this.flush((EntityManager)em);
    }

    public void testPostDeleteExceptionDuringCommit() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        em.getTransaction().begin();
        ExceptionsFromCallbacksEntity o = new ExceptionsFromCallbacksEntity();
        em.persist((Object)o);
        em.flush();
        o.setThrowOnPostRemove(true);
        try {
            em.remove((Object)o);
        }
        catch (ExceptionsFromCallbacksEntity.CallbackTestException e) {
            em.getTransaction().rollback();
            em.close();
            TestExceptionsFromCallbacks.fail((String)"PostRemove is being called too soon (before SQL is issued)");
        }
        this.commit((EntityManager)em);
    }

    public void testPreDeleteExceptionDoubleDelete() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        em.getTransaction().begin();
        ExceptionsFromCallbacksEntity o = new ExceptionsFromCallbacksEntity();
        em.persist((Object)o);
        em.flush();
        em.remove((Object)o);
        em.flush();
        o.setThrowOnPreRemove(true);
        em.remove((Object)o);
        em.getTransaction().commit();
        em.close();
    }

    public void testPostDeleteExceptionDuringFlushDoubleDelete() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        em.getTransaction().begin();
        ExceptionsFromCallbacksEntity o = new ExceptionsFromCallbacksEntity();
        em.persist((Object)o);
        em.flush();
        em.remove((Object)o);
        em.flush();
        o.setThrowOnPostRemove(true);
        em.remove((Object)o);
        em.flush();
        em.getTransaction().commit();
        em.close();
    }

    public void testPostDeleteExceptionDuringCommitDoubleDelete() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        em.getTransaction().begin();
        ExceptionsFromCallbacksEntity o = new ExceptionsFromCallbacksEntity();
        em.persist((Object)o);
        em.flush();
        em.remove((Object)o);
        em.flush();
        o.setThrowOnPostRemove(true);
        em.remove((Object)o);
        em.getTransaction().commit();
        em.close();
    }
}

