/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.callbacks;

import java.util.Date;
import javax.persistence.PostLoad;
import javax.persistence.PostPersist;
import javax.persistence.PostRemove;
import javax.persistence.PostUpdate;
import javax.persistence.PrePersist;
import javax.persistence.PreRemove;
import javax.persistence.PreUpdate;
import org.apache.openjpa.persistence.callbacks.Message;

public class MessageListenerImpl {
    public static int prePersistCount;
    public static int postPersistCount;
    public static int preUpdateCount;
    public static int postUpdateCount;
    public static int preRemoveCount;
    public static int postRemoveCount;
    public static int postLoadCount;

    @PrePersist
    public void prePersist(Object o) {
        ++prePersistCount;
        if (o instanceof Message) {
            ((Message)o).setCreated(new Date());
            ((Message)o).setUpdated(new Date());
        }
    }

    @PostPersist
    public void postPersist(Object o) {
        ++postPersistCount;
    }

    @PostLoad
    public void postLoad(Object o) {
        ++postLoadCount;
    }

    @PreUpdate
    public void preUpdate(Object o) {
        ++preUpdateCount;
        if (o instanceof Message) {
            ((Message)o).setUpdated(new Date());
        }
    }

    @PostUpdate
    public void postUpdate(Object o) {
        ++postUpdateCount;
    }

    @PreRemove
    public void preRemove(Object o) {
        ++preRemoveCount;
    }

    @PostRemove
    public void postRemove(Object o) {
        ++postRemoveCount;
    }

    public static void resetCounters() {
        prePersistCount = 0;
        postPersistCount = 0;
        preUpdateCount = 0;
        postUpdateCount = 0;
        preRemoveCount = 0;
        postRemoveCount = 0;
        postLoadCount = 0;
    }

    public static String getStates() {
        return "prePersistCount = " + prePersistCount + ", postPersistCount = " + postPersistCount + ", preUpdateCount = " + preUpdateCount + ", postUpdateCount = " + postUpdateCount + ", preRemoveCount = " + preRemoveCount + ", postRemoveCount = " + postRemoveCount + ", postLoadCount = " + postLoadCount;
    }
}

