/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.callbacks;

import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.PostLoad;
import javax.persistence.PostPersist;
import javax.persistence.PostRemove;
import javax.persistence.PostUpdate;
import javax.persistence.PrePersist;
import javax.persistence.PreRemove;
import javax.persistence.PreUpdate;
import javax.persistence.Transient;
import javax.persistence.Version;
import org.apache.openjpa.persistence.callbacks.TestExceptionsFromCallbacks;

@Entity
public class ExceptionsFromCallbacksEntity {
    @Id
    @GeneratedValue
    private long id;
    @Version
    private int version;
    @Transient
    private boolean throwOnPrePersist;
    @Transient
    private boolean throwOnPostPersist;
    @Transient
    private boolean throwOnPreUpdate;
    @Transient
    private boolean throwOnPostUpdate;
    private boolean throwOnPostLoad;
    @Transient
    private boolean throwOnPreRemove;
    @Transient
    private boolean throwOnPostRemove;
    private String stringField;

    public void setThrowOnPrePersist(boolean b) {
        this.throwOnPrePersist = b;
    }

    public void setThrowOnPostPersist(boolean b) {
        this.throwOnPostPersist = b;
    }

    public void setThrowOnPreUpdate(boolean b) {
        this.throwOnPreUpdate = b;
    }

    public void setThrowOnPostUpdate(boolean b) {
        this.throwOnPostUpdate = b;
    }

    public void setThrowOnPostLoad(boolean b) {
        this.throwOnPostLoad = b;
    }

    public void setThrowOnPreRemove(boolean b) {
        this.throwOnPreRemove = b;
    }

    public void setThrowOnPostRemove(boolean b) {
        this.throwOnPostRemove = b;
    }

    public void setStringField(String s) {
        this.stringField = s;
    }

    @PrePersist
    public void prePersist() {
        if (this.throwOnPrePersist) {
            throw new CallbackTestException();
        }
    }

    @PostPersist
    public void postPersist() {
        if (this.throwOnPostPersist) {
            throw new CallbackTestException();
        }
    }

    @PostLoad
    public void postLoad() {
        if (this.throwOnPostLoad && this.isInvokedFromTestMethod()) {
            throw new CallbackTestException();
        }
    }

    private boolean isInvokedFromTestMethod() {
        return TestExceptionsFromCallbacks.testRunning;
    }

    @PreUpdate
    public void preUpdate() {
        if (this.throwOnPreUpdate) {
            throw new CallbackTestException();
        }
    }

    @PostUpdate
    public void postUpdate() {
        if (this.throwOnPostUpdate) {
            throw new CallbackTestException();
        }
    }

    @PreRemove
    public void preRemove() {
        if (this.throwOnPreRemove && this.isInvokedFromTestMethod()) {
            throw new CallbackTestException();
        }
    }

    @PostRemove
    public void postRemove() {
        if (this.throwOnPostRemove && this.isInvokedFromTestMethod()) {
            throw new CallbackTestException();
        }
    }

    public Object getId() {
        return this.id;
    }

    public class CallbackTestException
    extends RuntimeException {
    }
}

