/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.cache.jpa;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.persistence.Cache;
import org.apache.openjpa.lib.jdbc.JDBCListener;
import org.apache.openjpa.persistence.OpenJPAEntityManagerFactorySPI;
import org.apache.openjpa.persistence.cache.jpa.AbstractCacheModeTestCase;
import org.apache.openjpa.persistence.cache.jpa.model.CacheableEntity;
import org.apache.openjpa.persistence.cache.jpa.model.NegatedUncacheableEntity;
import org.apache.openjpa.persistence.cache.jpa.model.UncacheableEntity;
import org.apache.openjpa.persistence.cache.jpa.model.UnspecifiedEntity;
import org.apache.openjpa.persistence.cache.jpa.model.XmlCacheableEntity;
import org.apache.openjpa.persistence.cache.jpa.model.XmlUncacheableEntity;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestPropertyCacheModeEnableSelective
extends AbstractCacheModeTestCase {
    private static OpenJPAEntityManagerFactorySPI emf = null;
    private static Cache cache = null;
    private static List<String> sql = new ArrayList<String>();
    private static JDBCListener listener;
    private static Class<?>[] expectedInCache;
    private static Class<?>[] expectedNotInCache;

    @Override
    public OpenJPAEntityManagerFactorySPI getEntityManagerFactory() {
        if (emf == null) {
            HashMap<String, Object> propertyMap = new HashMap<String, Object>();
            propertyMap.put("javax.persistence.sharedCache.mode", "ENABLE_SELECTIVE");
            emf = this.createEntityManagerFactory("cache-mode-empty", propertyMap);
            TestPropertyCacheModeEnableSelective.assertNotNull((Object)emf);
            cache = emf.getCache();
            TestPropertyCacheModeEnableSelective.assertNotNull((Object)cache);
        }
        return emf;
    }

    @Override
    public JDBCListener getListener() {
        if (listener == null) {
            listener = new AbstractCacheModeTestCase.Listener();
        }
        return listener;
    }

    @Override
    public List<String> getSql() {
        return sql;
    }

    @Override
    protected Class<?>[] getExpectedInCache() {
        return expectedInCache;
    }

    @Override
    protected Class<?>[] getExpectedNotInCache() {
        return expectedNotInCache;
    }

    public void testCacheables() {
        this.assertCacheables(cache, true);
    }

    public void testUncacheables() {
        this.assertUncacheables(cache, false);
    }

    public void testUnspecified() {
        this.assertUnspecified(cache, false);
    }

    static {
        expectedInCache = new Class[]{CacheableEntity.class, XmlCacheableEntity.class, NegatedUncacheableEntity.class};
        expectedNotInCache = new Class[]{UncacheableEntity.class, XmlUncacheableEntity.class, UnspecifiedEntity.class};
    }
}

