/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.cache.jpa;

import java.lang.reflect.Modifier;
import java.util.Map;
import java.util.Set;
import org.apache.openjpa.lib.jdbc.JDBCListener;
import org.apache.openjpa.persistence.OpenJPAEntityManagerFactorySPI;
import org.apache.openjpa.persistence.OpenJPAEntityManagerSPI;
import org.apache.openjpa.persistence.OpenJPAPersistence;
import org.apache.openjpa.persistence.cache.jpa.model.CacheEntity;
import org.apache.openjpa.persistence.cache.jpa.model.CacheableEntity;
import org.apache.openjpa.persistence.cache.jpa.model.NegatedCachableEntity;
import org.apache.openjpa.persistence.cache.jpa.model.NegatedUncacheableEntity;
import org.apache.openjpa.persistence.cache.jpa.model.UncacheableEntity;
import org.apache.openjpa.persistence.cache.jpa.model.UnspecifiedEntity;
import org.apache.openjpa.persistence.cache.jpa.model.XmlCacheableEntity;
import org.apache.openjpa.persistence.cache.jpa.model.XmlUncacheableEntity;
import org.apache.openjpa.persistence.test.AbstractPersistenceTestCase;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractCacheTestCase
extends AbstractPersistenceTestCase {
    protected final String RETRIEVE_MODE_PROP = "javax.persistence.cache.retrieveMode";
    protected final String STORE_MODE_PROP = "javax.persistence.cache.storeMode";
    protected static Class<?>[] persistentTypes = new Class[]{CacheableEntity.class, UncacheableEntity.class, UnspecifiedEntity.class, NegatedCachableEntity.class, NegatedUncacheableEntity.class, XmlCacheableEntity.class, XmlUncacheableEntity.class};

    abstract OpenJPAEntityManagerFactorySPI getEntityManagerFactory();

    abstract JDBCListener getListener();

    public void populate() throws IllegalAccessException, InstantiationException {
        OpenJPAEntityManagerSPI em = this.getEntityManagerFactory().createEntityManager();
        em.getTransaction().begin();
        for (Class<?> clss : persistentTypes) {
            if (Modifier.isAbstract(clss.getModifiers())) continue;
            CacheEntity ce = (CacheEntity)clss.newInstance();
            ce.setId(1);
            em.persist((Object)ce);
        }
        em.getTransaction().commit();
        em.close();
    }

    public OpenJPAEntityManagerFactorySPI createEntityManagerFactory(String puName, Map<String, Object> additionalProperties) {
        Map<String, Object> propertiesMap = this.getPropertiesMap("openjpa.DataCache", "true", "openjpa.QueryCache", "true", "openjpa.RemoteCommitProvider", "sjvm", persistentTypes, "openjpa.jdbc.JDBCListeners", new JDBCListener[]{this.getListener()});
        if (additionalProperties != null) {
            Set<String> keys = additionalProperties.keySet();
            for (String key : keys) {
                propertiesMap.put(key, additionalProperties.get(key));
            }
        }
        OpenJPAEntityManagerFactorySPI emf = (OpenJPAEntityManagerFactorySPI)OpenJPAPersistence.createEntityManagerFactory((String)puName, (String)"META-INF/caching-persistence.xml", propertiesMap);
        return emf;
    }

    public void setUp() throws Exception {
        super.setUp();
        this.cleanDatabase();
        this.populate();
    }

    public void cleanDatabase() throws Exception {
        OpenJPAEntityManagerSPI em = this.getEntityManagerFactory().createEntityManager();
        em.getTransaction().begin();
        for (Class<?> clss : persistentTypes) {
            if (Modifier.isAbstract(clss.getModifiers())) continue;
            em.createQuery("Delete from " + clss.getSimpleName()).executeUpdate();
        }
        em.getTransaction().commit();
        em.close();
    }
}

