/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.annotations.common.apps.annotApp.ddtype;

import javax.persistence.Basic;
import javax.persistence.Entity;
import javax.persistence.EntityListeners;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.PostLoad;
import javax.persistence.PostPersist;
import javax.persistence.PostUpdate;
import javax.persistence.Transient;
import org.apache.openjpa.persistence.annotations.common.apps.annotApp.ddtype.CallbackStorage;
import org.apache.openjpa.persistence.annotations.common.apps.annotApp.ddtype.LongNameValidator;
import org.apache.openjpa.persistence.annotations.common.apps.annotApp.ddtype.NameValidator;
import org.apache.openjpa.persistence.annotations.common.apps.annotApp.ddtype.NamedEntity;

@Entity
@Inheritance(strategy=InheritanceType.JOINED)
@EntityListeners(value={NameValidator.class, LongNameValidator.class})
public class Employee
implements NamedEntity {
    @Id
    private int id;
    @Basic
    protected String name;
    @GeneratedValue(strategy=GenerationType.AUTO)
    protected int lifecheck;
    @Transient
    protected long syncTime;

    public Employee() {
    }

    public Employee(int id, String name) {
        this.id = id;
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setId(int id) {
        this.id = id;
    }

    public int getId() {
        return this.id;
    }

    @PostPersist
    private void resetSyncTime() {
        System.out.println("resetSyncTime is running on " + this + "GEN #: " + this.lifecheck);
        this.syncTime = System.currentTimeMillis();
        CallbackStorage store = CallbackStorage.getInstance();
        store.getClist().add("employeepop");
        store.getClist().add("gen#" + this.lifecheck);
    }

    @PostLoad
    public void pload() {
        CallbackStorage store = CallbackStorage.getInstance();
        store.getClist().add("employeepol");
    }

    @PostUpdate
    public void pupdate() {
        CallbackStorage store = CallbackStorage.getInstance();
        store.getClist().add("employeepou");
    }

    public String toString() {
        return "Name: " + this.name + " of " + this.getClass().getName() + " Id: " + this.id + " Synctime: " + this.syncTime;
    }

    public int getCheck() {
        return this.lifecheck;
    }

    public void setCheck(int check) {
        this.lifecheck = check;
    }
}

