/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.annotations;

import java.util.List;
import java.util.Set;
import javax.persistence.Query;
import org.apache.openjpa.persistence.OpenJPAEntityManagerSPI;
import org.apache.openjpa.persistence.annotations.PColl_EmbedB;
import org.apache.openjpa.persistence.annotations.PColl_EntityA;
import org.apache.openjpa.persistence.annotations.PColl_EntityA1;
import org.apache.openjpa.persistence.annotations.PColl_EntityB;
import org.apache.openjpa.persistence.annotations.PColl_EntityC;
import org.apache.openjpa.persistence.annotations.PColl_EntityStringEager;
import org.apache.openjpa.persistence.annotations.PColl_EntityStringLazy;
import org.apache.openjpa.persistence.test.SingleEMFTestCase;

public class TestPersistentCollection
extends SingleEMFTestCase {
    public void setUp() {
        this.setUp(PColl_EntityA.class, PColl_EmbedB.class, PColl_EntityC.class, PColl_EntityA1.class, PColl_EntityB.class, PColl_EntityStringEager.class, PColl_EntityStringLazy.class, CLEAR_TABLES);
    }

    public void testPersistentCollectionOfEmbeddables() {
        try {
            OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
            em.getTransaction().begin();
            PColl_EntityC c = new PColl_EntityC();
            c.setId(101);
            PColl_EmbedB b01 = new PColl_EmbedB();
            b01.setName("b01");
            b01.setM2oC(c);
            PColl_EntityA a = new PColl_EntityA();
            a.setId(1);
            a.getEmbedCollection().add(b01);
            em.persist((Object)a);
            em.getTransaction().commit();
            em.close();
            em = this.emf.createEntityManager();
            Query q = em.createQuery("SELECT o FROM PColl_EntityA o");
            List oList = q.getResultList();
            PColl_EntityA d1 = (PColl_EntityA)oList.get(0);
            Set<PColl_EmbedB> b1s = d1.getEmbedCollection();
            PColl_EmbedB b1 = b1s.iterator().next();
            PColl_EntityC c1 = b1.getM2oC();
            TestPersistentCollection.assertEquals((String)"b01", (String)b1.getName());
            TestPersistentCollection.assertEquals((int)101, (int)c1.getId());
            TestPersistentCollection.assertEquals((int)1, (int)d1.getId());
            em.close();
        }
        catch (Throwable t) {
            TestPersistentCollection.fail((String)t.getMessage());
        }
    }

    public void testPersistentCollectionOfEntities() {
        try {
            OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
            em.getTransaction().begin();
            PColl_EntityC c = new PColl_EntityC();
            c.setId(101);
            PColl_EntityB b01 = new PColl_EntityB();
            b01.setName("b01");
            b01.setM2oC(c);
            PColl_EntityA1 a = new PColl_EntityA1();
            a.setId(1);
            a.getEmbedCollection().add(b01);
            em.persist((Object)a);
            em.getTransaction().commit();
            em.close();
            em = this.emf.createEntityManager();
            Query q = em.createQuery("SELECT o FROM PColl_EntityA1 o");
            List oList = q.getResultList();
            PColl_EntityA1 a1 = (PColl_EntityA1)oList.get(0);
            Set<PColl_EntityB> b1s = a1.getEmbedCollection();
            PColl_EntityB b1 = b1s.iterator().next();
            PColl_EntityC c1 = b1.getM2oC();
            TestPersistentCollection.assertEquals((String)"b01", (String)b1.getName());
            TestPersistentCollection.assertEquals((int)101, (int)c1.getId());
            TestPersistentCollection.assertEquals((int)1, (int)a1.getId());
            em.close();
        }
        catch (Throwable t) {
            TestPersistentCollection.fail((String)t.getMessage());
        }
    }

    public void testPersistentCollectionStringsLazy() {
        try {
            OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
            em.getTransaction().begin();
            PColl_EntityStringLazy a = new PColl_EntityStringLazy();
            a.setId(1);
            a.getCollectionOfStrings().add("one");
            em.persist((Object)a);
            em.getTransaction().commit();
            em.close();
            em = this.emf.createEntityManager();
            Query q = em.createQuery("SELECT o FROM PColl_EntityStringLazy o");
            PColl_EntityStringLazy a1 = (PColl_EntityStringLazy)q.getSingleResult();
            TestPersistentCollection.assertEquals((int)1, (int)a1.getCollectionOfStrings().size());
            TestPersistentCollection.assertEquals((Object)"one", (Object)a1.getCollectionOfStrings().toArray()[0]);
            TestPersistentCollection.assertEquals((int)1, (int)a1.getId());
            em.close();
        }
        catch (Throwable t) {
            TestPersistentCollection.fail((String)t.getMessage());
        }
    }

    public void testPersistentCollectionStringsEager() {
        try {
            OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
            em.getTransaction().begin();
            PColl_EntityStringEager a = new PColl_EntityStringEager();
            a.setId(1);
            a.getCollectionOfStrings().add("one");
            em.persist((Object)a);
            em.getTransaction().commit();
            em.close();
            em = this.emf.createEntityManager();
            Query q = em.createQuery("SELECT o FROM PColl_EntityStringEager o");
            PColl_EntityStringEager a1 = (PColl_EntityStringEager)q.getSingleResult();
            TestPersistentCollection.assertEquals((int)1, (int)a1.getCollectionOfStrings().size());
            TestPersistentCollection.assertEquals((Object)"one", (Object)a1.getCollectionOfStrings().toArray()[0]);
            TestPersistentCollection.assertEquals((int)1, (int)a1.getId());
            em.close();
        }
        catch (Throwable t) {
            TestPersistentCollection.fail((String)t.getMessage());
        }
    }
}

