/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.annotations;

import javax.persistence.EntityManager;
import org.apache.openjpa.enhance.PersistenceCapable;
import org.apache.openjpa.persistence.OpenJPAEntityManager;
import org.apache.openjpa.persistence.OpenJPAQuery;
import org.apache.openjpa.persistence.annotations.AnnotationTestCase;
import org.apache.openjpa.persistence.annotations.common.apps.annotApp.annotype.EmbeddedIdClass;
import org.apache.openjpa.persistence.annotations.common.apps.annotApp.annotype.EmbeddedIdEntity;

public class TestEmbeddedId
extends AnnotationTestCase {
    EmbeddedIdClass _oid;
    EmbeddedIdClass _roid;

    public TestEmbeddedId(String name) {
        super(name, "annotationcactusapp");
    }

    public void setUp() {
        this.deleteAll(EmbeddedIdEntity.class);
        this._oid = new EmbeddedIdClass();
        this._oid.setPk1(1L);
        this._oid.setPk2(2L);
        EmbeddedIdEntity e = new EmbeddedIdEntity();
        e.setId(this._oid);
        e.setValue("e");
        this._roid = new EmbeddedIdClass();
        this._roid.setPk1(2L);
        this._roid.setPk2(3L);
        EmbeddedIdEntity rel = new EmbeddedIdEntity();
        rel.setId(this._roid);
        rel.setValue("r");
        e.setRelation(rel);
        OpenJPAEntityManager em = this.currentEntityManager();
        this.startTx((EntityManager)em);
        em.persistAll(new Object[]{e, rel});
        this.endTx((EntityManager)em);
        this.endEm((EntityManager)em);
    }

    public void testGetObjectId() {
        OpenJPAEntityManager em = this.currentEntityManager();
        EmbeddedIdEntity e = (EmbeddedIdEntity)em.find(EmbeddedIdEntity.class, (Object)this._oid);
        TestEmbeddedId.assertNotNull((Object)e);
        TestEmbeddedId.assertEquals((String)"e", (String)e.getValue());
        TestEmbeddedId.assertNull((Object)e.getMappingOverrideRelation());
        TestEmbeddedId.assertNotNull((Object)e.getRelation());
        TestEmbeddedId.assertEquals((String)"r", (String)e.getRelation().getValue());
        TestEmbeddedId.assertEquals((Object)this._oid, (Object)em.getObjectId((Object)e));
        TestEmbeddedId.assertEquals((Object)this._roid, (Object)em.getObjectId((Object)e.getRelation()));
        TestEmbeddedId.assertEquals((Object)this._oid, (Object)e.getId());
        TestEmbeddedId.assertEquals((Object)this._roid, (Object)e.getRelation().getId());
        TestEmbeddedId.assertNull((Object)((PersistenceCapable)e.getId()).pcGetGenericContext());
        this.endEm((EntityManager)em);
    }

    public void testMutateEmbeddedIdFieldValueOfNew() {
        EmbeddedIdEntity e1 = new EmbeddedIdEntity();
        e1.setValue("e1");
        EmbeddedIdEntity e2 = new EmbeddedIdEntity();
        e2.setValue("e2");
        e2.setId(new EmbeddedIdClass());
        OpenJPAEntityManager em = this.currentEntityManager();
        this.startTx((EntityManager)em);
        EmbeddedIdClass oid = new EmbeddedIdClass();
        oid.setPk1(4L);
        oid.setPk2(5L);
        e1.setId(oid);
        e2.getId().setPk1(6L);
        e2.getId().setPk2(7L);
        em.persistAll(new Object[]{e1, e2});
        this.endTx((EntityManager)em);
        EmbeddedIdClass oid1 = e1.getId();
        EmbeddedIdClass oid2 = e2.getId();
        TestEmbeddedId.assertEquals((Object)oid1, (Object)em.getObjectId((Object)e1));
        TestEmbeddedId.assertEquals((Object)oid2, (Object)em.getObjectId((Object)e2));
        TestEmbeddedId.assertEquals((long)4L, (long)oid1.getPk1());
        TestEmbeddedId.assertEquals((long)5L, (long)oid1.getPk2());
        TestEmbeddedId.assertEquals((long)6L, (long)oid2.getPk1());
        TestEmbeddedId.assertEquals((long)7L, (long)oid2.getPk2());
        this.endEm((EntityManager)em);
        em = this.currentEntityManager();
        e1 = (EmbeddedIdEntity)em.find(EmbeddedIdEntity.class, (Object)oid1);
        e2 = (EmbeddedIdEntity)em.find(EmbeddedIdEntity.class, (Object)oid2);
        TestEmbeddedId.assertEquals((Object)oid1, (Object)em.getObjectId((Object)e1));
        TestEmbeddedId.assertEquals((Object)oid2, (Object)em.getObjectId((Object)e2));
        TestEmbeddedId.assertEquals((Object)oid1, (Object)e1.getId());
        TestEmbeddedId.assertEquals((Object)oid2, (Object)e2.getId());
        this.endEm((EntityManager)em);
    }

    public void testMutateEmbeddedIdFieldValueOfExisting() {
        OpenJPAEntityManager em;
        block4: {
            em = this.currentEntityManager();
            this.startTx((EntityManager)em);
            EmbeddedIdEntity e = (EmbeddedIdEntity)em.find(EmbeddedIdEntity.class, (Object)this._oid);
            e.setValue("changed");
            try {
                e.getId().setPk1(9L);
                this.endTx((EntityManager)em);
                TestEmbeddedId.fail((String)"Committed with changed oid field.");
            }
            catch (RuntimeException re) {
                if (this.isActiveTx((EntityManager)em)) {
                    this.rollbackTx((EntityManager)em);
                }
            }
            catch (Exception exc) {
                if (!this.isActiveTx((EntityManager)em)) break block4;
                this.rollbackTx((EntityManager)em);
            }
        }
        this.endEm((EntityManager)em);
    }

    public void testDetachAttach() {
        OpenJPAEntityManager em = this.currentEntityManager();
        EmbeddedIdEntity e = (EmbeddedIdEntity)em.find(EmbeddedIdEntity.class, (Object)this._oid);
        e.getRelation();
        this.endEm((EntityManager)em);
        e.setValue("echanged");
        e.getRelation().setValue("rchanged");
        em = this.currentEntityManager();
        this.startTx((EntityManager)em);
        EmbeddedIdEntity me = (EmbeddedIdEntity)em.mergeAll(new Object[]{e, e.getRelation()})[0];
        TestEmbeddedId.assertTrue((me != e ? 1 : 0) != 0);
        TestEmbeddedId.assertNotNull((Object)me.getRelation());
        TestEmbeddedId.assertTrue((me.getRelation() != e.getRelation() ? 1 : 0) != 0);
        TestEmbeddedId.assertEquals((String)"echanged", (String)me.getValue());
        TestEmbeddedId.assertEquals((String)"rchanged", (String)me.getRelation().getValue());
        TestEmbeddedId.assertEquals((Object)this._oid, (Object)me.getId());
        TestEmbeddedId.assertEquals((Object)this._oid, (Object)em.getObjectId((Object)me));
        TestEmbeddedId.assertEquals((Object)this._roid, (Object)me.getRelation().getId());
        TestEmbeddedId.assertEquals((Object)this._roid, (Object)em.getObjectId((Object)me.getRelation()));
        this.endTx((EntityManager)em);
        this.endEm((EntityManager)em);
    }

    public void testQuery() {
        OpenJPAEntityManager em = this.currentEntityManager();
        OpenJPAQuery q = em.createQuery("select e from EmbeddedIdEntity e where e.id.pk1 = 1");
        EmbeddedIdEntity e = (EmbeddedIdEntity)q.getSingleResult();
        TestEmbeddedId.assertEquals((Object)this._oid, (Object)e.getId());
        TestEmbeddedId.assertEquals((String)"e", (String)e.getValue());
        q = em.createQuery("select e.id.pk2 from EmbeddedIdEntity e where e.id.pk1 = 1");
        TestEmbeddedId.assertEquals((Object)new Long(this._oid.getPk2()), (Object)q.getSingleResult());
        q = em.createQuery("select e.id from EmbeddedIdEntity e where e.id.pk1 = 1");
        TestEmbeddedId.assertEquals((Object)this._oid, (Object)q.getSingleResult());
        this.endEm((EntityManager)em);
    }

    public void testAutoAssigned() {
        OpenJPAEntityManager em = this.currentEntityManager();
        this.startTx((EntityManager)em);
        EmbeddedIdEntity e = new EmbeddedIdEntity();
        em.persist((Object)e);
        EmbeddedIdClass oid = e.getId();
        TestEmbeddedId.assertNotNull((Object)oid);
        TestEmbeddedId.assertTrue((oid.getPk3() != 0L ? 1 : 0) != 0);
        TestEmbeddedId.assertEquals((Object)oid, (Object)em.getObjectId((Object)e));
        this.endTx((EntityManager)em);
        TestEmbeddedId.assertEquals((Object)oid, (Object)em.getObjectId((Object)e));
        this.endEm((EntityManager)em);
        em = this.currentEntityManager();
        e = (EmbeddedIdEntity)em.find(EmbeddedIdEntity.class, (Object)oid);
        TestEmbeddedId.assertEquals((Object)oid, (Object)em.getObjectId((Object)e));
        this.endEm((EntityManager)em);
        em = this.currentEntityManager();
        this.startTx((EntityManager)em);
        e = new EmbeddedIdEntity();
        oid = new EmbeddedIdClass();
        oid.setPk1(4L);
        oid.setPk2(5L);
        e.setId(oid);
        em.persist((Object)e);
        oid = e.getId();
        TestEmbeddedId.assertEquals((long)4L, (long)oid.getPk1());
        TestEmbeddedId.assertEquals((long)5L, (long)oid.getPk2());
        TestEmbeddedId.assertTrue((oid.getPk3() != 0L ? 1 : 0) != 0);
        TestEmbeddedId.assertEquals((Object)oid, (Object)em.getObjectId((Object)e));
        this.endTx((EntityManager)em);
        TestEmbeddedId.assertEquals((Object)oid, (Object)em.getObjectId((Object)e));
        this.endEm((EntityManager)em);
        em = this.currentEntityManager();
        e = (EmbeddedIdEntity)em.find(EmbeddedIdEntity.class, (Object)oid);
        TestEmbeddedId.assertEquals((Object)oid, (Object)em.getObjectId((Object)e));
        this.endEm((EntityManager)em);
        em = this.currentEntityManager();
        this.startTx((EntityManager)em);
        e = new EmbeddedIdEntity();
        em.persist((Object)e);
        this.endTx((EntityManager)em);
        oid = e.getId();
        TestEmbeddedId.assertTrue((oid.getPk3() != 0L ? 1 : 0) != 0);
        TestEmbeddedId.assertEquals((Object)oid, (Object)em.getObjectId((Object)e));
        this.endEm((EntityManager)em);
        em = this.currentEntityManager();
        e = (EmbeddedIdEntity)em.find(EmbeddedIdEntity.class, (Object)oid);
        TestEmbeddedId.assertEquals((Object)oid, (Object)em.getObjectId((Object)e));
        this.endEm((EntityManager)em);
    }
}

