/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.annotations;

import java.util.List;
import javax.persistence.EntityManager;
import org.apache.openjpa.persistence.OpenJPAEntityManager;
import org.apache.openjpa.persistence.annotations.AnnotationTestCase;
import org.apache.openjpa.persistence.annotations.common.apps.annotApp.ddtype.CallbackStorage;
import org.apache.openjpa.persistence.annotations.common.apps.annotApp.ddtype.LifeCycleDDEntity;
import org.apache.openjpa.persistence.annotations.common.apps.annotApp.ddtype.LifeCycleDDEntity2;

public class TestDDCallbackMethods
extends AnnotationTestCase {
    public TestDDCallbackMethods(String name) {
        super(name, "ddcactusapp");
    }

    public void setUp() {
        this.deleteAll(LifeCycleDDEntity.class);
        this.deleteAll(LifeCycleDDEntity2.class);
        CallbackStorage.clearStore();
    }

    public void testDDPrpPop() {
        OpenJPAEntityManager em = this.currentEntityManager();
        this.startTx((EntityManager)em);
        LifeCycleDDEntity lcd = new LifeCycleDDEntity("afam", "okeke");
        em.persist((Object)lcd);
        CallbackStorage store = CallbackStorage.getInstance();
        TestDDCallbackMethods.assertNotNull(store.getClist());
        TestDDCallbackMethods.assertEquals((int)2, (int)store.getClist().size());
        TestDDCallbackMethods.assertEquals((String)"def-prepersist", (String)store.getClist().get(0));
        TestDDCallbackMethods.assertEquals((String)"def-postpersist", (String)store.getClist().get(1));
        this.endTx((EntityManager)em);
        this.endEm((EntityManager)em);
    }

    public void testDDPrrPor() {
        OpenJPAEntityManager em = this.currentEntityManager();
        this.startTx((EntityManager)em);
        LifeCycleDDEntity lcd = new LifeCycleDDEntity("john", "rash");
        em.persist((Object)lcd);
        int id = lcd.getId();
        lcd = (LifeCycleDDEntity)em.find(LifeCycleDDEntity.class, (Object)id);
        TestDDCallbackMethods.assertNotNull((Object)lcd);
        CallbackStorage store = CallbackStorage.getInstance();
        store.clearStore();
        em.remove((Object)lcd);
        TestDDCallbackMethods.assertNotNull(store.getClist());
        TestDDCallbackMethods.assertEquals((int)2, (int)store.getClist().size());
        TestDDCallbackMethods.assertEquals((String)"def-preremove", (String)store.getClist().get(0));
        TestDDCallbackMethods.assertEquals((String)"def-postremove", (String)store.getClist().get(1));
        this.endTx((EntityManager)em);
        this.endEm((EntityManager)em);
    }

    public void testDDPouPru() {
        OpenJPAEntityManager em = this.currentEntityManager();
        this.startTx((EntityManager)em);
        LifeCycleDDEntity lcd = new LifeCycleDDEntity("Don", "Shiddle");
        em.persist((Object)lcd);
        int id = lcd.getId();
        CallbackStorage.clearStore();
        String query = "Update LifeCycleDDEntity e SET e.name = 'Joseph' WHERE e.id = :id";
        int result = em.createQuery(query).setParameter("id", (Object)id).executeUpdate();
        List<String> store = CallbackStorage.getInstance().getClist();
        TestDDCallbackMethods.assertNotNull((Object)result);
        TestDDCallbackMethods.assertEquals((int)1, (int)result);
        TestDDCallbackMethods.assertNotNull(store);
        TestDDCallbackMethods.assertEquals((int)2, (int)store.size());
        TestDDCallbackMethods.assertEquals((Object)"def-preupdate", (Object)store.get(0));
        TestDDCallbackMethods.assertEquals((Object)"def-postupdate", (Object)store.get(1));
        this.endTx((EntityManager)em);
        this.endEm((EntityManager)em);
    }

    public void testDDPol() {
        OpenJPAEntityManager em = this.currentEntityManager();
        this.startTx((EntityManager)em);
        LifeCycleDDEntity lcd = new LifeCycleDDEntity("Julie", "Jolie");
        em.persist((Object)lcd);
        int id = lcd.getId();
        CallbackStorage.clearStore();
        this.endTx((EntityManager)em);
        this.startTx((EntityManager)em);
        CallbackStorage.clearStore();
        TestDDCallbackMethods.assertTrue((boolean)CallbackStorage.getInstance().getClist().isEmpty());
        lcd = (LifeCycleDDEntity)em.find(LifeCycleDDEntity.class, (Object)id);
        em.refresh((Object)lcd);
        TestDDCallbackMethods.assertNotNull((Object)lcd);
        TestDDCallbackMethods.assertNotNull(CallbackStorage.getInstance().getClist());
        TestDDCallbackMethods.assertEquals((int)2, (int)CallbackStorage.getInstance().getClist().size());
        TestDDCallbackMethods.assertEquals((String)"def-postload", (String)CallbackStorage.getInstance().getClist().get(0));
        TestDDCallbackMethods.assertEquals((String)"def-postload", (String)CallbackStorage.getInstance().getClist().get(1));
        this.endTx((EntityManager)em);
        this.endEm((EntityManager)em);
    }

    public void testDefaultPrePostPersistListener() {
        OpenJPAEntityManager em = this.currentEntityManager();
        this.startTx((EntityManager)em);
        LifeCycleDDEntity2 lc = new LifeCycleDDEntity2("Bill", "Clinton");
        CallbackStorage store = CallbackStorage.getInstance();
        store.clearStore();
        em.persist((Object)lc);
        TestDDCallbackMethods.assertEquals((int)4, (int)store.getClist().size());
        TestDDCallbackMethods.assertEquals((String)"def-prepersist", (String)store.getClist().get(0));
        TestDDCallbackMethods.assertEquals((String)"verifyprp", (String)store.getClist().get(1));
        TestDDCallbackMethods.assertEquals((String)"def-postpersist", (String)store.getClist().get(2));
        TestDDCallbackMethods.assertEquals((String)"verifypop", (String)store.getClist().get(3));
        this.endTx((EntityManager)em);
        this.endEm((EntityManager)em);
    }

    public void testDefaultPrePostUpdateListener() {
        OpenJPAEntityManager em = this.currentEntityManager();
        this.startTx((EntityManager)em);
        LifeCycleDDEntity2 emp = new LifeCycleDDEntity2("lincoln", "Abraham");
        em.persist((Object)emp);
        int id = emp.getId();
        CallbackStorage.clearStore();
        String query = "Update LifeCycleDDEntity2 e SET e.name = 'Joseph' WHERE e.id = :id";
        int result = em.createQuery(query).setParameter("id", (Object)id).executeUpdate();
        List<String> store = CallbackStorage.getInstance().getClist();
        TestDDCallbackMethods.assertNotNull((Object)result);
        TestDDCallbackMethods.assertEquals((int)1, (int)result);
        TestDDCallbackMethods.assertNotNull(store);
        TestDDCallbackMethods.assertEquals((int)2, (int)store.size());
        TestDDCallbackMethods.assertEquals((Object)"def-preupdate", (Object)store.get(0));
        TestDDCallbackMethods.assertEquals((Object)"def-postupdate", (Object)store.get(1));
        this.endTx((EntityManager)em);
        this.endEm((EntityManager)em);
    }

    public void testDefaultPostLoadListener() {
        OpenJPAEntityManager em = this.currentEntityManager();
        this.startTx((EntityManager)em);
        LifeCycleDDEntity2 emp = new LifeCycleDDEntity2("Thomas", "Jefferson");
        em.persist((Object)emp);
        int id = emp.getId();
        CallbackStorage.clearStore();
        this.endTx((EntityManager)em);
        this.startTx((EntityManager)em);
        CallbackStorage.clearStore();
        TestDDCallbackMethods.assertTrue((String)"not empty...", (boolean)CallbackStorage.isEmpty());
        emp = (LifeCycleDDEntity2)em.find(LifeCycleDDEntity2.class, (Object)id);
        em.refresh((Object)emp);
        TestDDCallbackMethods.assertNotNull((Object)emp);
        TestDDCallbackMethods.assertNotNull(CallbackStorage.getInstance().getClist());
        TestDDCallbackMethods.assertEquals((int)2, (int)CallbackStorage.getInstance().getClist().size());
        TestDDCallbackMethods.assertEquals((String)"def-postload", (String)CallbackStorage.getInstance().getClist().get(0));
        TestDDCallbackMethods.assertEquals((String)"def-postload", (String)CallbackStorage.getInstance().getClist().get(1));
        this.endTx((EntityManager)em);
        this.endEm((EntityManager)em);
    }

    public void testSubClassOverrideSuperCallbacksInh() {
        OpenJPAEntityManager em = this.currentEntityManager();
        this.startTx((EntityManager)em);
        LifeCycleDDEntity2 emp = new LifeCycleDDEntity2("Thomas", "Jefferson");
        em.persist((Object)emp);
        TestDDCallbackMethods.assertNotNull((Object)emp);
        TestDDCallbackMethods.assertNotNull(CallbackStorage.getInstance().getClist());
        TestDDCallbackMethods.assertEquals((int)4, (int)CallbackStorage.getInstance().getClist().size());
        TestDDCallbackMethods.assertEquals((String)"def-prepersist", (String)CallbackStorage.getInstance().getClist().get(0));
        TestDDCallbackMethods.assertEquals((String)"verifyprp", (String)CallbackStorage.getInstance().getClist().get(1));
        TestDDCallbackMethods.assertEquals((String)"def-postpersist", (String)CallbackStorage.getInstance().getClist().get(2));
        TestDDCallbackMethods.assertEquals((String)"verifypop", (String)CallbackStorage.getInstance().getClist().get(3));
        this.endTx((EntityManager)em);
        this.endEm((EntityManager)em);
    }
}

