/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.access.xml;

import java.util.Date;
import org.apache.openjpa.persistence.ArgumentException;
import org.apache.openjpa.persistence.OpenJPAEntityManagerFactorySPI;
import org.apache.openjpa.persistence.OpenJPAEntityManagerSPI;
import org.apache.openjpa.persistence.OpenJPAPersistence;
import org.apache.openjpa.persistence.OpenJPAQuery;
import org.apache.openjpa.persistence.access.xml.XMLDefFieldMixedPropAccess;
import org.apache.openjpa.persistence.access.xml.XMLDefPropMixedFieldAccess;
import org.apache.openjpa.persistence.access.xml.XMLEmbedFieldAccess;
import org.apache.openjpa.persistence.access.xml.XMLEmbedMixedAccess;
import org.apache.openjpa.persistence.access.xml.XMLEmbedPropAccess;
import org.apache.openjpa.persistence.access.xml.XMLFieldAccess;
import org.apache.openjpa.persistence.access.xml.XMLFieldEmbedEntity;
import org.apache.openjpa.persistence.access.xml.XMLFieldSub;
import org.apache.openjpa.persistence.access.xml.XMLFieldSub2;
import org.apache.openjpa.persistence.access.xml.XMLFieldSub3;
import org.apache.openjpa.persistence.access.xml.XMLMixedFieldSub;
import org.apache.openjpa.persistence.access.xml.XMLPropAccess;
import org.apache.openjpa.persistence.access.xml.XMLPropEmbedEntity;
import org.apache.openjpa.persistence.access.xml.XMLPropMixedEntity;
import org.apache.openjpa.persistence.access.xml.XMLPropertySub;
import org.apache.openjpa.persistence.access.xml.XMLPropertySub2;
import org.apache.openjpa.persistence.access.xml.XMLPropertySub3;
import org.apache.openjpa.persistence.access.xml.XMLSuperFieldEntity;
import org.apache.openjpa.persistence.access.xml.XMLSuperPropertyEntity;
import org.apache.openjpa.persistence.test.AllowFailure;
import org.apache.openjpa.persistence.test.SingleEMFTestCase;

public class TestXMLExplicitAccess
extends SingleEMFTestCase {
    public void setUp() throws Exception {
        super.setUp();
    }

    public void tearDown() throws Exception {
        super.tearDown();
    }

    protected String getPersistenceUnitName() {
        return "Access-1";
    }

    public void testClassSpecifiedFieldAccess() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        XMLFieldAccess fa = new XMLFieldAccess();
        fa.setStringField("XMLFieldAccess");
        em.getTransaction().begin();
        em.persist((Object)fa);
        em.getTransaction().commit();
        em.clear();
        OpenJPAQuery qry = em.createNamedQuery("XMLFieldAccess.query");
        qry.setParameter("id", (Object)fa.getId());
        qry.setParameter("strVal", (Object)"XMLFieldAccess");
        XMLFieldAccess fa2 = (XMLFieldAccess)qry.getSingleResult();
        TestXMLExplicitAccess.assertEquals((int)fa.getId(), (int)fa2.getId());
        em.close();
    }

    public void testClassSpecifiedPropertyAccess() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        XMLPropAccess pa = new XMLPropAccess();
        pa.setStrProp("PropertyAccess");
        em.getTransaction().begin();
        em.persist((Object)pa);
        em.getTransaction().commit();
        em.clear();
        OpenJPAQuery qry = em.createNamedQuery("XMLPropAccess.query");
        qry.setParameter("id", (Object)pa.getId());
        qry.setParameter("strVal", (Object)"PropertyAccess");
        XMLPropAccess pa2 = (XMLPropAccess)qry.getSingleResult();
        TestXMLExplicitAccess.assertEquals((Object)pa, (Object)pa2);
        em.close();
    }

    public void testClassSpecifiedMixedSinglePCFieldAccess() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        XMLDefFieldMixedPropAccess dfmpa = new XMLDefFieldMixedPropAccess();
        dfmpa.setStrField("NonPCSetter");
        dfmpa.setStringField("XMLDFMPA");
        em.getTransaction().begin();
        em.persist((Object)dfmpa);
        em.getTransaction().commit();
        em.clear();
        OpenJPAQuery qry = em.createNamedQuery("XMLDFMPA.query");
        qry.setParameter("id", (Object)dfmpa.getId());
        qry.setParameter("strVal", (Object)"XMLDFMPA");
        XMLDefFieldMixedPropAccess dfmpa2 = (XMLDefFieldMixedPropAccess)qry.getSingleResult();
        TestXMLExplicitAccess.assertEquals((Object)dfmpa, (Object)dfmpa2);
        TestXMLExplicitAccess.assertEquals((String)dfmpa2.getStringField(), (String)"XMLDFMPA");
        try {
            qry = em.createNamedQuery("XMLDFMPA.badQuery");
            qry.setParameter("id", (Object)dfmpa.getId());
            qry.setParameter("strVal", (Object)"XMLDFMPA");
            qry.getSingleResult();
            TestXMLExplicitAccess.fail((String)"Execution of this query should have thrown an exception");
        }
        catch (Exception e) {
            this.assertExceptionMessage(e, ArgumentException.class, "No field named \"strField\" in \"XMLDefFieldMixedPropAccess\"", "[id, stringField, version]");
        }
        em.close();
    }

    public void testClassSpecifiedMixedSinglePCPropertyAccess() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        XMLDefPropMixedFieldAccess dpmfa = new XMLDefPropMixedFieldAccess();
        dpmfa.setStrProp("XMLDPMFA");
        em.getTransaction().begin();
        em.persist((Object)dpmfa);
        em.getTransaction().commit();
        em.clear();
        OpenJPAQuery qry = em.createNamedQuery("XMLDPMFA.query");
        qry.setParameter("id", (Object)dpmfa.getId());
        qry.setParameter("strVal", (Object)"XMLDPMFA");
        XMLDefPropMixedFieldAccess dpmfa2 = (XMLDefPropMixedFieldAccess)qry.getSingleResult();
        TestXMLExplicitAccess.assertEquals((Object)dpmfa, (Object)dpmfa2);
        TestXMLExplicitAccess.assertEquals((String)dpmfa2.getStrProp(), (String)"XMLDPMFA");
        try {
            qry = em.createNamedQuery("XMLDPMFA.badQuery");
            qry.setParameter("id", (Object)dpmfa.getId());
            qry.setParameter("strVal", (Object)"XMLDPMFA");
            qry.getSingleResult();
            TestXMLExplicitAccess.fail((String)"Usage of this query should have thrown an exception");
        }
        catch (Exception e) {
            this.assertExceptionMessage(e, ArgumentException.class, "No field named \"strProp\" in \"XMLDefPropMixedFieldAccess\"", "[id, strField, version]");
        }
        em.close();
    }

    public void testAbstractMappedSuperField() {
        OpenJPAEntityManagerFactorySPI emf = (OpenJPAEntityManagerFactorySPI)OpenJPAPersistence.createEntityManagerFactory((String)"Access-XML", (String)"org/apache/openjpa/persistence/access/access-persistence.xml");
        OpenJPAEntityManagerSPI em = emf.createEntityManager();
        XMLPropertySub ps = new XMLPropertySub();
        ps.setName("AbsMappedSuperName");
        Date now = new Date();
        ps.setCreateDate(now);
        em.getTransaction().begin();
        em.persist((Object)ps);
        em.getTransaction().commit();
        em.clear();
        OpenJPAQuery qry = em.createNamedQuery("XMLPropertySub.query");
        qry.setParameter("id", (Object)ps.getId());
        qry.setParameter("name", (Object)"AbsMappedSuperName");
        qry.setParameter("crtDate", (Object)now);
        XMLPropertySub ps2 = (XMLPropertySub)qry.getSingleResult();
        TestXMLExplicitAccess.assertEquals((Object)ps, (Object)ps2);
        TestXMLExplicitAccess.assertEquals((String)ps2.getName(), (String)"AbsMappedSuperName");
        TestXMLExplicitAccess.assertEquals((String)ps2.getCreateDate().toString(), (String)now.toString());
        try {
            qry = em.createNamedQuery("XMLPropertySub.badQuery");
            qry.setParameter("id", (Object)ps.getId());
            qry.setParameter("name", (Object)"AbsMappedSuperName");
            qry.setParameter("crtDate", (Object)now);
            qry.getSingleResult();
            TestXMLExplicitAccess.fail((String)"Usage of this query should have thrown an exception");
        }
        catch (Exception e) {
            this.assertExceptionMessage(e, ArgumentException.class, "No field named \"crtDate\" in \"XMLPropertySub\"", "[createDate, id, name]");
        }
        em.close();
    }

    public void testAbstractMappedSuperProperty() {
        OpenJPAEntityManagerFactorySPI emf = (OpenJPAEntityManagerFactorySPI)OpenJPAPersistence.createEntityManagerFactory((String)"Access-XML", (String)"org/apache/openjpa/persistence/access/access-persistence.xml");
        OpenJPAEntityManagerSPI em = emf.createEntityManager();
        XMLFieldSub fs = new XMLFieldSub();
        fs.setName("AbsMappedSuperName");
        Date now = new Date();
        fs.setCreateDate(now);
        em.getTransaction().begin();
        em.persist((Object)fs);
        em.getTransaction().commit();
        em.clear();
        OpenJPAQuery qry = em.createNamedQuery("XMLFieldSub.query");
        qry.setParameter("id", (Object)fs.getId());
        qry.setParameter("name", (Object)"AbsMappedSuperName");
        qry.setParameter("crtDate", (Object)now);
        XMLFieldSub fs2 = (XMLFieldSub)qry.getSingleResult();
        TestXMLExplicitAccess.assertEquals((Object)fs, (Object)fs2);
        TestXMLExplicitAccess.assertEquals((String)fs2.getName(), (String)"AbsMappedSuperName");
        TestXMLExplicitAccess.assertEquals((String)fs2.getCreateDate().toString(), (String)now.toString());
        try {
            qry = em.createNamedQuery("XMLFieldSub.badQuery");
            qry.setParameter("id", (Object)fs.getId());
            qry.setParameter("name", (Object)"AbsMappedSuperName");
            qry.setParameter("crtDate", (Object)now);
            qry.getSingleResult();
            TestXMLExplicitAccess.fail((String)"Usage of this query should have thrown an exception");
        }
        catch (Exception e) {
            this.assertExceptionMessage(e, ArgumentException.class, "No field named \"createDate\" in \"XMLFieldSub\"", "[crtDate, id, name]");
        }
        em.close();
    }

    public void testMappedSuperField() {
        OpenJPAEntityManagerFactorySPI emf = (OpenJPAEntityManagerFactorySPI)OpenJPAPersistence.createEntityManagerFactory((String)"Access-XML", (String)"org/apache/openjpa/persistence/access/access-persistence.xml");
        OpenJPAEntityManagerSPI em = emf.createEntityManager();
        XMLPropertySub2 ps = new XMLPropertySub2();
        ps.setName("MappedSuperName");
        Date now = new Date();
        ps.setCreateDate(now);
        em.getTransaction().begin();
        em.persist((Object)ps);
        em.getTransaction().commit();
        em.clear();
        OpenJPAQuery qry = em.createNamedQuery("XMLPropertySub2.query");
        qry.setParameter("id", (Object)ps.getId());
        qry.setParameter("name", (Object)"MappedSuperName");
        qry.setParameter("crtDate", (Object)now);
        XMLPropertySub2 ps2 = (XMLPropertySub2)qry.getSingleResult();
        TestXMLExplicitAccess.assertEquals((Object)ps, (Object)ps2);
        TestXMLExplicitAccess.assertEquals((String)ps2.getName(), (String)"MappedSuperName");
        TestXMLExplicitAccess.assertEquals((String)ps2.getCreateDate().toString(), (String)now.toString());
        try {
            qry = em.createNamedQuery("XMLPropertySub2.badQuery");
            qry.setParameter("id", (Object)ps.getId());
            qry.setParameter("name", (Object)"MappedSuperName");
            qry.setParameter("crtDate", (Object)now);
            qry.getSingleResult();
            TestXMLExplicitAccess.fail((String)"Usage of this query should have thrown an exception");
        }
        catch (Exception e) {
            this.assertExceptionMessage(e, ArgumentException.class, "No field named \"crtDate\" in \"XMLPropertySub2\"", "[createDate, id, name]");
        }
        em.close();
    }

    public void testMappedSuperProperty() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        XMLFieldSub2 fs = new XMLFieldSub2();
        fs.setName("MappedSuperName");
        Date now = new Date();
        fs.setCreateDate(now);
        em.getTransaction().begin();
        em.persist((Object)fs);
        em.getTransaction().commit();
        em.clear();
        OpenJPAQuery qry = em.createNamedQuery("XMLFieldSub2.query");
        qry.setParameter("id", (Object)fs.getId());
        qry.setParameter("name", (Object)"MappedSuperName");
        qry.setParameter("crtDate", (Object)now);
        XMLFieldSub2 fs2 = (XMLFieldSub2)qry.getSingleResult();
        TestXMLExplicitAccess.assertEquals((Object)fs, (Object)fs2);
        TestXMLExplicitAccess.assertEquals((String)fs2.getName(), (String)"MappedSuperName");
        TestXMLExplicitAccess.assertEquals((String)fs2.getCreateDate().toString(), (String)now.toString());
        try {
            qry = em.createNamedQuery("XMLFieldSub2.badQuery");
            qry.setParameter("id", (Object)fs.getId());
            qry.setParameter("name", (Object)"MappedSuperName");
            qry.setParameter("crtDate", (Object)now);
            qry.getSingleResult();
            TestXMLExplicitAccess.fail((String)"Usage of this query should have thrown an exception");
        }
        catch (Exception e) {
            this.assertExceptionMessage(e, ArgumentException.class, "No field named \"createDate\" in \"XMLFieldSub2\"", "[crtDate, id, name]");
        }
        em.close();
    }

    public void testMixedMappedSuper() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        XMLMixedFieldSub fs = new XMLMixedFieldSub();
        fs.setName("XMLMixedMappedSuperName");
        fs.setMyFieldProp("MyFieldName");
        Date now = new Date();
        fs.setCreateDate(now);
        em.getTransaction().begin();
        em.persist((Object)fs);
        em.getTransaction().commit();
        em.clear();
        OpenJPAQuery qry = em.createNamedQuery("XMLMixedFieldSub.query");
        qry.setParameter("id", (Object)fs.getId());
        qry.setParameter("name", (Object)"XMLMixedMappedSuperName");
        qry.setParameter("crtDate", (Object)now);
        qry.setParameter("myField", (Object)"MyFieldName");
        XMLMixedFieldSub fs2 = (XMLMixedFieldSub)qry.getSingleResult();
        TestXMLExplicitAccess.assertEquals((Object)fs, (Object)fs2);
        TestXMLExplicitAccess.assertEquals((String)fs2.getName(), (String)"XMLMixedMappedSuperName");
        TestXMLExplicitAccess.assertEquals((String)fs2.getCreateDate().toString(), (String)now.toString());
        try {
            qry = em.createNamedQuery("XMLMixedFieldSub.badQuery");
            qry.setParameter("id", (Object)fs.getId());
            qry.setParameter("name", (Object)"XMLMixedMappedSuperName");
            qry.setParameter("myField", (Object)"MyFieldName");
            qry.getSingleResult();
            TestXMLExplicitAccess.fail((String)"Usage of this query should have thrown an exception");
        }
        catch (Exception e) {
            this.assertExceptionMessage(e, ArgumentException.class, "No field named \"myFieldProp\" in \"XMLMixedFieldSub\"", "[createDate, mid, myField, name]");
        }
        em.close();
    }

    public void testEntityFieldDefaultInheritance() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        XMLFieldSub3 fs = new XMLFieldSub3();
        fs.setName("EntitySuperName");
        Date now = new Date();
        fs.setCreateDate(now);
        XMLSuperPropertyEntity spe = new XMLSuperPropertyEntity();
        spe.setName("SuperPropertyEntity");
        em.getTransaction().begin();
        em.persist((Object)fs);
        em.persist((Object)spe);
        em.getTransaction().commit();
        em.clear();
        OpenJPAQuery qry = em.createNamedQuery("XMLFieldSub3.query");
        qry.setParameter("id", (Object)fs.getId());
        qry.setParameter("name", (Object)"EntitySuperName");
        qry.setParameter("crtDate", (Object)now);
        XMLFieldSub3 fs2 = (XMLFieldSub3)qry.getSingleResult();
        TestXMLExplicitAccess.assertEquals((Object)fs, (Object)fs2);
        TestXMLExplicitAccess.assertEquals((String)fs2.getName(), (String)"EntitySuperName");
        TestXMLExplicitAccess.assertEquals((String)fs2.getCreateDate().toString(), (String)now.toString());
        try {
            qry = em.createNamedQuery("XMLFieldSub3.badQuery");
            qry.setParameter("id", (Object)fs.getId());
            qry.setParameter("name", (Object)"EntitySuperName");
            qry.setParameter("crtDate", (Object)now);
            qry.getSingleResult();
            TestXMLExplicitAccess.fail((String)"Usage of this query should have thrown an exception");
        }
        catch (Exception e) {
            this.assertExceptionMessage(e, ArgumentException.class, "No field named \"createDate\" in \"XMLFieldSub3\"", "[crtDate, id, name]");
        }
        qry = em.createNamedQuery("XMLSuperPropertyEntity.query");
        qry.setParameter("id", (Object)spe.getId());
        qry.setParameter("name", (Object)"SuperPropertyEntity");
        XMLSuperPropertyEntity spe2 = (XMLSuperPropertyEntity)qry.getSingleResult();
        TestXMLExplicitAccess.assertEquals((Object)spe, (Object)spe2);
        TestXMLExplicitAccess.assertEquals((String)spe2.getName(), (String)"SuperPropertyEntity");
        try {
            qry = em.createNamedQuery("XMLSuperPropertyEntity.badQuery");
            qry.setParameter("id", (Object)spe.getId());
            qry.setParameter("name", (Object)"SuperPropertyEntity");
            qry.setParameter("crtDate", (Object)now);
            qry.getSingleResult();
            TestXMLExplicitAccess.fail((String)"Usage of this query should have thrown an exception");
        }
        catch (Exception e) {
            this.assertExceptionMessage(e, ArgumentException.class, "No field named \"crtDate\" in \"XMLSuperPropertyEntity\"", "[id, name]");
        }
        em.close();
    }

    public void testEntityPropertyDefaultInheritance() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        XMLPropertySub3 ps = new XMLPropertySub3();
        ps.setName("EntitySuperName");
        Date now = new Date();
        ps.setCreateDate(now);
        XMLSuperFieldEntity sfe = new XMLSuperFieldEntity();
        sfe.setName("SuperFieldEntity");
        em.getTransaction().begin();
        em.persist((Object)ps);
        em.persist((Object)sfe);
        em.getTransaction().commit();
        em.clear();
        OpenJPAQuery qry = em.createNamedQuery("XMLPropertySub3.query");
        qry.setParameter("id", (Object)ps.getId());
        qry.setParameter("name", (Object)"EntitySuperName");
        qry.setParameter("crtDate", (Object)now);
        XMLPropertySub3 ps2 = (XMLPropertySub3)qry.getSingleResult();
        TestXMLExplicitAccess.assertEquals((Object)ps, (Object)ps2);
        TestXMLExplicitAccess.assertEquals((String)ps2.getName(), (String)"EntitySuperName");
        TestXMLExplicitAccess.assertEquals((String)ps2.getCreateDate().toString(), (String)now.toString());
        try {
            qry = em.createNamedQuery("XMLPropertySub3.badQuery");
            qry.setParameter("id", (Object)ps.getId());
            qry.setParameter("name", (Object)"EntitySuperName");
            qry.setParameter("crtDate", (Object)now);
            qry.getSingleResult();
            TestXMLExplicitAccess.fail((String)"Usage of this query should have thrown an exception");
        }
        catch (Exception e) {
            this.assertExceptionMessage(e, ArgumentException.class, "No field named \"crtDate\" in \"XMLPropertySub3\"", "[createDate, id, name]");
        }
        qry = em.createNamedQuery("XMLSuperFieldEntity.query");
        qry.setParameter("id", (Object)sfe.getId());
        qry.setParameter("name", (Object)"SuperFieldEntity");
        XMLSuperFieldEntity sfe2 = (XMLSuperFieldEntity)qry.getSingleResult();
        TestXMLExplicitAccess.assertEquals((Object)sfe2, (Object)sfe2);
        TestXMLExplicitAccess.assertEquals((String)sfe2.getName(), (String)"SuperFieldEntity");
        try {
            qry = em.createNamedQuery("XMLSuperFieldEntity.badQuery");
            qry.setParameter("id", (Object)sfe.getId());
            qry.setParameter("name", (Object)"SuperFieldEntity");
            qry.setParameter("crtDate", (Object)now);
            qry.getSingleResult();
            TestXMLExplicitAccess.fail((String)"Usage of this query should have thrown an exception");
        }
        catch (Exception e) {
            this.assertExceptionMessage(e, ArgumentException.class, "No field named \"crtDate\" in \"XMLSuperFieldEntity\"", "[id, name]");
        }
        em.close();
    }

    @AllowFailure(value=true, message="Support for explicit Access on embeddables is not complete.")
    public void testEmbeddablesField() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        XMLEmbedFieldAccess efa = new XMLEmbedFieldAccess();
        efa.setFirstName("J");
        efa.setLastName("Tolkien");
        XMLPropEmbedEntity pe = new XMLPropEmbedEntity();
        pe.setName("PropEmbedEntity");
        pe.setEmbedProp(efa);
        em.getTransaction().begin();
        em.persist((Object)pe);
        em.getTransaction().commit();
        em.clear();
        OpenJPAQuery qry = em.createNamedQuery("XMLPropEmbedEntity.query");
        qry.setParameter("id", (Object)pe.getId());
        qry.setParameter("name", (Object)"PropEmbedEntity");
        qry.setParameter("firstName", (Object)"J");
        qry.setParameter("lastName", (Object)"Tolkien");
        XMLPropEmbedEntity pe2 = (XMLPropEmbedEntity)qry.getSingleResult();
        TestXMLExplicitAccess.assertEquals((Object)pe, (Object)pe2);
        TestXMLExplicitAccess.assertEquals((Object)efa, (Object)pe2.getEmbedProp());
        try {
            qry = em.createNamedQuery("XMLPropEmbedEntity.badQuery");
            qry.setParameter("id", (Object)pe.getId());
            qry.setParameter("name", (Object)"PropEmbedEntity");
            qry.setParameter("firstName", (Object)"J");
            qry.setParameter("lastName", (Object)"Tolkien");
            qry.getSingleResult();
            TestXMLExplicitAccess.fail((String)"Query execution should have failed.");
        }
        catch (Exception e) {
            this.assertExceptionMessage(e, ArgumentException.class, "No field named \"firstName\" in \"XMLEmbedFieldAccess\"", "[fName, lName]");
        }
        em.close();
    }

    @AllowFailure(value=true, message="Support for explicit Access on embeddables is not complete.")
    public void testEmbeddablesProperty() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        XMLEmbedPropAccess epa = new XMLEmbedPropAccess();
        epa.setFirstName("Walt");
        epa.setLastName("Whitman");
        XMLFieldEmbedEntity fe = new XMLFieldEmbedEntity();
        fe.setName("FieldEmbedEntity");
        fe.setEPA(epa);
        em.getTransaction().begin();
        em.persist((Object)fe);
        em.getTransaction().commit();
        em.clear();
        OpenJPAQuery qry = em.createNamedQuery("XMLFieldEmbedEntity.query");
        qry.setParameter("id", (Object)fe.getId());
        qry.setParameter("name", (Object)"FieldEmbedEntity");
        qry.setParameter("firstName", (Object)"Walt");
        qry.setParameter("lastName", (Object)"Whitman");
        XMLFieldEmbedEntity fe2 = (XMLFieldEmbedEntity)qry.getSingleResult();
        fe2.getEPA().getFirstName();
        fe2.getEPA().getLastName();
        TestXMLExplicitAccess.assertEquals((Object)fe, (Object)fe2);
        TestXMLExplicitAccess.assertEquals((Object)epa, (Object)fe2.getEPA());
        try {
            qry = em.createNamedQuery("XMLFieldEmbedEntity.badQuery");
            qry.setParameter("id", (Object)fe.getId());
            qry.setParameter("name", (Object)"FieldEmbedEntity");
            qry.setParameter("firstName", (Object)"Walt");
            qry.setParameter("lastName", (Object)"Whitman");
            qry.getSingleResult();
            TestXMLExplicitAccess.fail((String)"Query execution should have failed.");
        }
        catch (Exception e) {
            this.assertExceptionMessage(e, ArgumentException.class, "No field named \"fName\" in \"XMLEmbedPropAccess\"", "[firstName, lastName]");
        }
        em.close();
    }

    @AllowFailure(value=true, message="Support for explicit Access on embeddables is not complete.")
    public void testMixedEmbeddables() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        XMLEmbedMixedAccess ema = new XMLEmbedMixedAccess();
        ema.setFirstName("J");
        ema.setLastName("Tolkien");
        ema.setMiddleName("R");
        XMLPropMixedEntity pm = new XMLPropMixedEntity();
        pm.setName("PropMixedEntity");
        pm.setEmbedProp(ema);
        em.getTransaction().begin();
        em.persist((Object)pm);
        em.getTransaction().commit();
        em.clear();
        OpenJPAQuery qry = em.createNamedQuery("XMLPropMixedEntity.query");
        qry.setParameter("id", (Object)pm.getId());
        qry.setParameter("name", (Object)"PropMixedEntity");
        qry.setParameter("firstName", (Object)"J");
        qry.setParameter("lastName", (Object)"Tolkien");
        qry.setParameter("middleName", (Object)"R");
        XMLPropMixedEntity pm2 = (XMLPropMixedEntity)qry.getSingleResult();
        TestXMLExplicitAccess.assertEquals((Object)pm, (Object)pm2);
        TestXMLExplicitAccess.assertEquals((Object)ema, (Object)pm2.getEmbedProp());
        try {
            qry = em.createNamedQuery("XMLPropMixedEntity.badQuery");
            qry.setParameter("id", (Object)pm.getId());
            qry.setParameter("name", (Object)"PropMixedEntity");
            qry.setParameter("firstName", (Object)"J");
            qry.setParameter("lastName", (Object)"Tolkien");
            qry.setParameter("middleName", (Object)"R");
            qry.getSingleResult();
            TestXMLExplicitAccess.fail((String)"Query execution should have failed.");
        }
        catch (Exception e) {
            this.assertExceptionMessage(e, ArgumentException.class, "No field named \"middleName\" in \"XMLEmbedMixedAccess\"", "[firstName, lastName, mName]");
        }
        em.close();
    }
}

