/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.access;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import org.apache.openjpa.meta.AccessCode;
import org.apache.openjpa.meta.ClassMetaData;
import org.apache.openjpa.meta.MetaDataRepository;
import org.apache.openjpa.persistence.ArgumentException;
import org.apache.openjpa.persistence.OpenJPAEntityManagerSPI;
import org.apache.openjpa.persistence.OpenJPAQuery;
import org.apache.openjpa.persistence.access.AbstractMappedSuperField;
import org.apache.openjpa.persistence.access.AbstractMappedSuperProperty;
import org.apache.openjpa.persistence.access.DefFieldMixedPropAccess;
import org.apache.openjpa.persistence.access.DefPropMixedFieldAccess;
import org.apache.openjpa.persistence.access.EmbedFieldAccess;
import org.apache.openjpa.persistence.access.EmbedId;
import org.apache.openjpa.persistence.access.EmbedInnerProp;
import org.apache.openjpa.persistence.access.EmbedMixedAccess;
import org.apache.openjpa.persistence.access.EmbedOuterField;
import org.apache.openjpa.persistence.access.EmbedPropAccess;
import org.apache.openjpa.persistence.access.FieldAccess;
import org.apache.openjpa.persistence.access.FieldAccessPropStratsEntity;
import org.apache.openjpa.persistence.access.FieldEmbedEntity;
import org.apache.openjpa.persistence.access.FieldSub;
import org.apache.openjpa.persistence.access.FieldSub2;
import org.apache.openjpa.persistence.access.FieldSub3;
import org.apache.openjpa.persistence.access.Ingredient;
import org.apache.openjpa.persistence.access.MappedSuperField;
import org.apache.openjpa.persistence.access.MappedSuperProperty;
import org.apache.openjpa.persistence.access.MenuItem;
import org.apache.openjpa.persistence.access.MixedFieldSub;
import org.apache.openjpa.persistence.access.MixedMappedSuper;
import org.apache.openjpa.persistence.access.MixedMultEmbedEntity;
import org.apache.openjpa.persistence.access.MixedNestedEmbedEntity;
import org.apache.openjpa.persistence.access.PropAccess;
import org.apache.openjpa.persistence.access.PropAccessFieldStratsEntity;
import org.apache.openjpa.persistence.access.PropEmbedEntity;
import org.apache.openjpa.persistence.access.PropMixedEntity;
import org.apache.openjpa.persistence.access.PropertySub;
import org.apache.openjpa.persistence.access.PropertySub2;
import org.apache.openjpa.persistence.access.PropertySub3;
import org.apache.openjpa.persistence.access.Quantity;
import org.apache.openjpa.persistence.access.SuperFieldEntity;
import org.apache.openjpa.persistence.access.SuperPropertyEntity;
import org.apache.openjpa.persistence.test.SingleEMFTestCase;

public class TestExplicitAccess
extends SingleEMFTestCase {
    public void setUp() {
        this.setUp(CLEAR_TABLES, PropAccess.class, FieldAccess.class, DefFieldMixedPropAccess.class, DefPropMixedFieldAccess.class, AbstractMappedSuperField.class, PropertySub.class, MappedSuperField.class, PropertySub2.class, SuperFieldEntity.class, PropertySub3.class, AbstractMappedSuperProperty.class, FieldSub.class, MappedSuperProperty.class, FieldSub2.class, SuperPropertyEntity.class, FieldSub3.class, MixedMappedSuper.class, MixedFieldSub.class, FieldEmbedEntity.class, EmbedFieldAccess.class, PropEmbedEntity.class, EmbedPropAccess.class, PropMixedEntity.class, EmbedMixedAccess.class, MixedNestedEmbedEntity.class, EmbedInnerProp.class, EmbedOuterField.class, MixedMultEmbedEntity.class, FieldAccessPropStratsEntity.class, PropAccessFieldStratsEntity.class, EmbedId.class, MenuItem.class, Ingredient.class, Quantity.class);
    }

    public void testClassSpecifiedFieldAccess() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        FieldAccess fa = new FieldAccess();
        fa.setStringField("FieldAccess");
        em.getTransaction().begin();
        em.persist((Object)fa);
        em.getTransaction().commit();
        em.clear();
        OpenJPAQuery qry = em.createNamedQuery("FieldAccess.query");
        qry.setParameter("id", (Object)fa.getId());
        qry.setParameter("strVal", (Object)"FieldAccess");
        FieldAccess fa2 = (FieldAccess)qry.getSingleResult();
        TestExplicitAccess.assertEquals((int)fa.getId(), (int)fa2.getId());
        em.close();
    }

    public void testClassSpecifiedPropertyAccess() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        PropAccess pa = new PropAccess();
        pa.setStrProp("PropertyAccess");
        em.getTransaction().begin();
        em.persist((Object)pa);
        em.getTransaction().commit();
        em.clear();
        OpenJPAQuery qry = em.createNamedQuery("PropertyAccess.query");
        qry.setParameter("id", (Object)pa.getId());
        qry.setParameter("strVal", (Object)"PropertyAccess");
        PropAccess pa2 = (PropAccess)qry.getSingleResult();
        TestExplicitAccess.assertEquals((Object)pa, (Object)pa2);
    }

    public void testClassSpecifiedMixedSinglePCFieldAccess() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        DefFieldMixedPropAccess dfmpa = new DefFieldMixedPropAccess();
        dfmpa.setStrField("NonPCSetter");
        dfmpa.setStringField("DFMPA");
        em.getTransaction().begin();
        em.persist((Object)dfmpa);
        em.getTransaction().commit();
        em.clear();
        OpenJPAQuery qry = em.createNamedQuery("DFMPA.query");
        qry.setParameter("id", (Object)dfmpa.getId());
        qry.setParameter("strVal", (Object)"DFMPA");
        DefFieldMixedPropAccess dfmpa2 = (DefFieldMixedPropAccess)qry.getSingleResult();
        TestExplicitAccess.assertEquals((Object)dfmpa, (Object)dfmpa2);
        TestExplicitAccess.assertEquals((String)dfmpa2.getStringField(), (String)"DFMPA");
        try {
            qry = em.createNamedQuery("DFMPA.badQuery");
            qry.setParameter("id", (Object)dfmpa.getId());
            qry.setParameter("strVal", (Object)"DFMPA");
            qry.getSingleResult();
            TestExplicitAccess.fail((String)"Usage of this query should have thrown an exception");
        }
        catch (Exception e) {
            this.assertExceptionMessage(e, ArgumentException.class, "No field named \"strField\" in \"DefFieldMixedPropAccess\"", "[id, stringField, version]");
        }
        em.close();
    }

    public void testClassSpecifiedMixedSinglePCPropertyAccess() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        DefPropMixedFieldAccess dpmfa = new DefPropMixedFieldAccess();
        dpmfa.setStrProp("DPMFA");
        em.getTransaction().begin();
        em.persist((Object)dpmfa);
        em.getTransaction().commit();
        em.clear();
        OpenJPAQuery qry = em.createNamedQuery("DPMFA.query");
        qry.setParameter("id", (Object)dpmfa.getId());
        qry.setParameter("strVal", (Object)"DPMFA");
        DefPropMixedFieldAccess dpmfa2 = (DefPropMixedFieldAccess)qry.getSingleResult();
        TestExplicitAccess.assertEquals((Object)dpmfa, (Object)dpmfa2);
        TestExplicitAccess.assertEquals((String)dpmfa2.getStrProp(), (String)"DPMFA");
        try {
            qry = em.createNamedQuery("DPMFA.badQuery");
            qry.setParameter("id", (Object)dpmfa.getId());
            qry.setParameter("strVal", (Object)"DPMFA");
            qry.getSingleResult();
            TestExplicitAccess.fail((String)"Usage of this query should have thrown an exception");
        }
        catch (Exception e) {
            this.assertExceptionMessage(e, ArgumentException.class, "No field named \"strProp\" in \"DefPropMixedFieldAccess\"", "[id, strField, version]");
        }
        em.close();
    }

    public void testAbstractMappedSuperField() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        PropertySub ps = new PropertySub();
        ps.setName("AbsMappedSuperName");
        Date now = new Date();
        ps.setCreateDate(now);
        em.getTransaction().begin();
        em.persist((Object)ps);
        em.getTransaction().commit();
        em.clear();
        OpenJPAQuery qry = em.createNamedQuery("PropertySub.query");
        qry.setParameter("id", (Object)ps.getId());
        qry.setParameter("name", (Object)"AbsMappedSuperName");
        qry.setParameter("crtDate", (Object)now);
        PropertySub ps2 = (PropertySub)qry.getSingleResult();
        TestExplicitAccess.assertEquals((Object)ps, (Object)ps2);
        TestExplicitAccess.assertEquals((String)ps2.getName(), (String)"AbsMappedSuperName");
        TestExplicitAccess.assertEquals((String)ps2.getCreateDate().toString(), (String)now.toString());
        try {
            qry = em.createNamedQuery("PropertySub.badQuery");
            qry.setParameter("id", (Object)ps.getId());
            qry.setParameter("name", (Object)"AbsMappedSuperName");
            qry.setParameter("crtDate", (Object)now);
            qry.getSingleResult();
            TestExplicitAccess.fail((String)"Usage of this query should have thrown an exception");
        }
        catch (Exception e) {
            this.assertExceptionMessage(e, ArgumentException.class, "No field named \"crtDate\" in \"PropertySub\"", "[createDate, id, name]");
        }
        em.close();
    }

    public void testAbstractMappedSuperProperty() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        FieldSub fs = new FieldSub();
        fs.setName("AbsMappedSuperName");
        Date now = new Date();
        fs.setCreateDate(now);
        em.getTransaction().begin();
        em.persist((Object)fs);
        em.getTransaction().commit();
        em.clear();
        OpenJPAQuery qry = em.createNamedQuery("FieldSub.query");
        qry.setParameter("id", (Object)fs.getId());
        qry.setParameter("name", (Object)"AbsMappedSuperName");
        qry.setParameter("crtDate", (Object)now);
        FieldSub fs2 = (FieldSub)qry.getSingleResult();
        TestExplicitAccess.assertEquals((Object)fs, (Object)fs2);
        TestExplicitAccess.assertEquals((String)fs2.getName(), (String)"AbsMappedSuperName");
        TestExplicitAccess.assertEquals((String)fs2.getCreateDate().toString(), (String)now.toString());
        try {
            qry = em.createNamedQuery("FieldSub.badQuery");
            qry.setParameter("id", (Object)fs.getId());
            qry.setParameter("name", (Object)"AbsMappedSuperName");
            qry.setParameter("crtDate", (Object)now);
            qry.getSingleResult();
            TestExplicitAccess.fail((String)"Usage of this query should have thrown an exception");
        }
        catch (Exception e) {
            this.assertExceptionMessage(e, ArgumentException.class, "No field named \"createDate\" in \"FieldSub\"", "[crtDate, id, name]");
        }
        em.close();
    }

    public void testMappedSuperField() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        PropertySub2 ps = new PropertySub2();
        ps.setName("MappedSuperName");
        Date now = new Date();
        ps.setCreateDate(now);
        em.getTransaction().begin();
        em.persist((Object)ps);
        em.getTransaction().commit();
        em.clear();
        OpenJPAQuery qry = em.createNamedQuery("PropertySub2.query");
        qry.setParameter("id", (Object)ps.getId());
        qry.setParameter("name", (Object)"MappedSuperName");
        qry.setParameter("crtDate", (Object)now);
        PropertySub2 ps2 = (PropertySub2)qry.getSingleResult();
        TestExplicitAccess.assertEquals((Object)ps, (Object)ps2);
        TestExplicitAccess.assertEquals((String)ps2.getName(), (String)"MappedSuperName");
        TestExplicitAccess.assertEquals((String)ps2.getCreateDate().toString(), (String)now.toString());
        try {
            qry = em.createNamedQuery("PropertySub2.badQuery");
            qry.setParameter("id", (Object)ps.getId());
            qry.setParameter("name", (Object)"MappedSuperName");
            qry.setParameter("crtDate", (Object)now);
            qry.getSingleResult();
            TestExplicitAccess.fail((String)"Usage of this query should have thrown an exception");
        }
        catch (Exception e) {
            this.assertExceptionMessage(e, ArgumentException.class, "No field named \"crtDate\" in \"PropertySub2\"", "[createDate, id, name]");
        }
        em.close();
    }

    public void testMappedSuperProperty() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        FieldSub2 fs = new FieldSub2();
        fs.setName("MappedSuperName");
        Date now = new Date();
        fs.setCreateDate(now);
        em.getTransaction().begin();
        em.persist((Object)fs);
        em.getTransaction().commit();
        em.clear();
        OpenJPAQuery qry = em.createNamedQuery("FieldSub2.query");
        qry.setParameter("id", (Object)fs.getId());
        qry.setParameter("name", (Object)"MappedSuperName");
        qry.setParameter("crtDate", (Object)now);
        FieldSub2 fs2 = (FieldSub2)qry.getSingleResult();
        TestExplicitAccess.assertEquals((Object)fs, (Object)fs2);
        TestExplicitAccess.assertEquals((String)fs2.getName(), (String)"MappedSuperName");
        TestExplicitAccess.assertEquals((String)fs2.getCreateDate().toString(), (String)now.toString());
        try {
            qry = em.createNamedQuery("FieldSub2.badQuery");
            qry.setParameter("id", (Object)fs.getId());
            qry.setParameter("name", (Object)"MappedSuperName");
            qry.setParameter("crtDate", (Object)now);
            qry.getSingleResult();
            TestExplicitAccess.fail((String)"Usage of this query should have thrown an exception");
        }
        catch (Exception e) {
            this.assertExceptionMessage(e, ArgumentException.class, "No field named \"createDate\" in \"FieldSub2\"", "[crtDate, id, name]");
        }
        em.close();
    }

    public void testMixedMappedSuper() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        MixedFieldSub fs = new MixedFieldSub();
        fs.setName("MixedMappedSuperName");
        fs.setMyFieldProp("MyFieldName");
        Date now = new Date();
        fs.setCreateDate(now);
        em.getTransaction().begin();
        em.persist((Object)fs);
        em.getTransaction().commit();
        em.clear();
        OpenJPAQuery qry = em.createNamedQuery("MixedFieldSub.query");
        qry.setParameter("id", (Object)fs.getId());
        qry.setParameter("name", (Object)"MixedMappedSuperName");
        qry.setParameter("crtDate", (Object)now);
        qry.setParameter("myField", (Object)"MyFieldName");
        MixedFieldSub fs2 = (MixedFieldSub)qry.getSingleResult();
        TestExplicitAccess.assertEquals((Object)fs, (Object)fs2);
        TestExplicitAccess.assertEquals((String)fs2.getName(), (String)"MixedMappedSuperName");
        TestExplicitAccess.assertEquals((String)fs2.getCreateDate().toString(), (String)now.toString());
        try {
            qry = em.createNamedQuery("MixedFieldSub.badQuery");
            qry.setParameter("id", (Object)fs.getId());
            qry.setParameter("name", (Object)"MixedMappedSuperName");
            qry.setParameter("myField", (Object)"MyFieldName");
            qry.getSingleResult();
            TestExplicitAccess.fail((String)"Usage of this query should have thrown an exception");
        }
        catch (Exception e) {
            this.assertExceptionMessage(e, ArgumentException.class, "No field named \"myFieldProp\" in \"MixedFieldSub\"", "[createDate, mid, myField, name]");
        }
        em.close();
    }

    public void testEntityFieldDefaultInheritance() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        FieldSub3 fs = new FieldSub3();
        fs.setName("EntitySuperName");
        Date now = new Date();
        fs.setCreateDate(now);
        SuperPropertyEntity spe = new SuperPropertyEntity();
        spe.setName("SuperPropertyEntity");
        em.getTransaction().begin();
        em.persist((Object)fs);
        em.persist((Object)spe);
        em.getTransaction().commit();
        em.clear();
        OpenJPAQuery qry = em.createNamedQuery("FieldSub3.query");
        qry.setParameter("id", (Object)fs.getId());
        qry.setParameter("name", (Object)"EntitySuperName");
        qry.setParameter("crtDate", (Object)now);
        FieldSub3 fs2 = (FieldSub3)qry.getSingleResult();
        TestExplicitAccess.assertEquals((Object)fs, (Object)fs2);
        TestExplicitAccess.assertEquals((String)fs2.getName(), (String)"EntitySuperName");
        TestExplicitAccess.assertEquals((String)fs2.getCreateDate().toString(), (String)now.toString());
        try {
            qry = em.createNamedQuery("FieldSub3.badQuery");
            qry.setParameter("id", (Object)fs.getId());
            qry.setParameter("name", (Object)"EntitySuperName");
            qry.setParameter("crtDate", (Object)now);
            qry.getSingleResult();
            TestExplicitAccess.fail((String)"Usage of this query should have thrown an exception");
        }
        catch (Exception e) {
            this.assertExceptionMessage(e, ArgumentException.class, "No field named \"createDate\" in \"FieldSub3\"", "[crtDate, id, name]");
        }
        qry = em.createNamedQuery("SuperPropertyEntity.query");
        qry.setParameter("id", (Object)spe.getId());
        qry.setParameter("name", (Object)"SuperPropertyEntity");
        SuperPropertyEntity spe2 = (SuperPropertyEntity)qry.getSingleResult();
        TestExplicitAccess.assertEquals((Object)spe, (Object)spe2);
        TestExplicitAccess.assertEquals((String)spe2.getName(), (String)"SuperPropertyEntity");
        try {
            qry = em.createNamedQuery("SuperPropertyEntity.badQuery");
            qry.setParameter("id", (Object)spe.getId());
            qry.setParameter("name", (Object)"SuperPropertyEntity");
            qry.setParameter("crtDate", (Object)now);
            qry.getSingleResult();
            TestExplicitAccess.fail((String)"Usage of this query should have thrown an exception");
        }
        catch (Exception e) {
            this.assertExceptionMessage(e, ArgumentException.class, "No field named \"crtDate\" in \"SuperPropertyEntity\"", "[id, name]");
        }
        em.close();
    }

    public void testEntityPropertyDefaultInheritance() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        PropertySub3 ps = new PropertySub3();
        ps.setName("EntitySuperName");
        Date now = new Date();
        ps.setCreateDate(now);
        SuperFieldEntity sfe = new SuperFieldEntity();
        sfe.setName("SuperFieldEntity");
        em.getTransaction().begin();
        em.persist((Object)ps);
        em.persist((Object)sfe);
        em.getTransaction().commit();
        em.clear();
        OpenJPAQuery qry = em.createNamedQuery("PropertySub3.query");
        qry.setParameter("id", (Object)ps.getId());
        qry.setParameter("name", (Object)"EntitySuperName");
        qry.setParameter("crtDate", (Object)now);
        PropertySub3 ps2 = (PropertySub3)qry.getSingleResult();
        TestExplicitAccess.assertEquals((Object)ps, (Object)ps2);
        TestExplicitAccess.assertEquals((String)ps2.getName(), (String)"EntitySuperName");
        TestExplicitAccess.assertEquals((String)ps2.getCreateDate().toString(), (String)now.toString());
        try {
            qry = em.createNamedQuery("PropertySub3.badQuery");
            qry.setParameter("id", (Object)ps.getId());
            qry.setParameter("name", (Object)"EntitySuperName");
            qry.setParameter("crtDate", (Object)now);
            qry.getSingleResult();
            TestExplicitAccess.fail((String)"Usage of this query should have thrown an exception");
        }
        catch (Exception e) {
            this.assertExceptionMessage(e, ArgumentException.class, "No field named \"crtDate\" in \"PropertySub3\"", "[createDate, id, name]");
        }
        qry = em.createNamedQuery("SuperFieldEntity.query");
        qry.setParameter("id", (Object)sfe.getId());
        qry.setParameter("name", (Object)"SuperFieldEntity");
        SuperFieldEntity sfe2 = (SuperFieldEntity)qry.getSingleResult();
        TestExplicitAccess.assertEquals((Object)sfe2, (Object)sfe2);
        TestExplicitAccess.assertEquals((String)sfe2.getName(), (String)"SuperFieldEntity");
        try {
            qry = em.createNamedQuery("SuperFieldEntity.badQuery");
            qry.setParameter("id", (Object)sfe.getId());
            qry.setParameter("name", (Object)"SuperFieldEntity");
            qry.setParameter("crtDate", (Object)now);
            qry.getSingleResult();
            TestExplicitAccess.fail((String)"Usage of this query should have thrown an exception");
        }
        catch (Exception e) {
            this.assertExceptionMessage(e, ArgumentException.class, "No field named \"crtDate\" in \"SuperFieldEntity\"", "[id, name]");
        }
        em.close();
    }

    public void testEmbeddablesField() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        EmbedFieldAccess efa = new EmbedFieldAccess();
        efa.setFirstName("J");
        efa.setLastName("Tolkien");
        PropEmbedEntity pe = new PropEmbedEntity();
        pe.setName("PropEmbedEntity");
        pe.setEmbedProp(efa);
        em.getTransaction().begin();
        em.persist((Object)pe);
        em.getTransaction().commit();
        em.clear();
        OpenJPAQuery qry = em.createNamedQuery("PropEmbedEntity.query");
        qry.setParameter("id", (Object)pe.getId());
        qry.setParameter("name", (Object)"PropEmbedEntity");
        qry.setParameter("firstName", (Object)"J");
        qry.setParameter("lastName", (Object)"Tolkien");
        PropEmbedEntity pe2 = (PropEmbedEntity)qry.getSingleResult();
        TestExplicitAccess.assertEquals((Object)pe, (Object)pe2);
        TestExplicitAccess.assertEquals((Object)efa, (Object)pe2.getEmbedProp());
        try {
            qry = em.createNamedQuery("PropEmbedEntity.badQuery");
            qry.setParameter("id", (Object)pe.getId());
            qry.setParameter("name", (Object)"PropEmbedEntity");
            qry.setParameter("firstName", (Object)"J");
            qry.setParameter("lastName", (Object)"Tolkien");
            qry.getSingleResult();
            TestExplicitAccess.fail((String)"Query execution should have failed.");
        }
        catch (Exception e) {
            this.assertExceptionMessage(e, ArgumentException.class, "No field named \"firstName\" in \"EmbedFieldAccess\"", "[fName, lName]");
        }
        em.close();
    }

    public void testEmbeddablesProperty() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        EmbedPropAccess epa = new EmbedPropAccess();
        epa.setFirstName("Walt");
        epa.setLastName("Whitman");
        FieldEmbedEntity fe = new FieldEmbedEntity();
        fe.setName("FieldEmbedEntity");
        fe.setEPA(epa);
        em.getTransaction().begin();
        em.persist((Object)fe);
        em.getTransaction().commit();
        em.clear();
        OpenJPAQuery qry = em.createNamedQuery("FieldEmbedEntity.query");
        qry.setParameter("id", (Object)fe.getId());
        qry.setParameter("name", (Object)"FieldEmbedEntity");
        qry.setParameter("firstName", (Object)"Walt");
        qry.setParameter("lastName", (Object)"Whitman");
        FieldEmbedEntity fe2 = (FieldEmbedEntity)qry.getSingleResult();
        TestExplicitAccess.assertEquals((Object)fe, (Object)fe2);
        TestExplicitAccess.assertEquals((Object)epa, (Object)fe2.getEPA());
        try {
            qry = em.createNamedQuery("FieldEmbedEntity.badQuery");
            qry.setParameter("id", (Object)fe.getId());
            qry.setParameter("name", (Object)"FieldEmbedEntity");
            qry.setParameter("firstName", (Object)"Walt");
            qry.setParameter("lastName", (Object)"Whitman");
            qry.getSingleResult();
            TestExplicitAccess.fail((String)"Query execution should have failed.");
        }
        catch (Exception e) {
            this.assertExceptionMessage(e, ArgumentException.class, "No field named \"fName\" in \"EmbedPropAccess\"", "[firstName, lastName]");
        }
        em.close();
    }

    public void testMixedEmbeddables() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        EmbedMixedAccess ema = new EmbedMixedAccess();
        ema.setFirstName("J");
        ema.setLastName("Tolkien");
        ema.setMiddleName("R");
        PropMixedEntity pm = new PropMixedEntity();
        pm.setName("PropMixedEntity");
        pm.setEmbedProp(ema);
        em.getTransaction().begin();
        em.persist((Object)pm);
        em.getTransaction().commit();
        em.clear();
        OpenJPAQuery qry = em.createNamedQuery("PropMixedEntity.query");
        qry.setParameter("id", (Object)pm.getId());
        qry.setParameter("name", (Object)"PropMixedEntity");
        qry.setParameter("firstName", (Object)"J");
        qry.setParameter("lastName", (Object)"Tolkien");
        qry.setParameter("middleName", (Object)"R");
        PropMixedEntity pm2 = (PropMixedEntity)qry.getSingleResult();
        TestExplicitAccess.assertEquals((Object)pm, (Object)pm2);
        TestExplicitAccess.assertEquals((Object)ema, (Object)pm2.getEmbedProp());
        try {
            qry = em.createNamedQuery("PropMixedEntity.badQuery");
            qry.setParameter("id", (Object)pm.getId());
            qry.setParameter("name", (Object)"PropMixedEntity");
            qry.setParameter("firstName", (Object)"J");
            qry.setParameter("lastName", (Object)"Tolkien");
            qry.setParameter("middleName", (Object)"R");
            qry.getSingleResult();
            TestExplicitAccess.fail((String)"Query execution should have failed.");
        }
        catch (Exception e) {
            this.assertExceptionMessage(e, ArgumentException.class, "No field named \"middleName\" in \"EmbedMixedAccess\"", "[firstName, lastName, mName]");
        }
        em.close();
    }

    public void testNestedEmbeddables() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        EmbedInnerProp eip = new EmbedInnerProp();
        eip.setInnerName("Inner");
        EmbedOuterField eof = new EmbedOuterField();
        eof.setOuterName("Outer");
        eip.setOuterField(eof);
        MixedNestedEmbedEntity pm = new MixedNestedEmbedEntity();
        pm.setName("MixedNestedEmbedEntity");
        pm.setEmbedProp(eip);
        em.getTransaction().begin();
        em.persist((Object)pm);
        em.getTransaction().commit();
        em.clear();
        OpenJPAQuery qry = em.createNamedQuery("MixedNestedEmbedEntity.query");
        qry.setParameter("id", (Object)pm.getId());
        qry.setParameter("name", (Object)"MixedNestedEmbedEntity");
        qry.setParameter("innerName", (Object)"Inner");
        qry.setParameter("outerName", (Object)"Outer");
        MixedNestedEmbedEntity pm2 = (MixedNestedEmbedEntity)qry.getSingleResult();
        TestExplicitAccess.assertEquals((Object)pm, (Object)pm2);
        TestExplicitAccess.assertEquals((Object)eip, (Object)pm2.getEmbedProp());
        try {
            qry = em.createNamedQuery("MixedNestedEmbedEntity.badQuery");
            qry.setParameter("id", (Object)pm.getId());
            qry.setParameter("name", (Object)"MixedNestedEmbedEntity");
            qry.setParameter("innerName", (Object)"Inner");
            qry.setParameter("outerName", (Object)"Outer");
            qry.getSingleResult();
            TestExplicitAccess.fail((String)"Query execution should have failed.");
        }
        catch (Exception e) {
            this.assertExceptionMessage(e, ArgumentException.class, "No field named \"outerName\" in \"EmbedOuterField\"", "[outName]");
        }
        em.close();
    }

    public void testMultipleEmbeddables() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        EmbedFieldAccess efa = new EmbedFieldAccess();
        efa.setFirstName("First");
        efa.setLastName("Last");
        EmbedPropAccess epa = new EmbedPropAccess();
        epa.setFirstName("fname");
        epa.setLastName("lname");
        MixedMultEmbedEntity pm = new MixedMultEmbedEntity();
        pm.setName("MixedMultEmbedEntity");
        pm.setEmbedProp(epa);
        pm.setEmbedField(efa);
        em.getTransaction().begin();
        em.persist((Object)pm);
        em.getTransaction().commit();
        em.clear();
        OpenJPAQuery qry = em.createNamedQuery("MixedMultEmbedEntity.query");
        qry.setParameter("id", (Object)pm.getId());
        qry.setParameter("name", (Object)"MixedMultEmbedEntity");
        qry.setParameter("firstName", (Object)"fname");
        qry.setParameter("lastName", (Object)"lname");
        qry.setParameter("fName", (Object)"First");
        qry.setParameter("lName", (Object)"Last");
        MixedMultEmbedEntity pm2 = (MixedMultEmbedEntity)qry.getSingleResult();
        TestExplicitAccess.assertEquals((Object)pm, (Object)pm2);
        TestExplicitAccess.assertEquals((Object)epa, (Object)pm2.getEmbedProp());
        TestExplicitAccess.assertEquals((Object)efa, (Object)pm2.getEmbedField());
        try {
            qry = em.createNamedQuery("MixedMultEmbedEntity.badQuery1");
            qry.setParameter("id", (Object)pm.getId());
            qry.setParameter("name", (Object)"MixedMultEmbedEntity");
            qry.setParameter("epa", (Object)epa);
            qry.getSingleResult();
            TestExplicitAccess.fail((String)"Query execution should have failed.");
        }
        catch (Exception e) {
            this.assertExceptionMessage(e, ArgumentException.class, "No field named \"epa\" in \"MixedMultEmbedEntity\"", "[embedField, embedProp, mid, name]");
        }
        try {
            qry = em.createNamedQuery("MixedMultEmbedEntity.badQuery2");
            qry.setParameter("id", (Object)pm.getId());
            qry.setParameter("name", (Object)"MixedMultEmbedEntity");
            qry.setParameter("epa", (Object)epa);
            qry.setParameter("firstName", (Object)"First");
            qry.setParameter("lastName", (Object)"Last");
            qry.getSingleResult();
            TestExplicitAccess.fail((String)"Query execution should have failed.");
        }
        catch (Exception e) {
            this.assertException(e, ArgumentException.class);
        }
        em.close();
    }

    public void testPropertyAccessStrategies() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        PropAccessFieldStratsEntity pa = new PropAccessFieldStratsEntity();
        EmbedId eid = new EmbedId();
        eid.setId(new Random().nextInt());
        eid.setCode("IdCode");
        pa.setEmbedId(eid);
        ArrayList<EmbedPropAccess> elc = new ArrayList<EmbedPropAccess>();
        EmbedPropAccess epa1 = new EmbedPropAccess("Abe", "Lincoln");
        EmbedPropAccess epa2 = new EmbedPropAccess("John", "Kennedy");
        elc.add(epa1);
        elc.add(epa2);
        pa.setElementCollection(elc);
        EmbedFieldAccess efa = new EmbedFieldAccess();
        efa.setFirstName("The");
        efa.setLastName("President");
        pa.setEmbedField(efa);
        pa.setName("PropAccessFieldStratsEntity");
        PropAccess propa = new PropAccess();
        propa.setStrProp("PropAccess");
        pa.setManyToOne(propa);
        ArrayList<FieldAccess> fac = new ArrayList<FieldAccess>();
        FieldAccess fa = new FieldAccess();
        fa.setStrField("FieldAccess");
        fac.add(fa);
        pa.setOneToMany(fac);
        PropAccess pa2 = new PropAccess();
        pa2.setStrProp("PropAccess2");
        pa.setOneToOne(pa2);
        em.getTransaction().begin();
        em.persist((Object)pa);
        em.getTransaction().commit();
        em.clear();
        PropAccessFieldStratsEntity newpa = (PropAccessFieldStratsEntity)em.find(PropAccessFieldStratsEntity.class, (Object)eid);
        TestExplicitAccess.assertNotNull((Object)newpa);
        TestExplicitAccess.assertEquals((Object)newpa.getEmbedId(), (Object)eid);
        MetaDataRepository mdr = em.getConfiguration().getMetaDataRepositoryInstance();
        ClassMetaData cmd = mdr.getMetaData(PropAccessFieldStratsEntity.class, null, true);
        TestExplicitAccess.assertNotNull((Object)cmd.getField("embedId"));
        TestExplicitAccess.assertNotNull((Object)cmd.getField("m2one"));
        TestExplicitAccess.assertNotNull((Object)cmd.getField("one2m"));
        TestExplicitAccess.assertNotNull((Object)cmd.getField("one2one"));
        TestExplicitAccess.assertNotNull((Object)cmd.getField("ecoll"));
        TestExplicitAccess.assertNotNull((Object)cmd.getField("embed"));
        TestExplicitAccess.assertNotNull((Object)cmd.getField("ver"));
        TestExplicitAccess.assertNotNull((Object)cmd.getField("m2m"));
        TestExplicitAccess.assertNotNull((Object)cmd.getField("name"));
        TestExplicitAccess.assertTrue(((cmd.getField("name").getAccessType() & AccessCode.FIELD) == AccessCode.FIELD ? 1 : 0) != 0);
        TestExplicitAccess.assertNull((Object)cmd.getField("eid"));
        TestExplicitAccess.assertNull((Object)cmd.getField("elementCollection"));
        TestExplicitAccess.assertNull((Object)cmd.getField("embedField"));
        TestExplicitAccess.assertNull((Object)cmd.getField("version"));
        TestExplicitAccess.assertNull((Object)cmd.getField("manyToOne"));
        TestExplicitAccess.assertNull((Object)cmd.getField("oneToMany"));
        TestExplicitAccess.assertNull((Object)cmd.getField("oneToOne"));
        TestExplicitAccess.assertNull((Object)cmd.getField("manyToMany"));
        em.close();
    }

    public void testFieldAccessStrategies() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        FieldAccessPropStratsEntity fa = new FieldAccessPropStratsEntity();
        EmbedId eid = new EmbedId();
        eid.setId(new Random().nextInt());
        eid.setCode("IdCode");
        fa.setEmbedId(eid);
        ArrayList<EmbedPropAccess> elc = new ArrayList<EmbedPropAccess>();
        EmbedPropAccess epa1 = new EmbedPropAccess("George", "Washington");
        EmbedPropAccess epa2 = new EmbedPropAccess("James", "Carter");
        elc.add(epa1);
        elc.add(epa2);
        fa.setElementCollection(elc);
        EmbedFieldAccess efa = new EmbedFieldAccess();
        efa.setFirstName("The");
        efa.setLastName("President");
        fa.setEmbedField(efa);
        fa.setName("FieldAccessPropStratsEntity");
        PropAccess propa = new PropAccess();
        propa.setStrProp("PropAccess");
        fa.setManyToOne(propa);
        ArrayList<FieldAccess> fac = new ArrayList<FieldAccess>();
        FieldAccess fae = new FieldAccess();
        fae.setStrField("FieldAccess");
        fac.add(fae);
        fa.setOneToMany(fac);
        PropAccess pa = new PropAccess();
        pa.setStrProp("PropAccess");
        fa.setOneToOne(pa);
        em.getTransaction().begin();
        em.persist((Object)fa);
        em.getTransaction().commit();
        em.clear();
        FieldAccessPropStratsEntity newpa = (FieldAccessPropStratsEntity)em.find(FieldAccessPropStratsEntity.class, (Object)eid);
        TestExplicitAccess.assertNotNull((Object)newpa);
        TestExplicitAccess.assertEquals((Object)newpa.getEmbedId(), (Object)eid);
        MetaDataRepository mdr = em.getConfiguration().getMetaDataRepositoryInstance();
        ClassMetaData cmd = mdr.getMetaData(FieldAccessPropStratsEntity.class, null, true);
        TestExplicitAccess.assertNotNull((Object)cmd.getField("eid"));
        TestExplicitAccess.assertNotNull((Object)cmd.getField("elementCollection"));
        TestExplicitAccess.assertNotNull((Object)cmd.getField("embedField"));
        TestExplicitAccess.assertNotNull((Object)cmd.getField("version"));
        TestExplicitAccess.assertNotNull((Object)cmd.getField("manyToOne"));
        TestExplicitAccess.assertNotNull((Object)cmd.getField("oneToMany"));
        TestExplicitAccess.assertNotNull((Object)cmd.getField("oneToOne"));
        TestExplicitAccess.assertNotNull((Object)cmd.getField("manyToMany"));
        TestExplicitAccess.assertNotNull((Object)cmd.getField("name"));
        TestExplicitAccess.assertTrue(((cmd.getField("name").getAccessType() & AccessCode.PROPERTY) == AccessCode.PROPERTY ? 1 : 0) != 0);
        TestExplicitAccess.assertNull((Object)cmd.getField("embedId"));
        TestExplicitAccess.assertNull((Object)cmd.getField("m2one"));
        TestExplicitAccess.assertNull((Object)cmd.getField("one2m"));
        TestExplicitAccess.assertNull((Object)cmd.getField("one2one"));
        TestExplicitAccess.assertNull((Object)cmd.getField("ecoll"));
        TestExplicitAccess.assertNull((Object)cmd.getField("embed"));
        TestExplicitAccess.assertNull((Object)cmd.getField("ver"));
        TestExplicitAccess.assertNull((Object)cmd.getField("m2m"));
        em.close();
    }

    public void testMapWithNestedEmbeddable() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        MenuItem mi = new MenuItem();
        mi.setName("PB & J Sandwich");
        HashMap<String, Ingredient> ingredients = new HashMap<String, Ingredient>();
        mi.setIngredients(ingredients);
        Ingredient i1 = new Ingredient("Peanut Butter");
        i1.setDescription("Edible brown paste, made from peanuts");
        Quantity q1 = new Quantity(1.0, "Tbsp");
        i1.setQuantity(q1);
        ingredients.put("Peanut Butter", i1);
        Ingredient i2 = new Ingredient("Jelly");
        i2.setDescription("Sweet gel, made from fruit");
        Quantity q2 = new Quantity(1.5, "Tbsp");
        i2.setQuantity(q2);
        ingredients.put("Jelly", i2);
        Ingredient i3 = new Ingredient("Bread");
        i3.setDescription("Baked material, made from flour and water");
        Quantity q3 = new Quantity(2.0, "Slice");
        i3.setQuantity(q3);
        ingredients.put("Bread", i3);
        em.getTransaction().begin();
        em.persist((Object)mi);
        em.getTransaction().commit();
        em.clear();
        MenuItem mi2 = (MenuItem)em.find(MenuItem.class, (Object)mi.getId());
        TestExplicitAccess.assertEquals((String)mi2.getId(), (String)mi.getId());
        Map<String, Ingredient> ing2 = mi2.getIngredients();
        TestExplicitAccess.assertTrue((boolean)ing2.containsKey("Peanut Butter"));
        Quantity q = ing2.get("Peanut Butter").getQuantity();
        TestExplicitAccess.assertNotNull((Object)q);
        TestExplicitAccess.assertEquals((Object)1.0, (Object)q.getAmount());
        TestExplicitAccess.assertEquals((String)"Tbsp", (String)q.getUnitOfMeasure());
        TestExplicitAccess.assertTrue((boolean)ing2.containsKey("Jelly"));
        q = ing2.get("Jelly").getQuantity();
        TestExplicitAccess.assertNotNull((Object)q);
        TestExplicitAccess.assertEquals((Object)1.5, (Object)q.getAmount());
        TestExplicitAccess.assertEquals((String)"Tbsp", (String)q.getUnitOfMeasure());
        TestExplicitAccess.assertTrue((boolean)ing2.containsKey("Bread"));
        q = ing2.get("Bread").getQuantity();
        TestExplicitAccess.assertNotNull((Object)q);
        TestExplicitAccess.assertEquals((Object)2.0, (Object)q.getAmount());
        TestExplicitAccess.assertEquals((String)"Slice", (String)q.getUnitOfMeasure());
        em.remove((Object)mi2);
        em.close();
    }

    private boolean verifyException(Exception e, Class c, String ... strings) {
        if (c.isInstance(e)) {
            String exMessage = e.getMessage();
            for (String msg : strings) {
                if (exMessage.contains(msg)) continue;
                return false;
            }
            return true;
        }
        return false;
    }
}

