/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.apache.openjpa.persistence.Country;
import org.apache.openjpa.persistence.Country1;
import org.apache.openjpa.persistence.Embed;
import org.apache.openjpa.persistence.OpenJPAEntityManagerSPI;
import org.apache.openjpa.persistence.Security;
import org.apache.openjpa.persistence.Security1;
import org.apache.openjpa.persistence.test.SQLListenerTestCase;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestXMLPersistenceMetaDataParser
extends SQLListenerTestCase {
    @Override
    public void setUp() {
        super.setUp(CLEAR_TABLES, Security1.class, Country1.class, Security.class, Country.class);
    }

    @Override
    protected String getPersistenceUnitName() {
        return "test-persistence-xml-orm";
    }

    public void testManyToOneLazyFetch() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        long aI_sid = 148007244L;
        long aUS_sid = 1L;
        Security1 aI_security = new Security1(aI_sid, new Embed("XYZ"));
        Country1 aUS_country = new Country1(aUS_sid, "USA");
        aI_security.setCountry1(aUS_country);
        Security aI_securityAnn = new Security(aI_sid, new Embed("XYZ"));
        Country aUS_countryAnn = new Country(aUS_sid, "USA");
        aI_securityAnn.setCountry(aUS_countryAnn);
        em.getTransaction().begin();
        em.persist((Object)aI_security);
        em.persist((Object)aUS_country);
        em.getTransaction().commit();
        em.clear();
        ArrayList<String> XMLsql = new ArrayList<String>();
        ArrayList<String> Annsql = new ArrayList<String>();
        this.sql = new ArrayList<String>();
        aUS_country = (Country1)em.find(Country1.class, (Object)aUS_sid);
        Iterator<String> itr = this.sql.iterator();
        while (itr.hasNext()) {
            XMLsql.add(itr.next());
        }
        this.sql.clear();
        this.sql = new ArrayList<String>();
        aUS_countryAnn = (Country)em.find(Country.class, (Object)aUS_sid);
        itr = this.sql.iterator();
        while (itr.hasNext()) {
            Annsql.add(itr.next());
        }
        this.sql.clear();
        this.compareselectSQLs(Annsql, XMLsql);
        Annsql.clear();
        XMLsql.clear();
        this.sql = new ArrayList<String>();
        aI_security = (Security1)em.find(Security1.class, (Object)aI_sid);
        itr = this.sql.iterator();
        while (itr.hasNext()) {
            XMLsql.add(itr.next());
        }
        this.sql.clear();
        this.sql = new ArrayList<String>();
        aI_securityAnn = (Security)em.find(Security.class, (Object)aI_sid);
        itr = this.sql.iterator();
        while (itr.hasNext()) {
            Annsql.add(itr.next());
        }
        this.sql.clear();
        this.compareselectSQLs(Annsql, XMLsql);
        Annsql.clear();
        XMLsql.clear();
        this.sql = new ArrayList<String>();
        Country1 aUS_country1 = aI_security.getCountry1();
        itr = this.sql.iterator();
        while (itr.hasNext()) {
            XMLsql.add(itr.next());
        }
        this.sql.clear();
        this.sql = new ArrayList<String>();
        Country aUS_country2 = aI_securityAnn.getCountry();
        itr = this.sql.iterator();
        while (itr.hasNext()) {
            Annsql.add(itr.next());
        }
        this.sql.clear();
        this.compareselectSQLs(Annsql, XMLsql);
        Annsql.clear();
        XMLsql.clear();
        em.close();
    }

    public void testManyToOneEagerFetch() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        long aI_sid = 148007245L;
        long aUS_sid = 2L;
        Security1 aI_security = new Security1(aI_sid, new Embed("XYZ"));
        Country1 aUS_country = new Country1(aUS_sid, "USA");
        aI_security.setCountry1(aUS_country);
        aI_security.setCountryEager(aUS_country);
        Security aI_securityAnn = new Security(aI_sid, new Embed("XYZ"));
        Country aUS_countryAnn = new Country(aUS_sid, "USA");
        aI_securityAnn.setCountry(aUS_countryAnn);
        aI_securityAnn.setCountryEager(aUS_countryAnn);
        em.getTransaction().begin();
        em.persist((Object)aI_security);
        em.persist((Object)aUS_country);
        em.getTransaction().commit();
        em.clear();
        aI_security = (Security1)em.find(Security1.class, (Object)aI_sid);
        em.clear();
        Country1 countryEager = aI_security.getCountryEager();
        TestXMLPersistenceMetaDataParser.assertNotNull((Object)countryEager);
        aI_securityAnn = (Security)em.find(Security.class, (Object)aI_sid);
        em.clear();
        Country countryEagerAnn = aI_securityAnn.getCountryEager();
        TestXMLPersistenceMetaDataParser.assertNotNull((Object)countryEagerAnn);
        em.close();
    }

    private void printArrayList(ArrayList aList) {
        Iterator itr = aList.iterator();
        while (itr.hasNext()) {
            System.out.println(itr.next());
        }
    }

    private void compareselectSQLs(List<String> a, List<String> b) {
        TestXMLPersistenceMetaDataParser.assertEquals((int)a.size(), (int)b.size());
        for (int i = 0; i < a.size(); ++i) {
            String aStr = a.get(i);
            String bStr = b.get(i);
            Object[] aArr = aStr.substring(aStr.indexOf("SELECT ") + 7, aStr.indexOf(" FROM ")).split(",");
            Object[] bArr = bStr.substring(bStr.indexOf("SELECT ") + 7, bStr.indexOf(" FROM ")).split(",");
            Arrays.sort(aArr);
            Arrays.sort(bArr);
            TestXMLPersistenceMetaDataParser.assertTrue((boolean)Arrays.equals(aArr, bArr));
            TestXMLPersistenceMetaDataParser.assertEquals((String)aStr.substring(aStr.indexOf("FROM ") + 5), (String)bStr.substring(aStr.indexOf("FROM ") + 5));
        }
    }
}

