/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.jdbc.persistence.classcriteria;

import java.util.Collection;
import org.apache.openjpa.jdbc.persistence.classcriteria.Artist;
import org.apache.openjpa.jdbc.persistence.classcriteria.Book;
import org.apache.openjpa.jdbc.persistence.classcriteria.Item;
import org.apache.openjpa.jdbc.persistence.classcriteria.Movie;
import org.apache.openjpa.persistence.OpenJPAEntityManager;
import org.apache.openjpa.persistence.test.SingleEMFTestCase;

public class TestQuerySubclass
extends SingleEMFTestCase {
    private OpenJPAEntityManager em;

    public void setUp() {
        this.setUp("openjpa.Compatibility", "superclassDiscriminatorStrategyByDefault=true", CLEAR_TABLES, Artist.class, Book.class, Item.class, Movie.class);
        this.em = this.emf.createEntityManager();
        this.em.getTransaction().begin();
        Book b = new Book("book");
        Movie m = new Movie("movie");
        Artist a = new Artist("Herman Hess");
        b.setArtist(a);
        m.setArtist(a);
        this.em.persist((Object)a);
        this.em.persist((Object)b);
        this.em.persist((Object)m);
        this.em.getTransaction().commit();
    }

    public void testQuery() {
        Collection<Book> books = null;
        Collection<Movie> movies = null;
        this.em = this.emf.createEntityManager();
        Artist artist = (Artist)this.em.find(Artist.class, (Object)"Herman Hess");
        if (artist == null) {
            System.out.println("No artist found with ID Herman Hess");
        } else {
            books = artist.getBooks();
            movies = artist.getMovies();
        }
        TestQuerySubclass.assertEquals((int)1, (int)books.size());
        TestQuerySubclass.assertEquals((int)1, (int)movies.size());
    }

    public void tearDown() throws Exception {
    }
}

