/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.jdbc.persistence.classcriteria;

import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.DiscriminatorValue;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ManyToOne;
import org.apache.openjpa.jdbc.persistence.classcriteria.Artist;
import org.apache.openjpa.jdbc.persistence.classcriteria.Item;

@Entity
@DiscriminatorValue(value="MOVIE")
public class Movie
extends Item {
    private static final long serialVersionUID = 5263476520279196994L;
    @Column(name="DURATION")
    private Integer duration;
    @ManyToOne(cascade={CascadeType.ALL}, fetch=FetchType.EAGER)
    @Column(name="ARTIST")
    private Artist artist;

    public Movie() {
    }

    public Movie(String title) {
        super(title);
    }

    public Integer getDuration() {
        return this.duration;
    }

    public void setDuration(int d) {
        if (d < 0) {
            throw new IllegalArgumentException("Invalid duration " + d + " for " + this);
        }
        this.duration = d;
    }

    public Artist getArtist() {
        return this.artist;
    }

    public void setArtist(Artist artist) {
        this.artist = artist;
    }
}

