/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.jdbc.persistence.classcriteria;

import java.io.Serializable;
import javax.persistence.Column;
import javax.persistence.DiscriminatorColumn;
import javax.persistence.DiscriminatorType;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.Table;
import javax.persistence.Transient;

@Entity
@Table(name="ITEMTABLE")
@Inheritance(strategy=InheritanceType.SINGLE_TABLE)
@DiscriminatorColumn(name="ITEM_TYPE", discriminatorType=DiscriminatorType.STRING, length=8)
public class Item
implements Serializable {
    private static final long serialVersionUID = 3375001494950016360L;
    @Id
    @GeneratedValue
    @Column(name="UID1")
    private int id;
    @Column
    private String title;
    @Transient
    private float rating;

    protected Item() {
    }

    public Item(String title) {
        this.title = title;
    }

    public int getId() {
        return this.id;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        if (title == null || title.trim().length() == 0) {
            throw new IllegalArgumentException("null or empty title not allowed");
        }
        this.title = title;
    }

    public float getRating() {
        return this.rating;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Item item = (Item)o;
        return this.id == item.id;
    }

    public int hashCode() {
        return this.id;
    }
}

