/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.jdbc.persistence.classcriteria;

import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.DiscriminatorValue;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ManyToOne;
import org.apache.openjpa.jdbc.persistence.classcriteria.Artist;
import org.apache.openjpa.jdbc.persistence.classcriteria.Item;

@Entity
@DiscriminatorValue(value="BOOK")
public class Book
extends Item {
    private static final long serialVersionUID = 7150584274453979159L;
    @Column(name="PAGE_COUNT")
    private int pageCount;
    @ManyToOne(cascade={CascadeType.ALL}, fetch=FetchType.EAGER)
    @Column(name="ARTIST")
    private Artist artist1;

    public Book() {
    }

    public Book(String title) {
        super(title);
    }

    public int getPageCount() {
        return this.pageCount;
    }

    public void setPageCount(int d) {
        if (d < 0) {
            throw new IllegalArgumentException("Invalid page count " + d + " for " + this);
        }
        this.pageCount = d;
    }

    public Artist getArtist() {
        return this.artist1;
    }

    public void setArtist(Artist artist1) {
        this.artist1 = artist1;
    }
}

