/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.jdbc.meta.strats;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.openjpa.jdbc.meta.strats.AbstractLobTest;
import org.apache.openjpa.jdbc.meta.strats.InputStreamLobEntity;
import org.apache.openjpa.jdbc.meta.strats.InputStreamWrapper;
import org.apache.openjpa.jdbc.meta.strats.LobEntity;
import org.apache.openjpa.jdbc.sql.PostgresDictionary;

public class TestInputStreamLob
extends AbstractLobTest {
    public void setUp() throws Exception {
        this.supportedDatabases.add(PostgresDictionary.class);
        super.setUp();
    }

    protected LobEntity newLobEntity(String s, int id) {
        InputStreamLobEntity isle = new InputStreamLobEntity();
        isle.setId(id);
        if (s != null) {
            isle.setStream(new ByteArrayInputStream(s.getBytes()));
        } else {
            isle.setStream(null);
        }
        return isle;
    }

    protected LobEntity newLobEntityForLoadContent(String s, int id) {
        InputStreamLobEntity isle = new InputStreamLobEntity();
        isle.setId(id);
        isle.setStream(new InputStreamWrapper(s));
        return isle;
    }

    protected Class getLobEntityClass() {
        return InputStreamLobEntity.class;
    }

    protected String getSelectQuery() {
        return "SELECT o FROM InputStreamLobEntity o";
    }

    protected String getStreamContentAsString(Object o) throws IOException {
        InputStream is = (InputStream)o;
        String content = "";
        byte[] bs = new byte[1024];
        int read = -1;
        while ((read = is.read(bs)) != -1) {
            content = content + new String(bs).substring(0, read);
        }
        return content;
    }

    protected void changeStream(LobEntity le, String s) {
        le.setStream(new ByteArrayInputStream(s.getBytes()));
    }
}

