/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.jdbc.meta.strats;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.persistence.Query;
import org.apache.commons.lang.StringUtils;
import org.apache.openjpa.conf.OpenJPAConfiguration;
import org.apache.openjpa.datacache.DataCachePCData;
import org.apache.openjpa.jdbc.meta.strats.LobEntity;
import org.apache.openjpa.jdbc.sql.DBDictionary;
import org.apache.openjpa.jdbc.sql.MySQLDictionary;
import org.apache.openjpa.jdbc.sql.OracleDictionary;
import org.apache.openjpa.jdbc.sql.SQLServerDictionary;
import org.apache.openjpa.meta.ClassMetaData;
import org.apache.openjpa.persistence.JPAFacadeHelper;
import org.apache.openjpa.persistence.OpenJPAEntityManagerSPI;
import org.apache.openjpa.persistence.test.SingleEMFTestCase;

public abstract class AbstractLobTest
extends SingleEMFTestCase {
    protected List<Class<? extends DBDictionary>> supportedDatabases = new ArrayList<Class>(Arrays.asList(MySQLDictionary.class, OracleDictionary.class, SQLServerDictionary.class));

    public void setUp() throws Exception {
        this.setSupportedDatabases(this.supportedDatabases.toArray(new Class[0]));
        if (this.isTestsDisabled()) {
            return;
        }
        super.setUp(this.getLobEntityClass(), CLEAR_TABLES, "openjpa.DataCache", "true", "openjpa.RemoteCommitProvider", "sjvm", "openjpa.ConnectionRetainMode", "transaction");
    }

    public void insert(LobEntity le) {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        em.getTransaction().begin();
        em.persist((Object)le);
        em.getTransaction().commit();
        em.close();
    }

    public void testInsert() {
        this.insert(this.newLobEntity(this.createLobData(), 1));
    }

    public void testInsertAndSelect() throws IOException {
        String s = this.createLobData();
        this.insert(this.newLobEntity(s, 1));
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        em.getTransaction().begin();
        Query query = em.createQuery(this.getSelectQuery());
        LobEntity entity = (LobEntity)query.getSingleResult();
        AbstractLobTest.assertNotNull((Object)entity.getStream());
        AbstractLobTest.assertEquals((String)s, (String)this.getStreamContentAsString(entity.getStream()));
        em.getTransaction().commit();
        em.close();
    }

    public void testInsertNull() {
        this.insert(this.newLobEntity(null, 1));
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        em.getTransaction().begin();
        LobEntity le = (LobEntity)em.find(this.getLobEntityClass(), (Object)1);
        AbstractLobTest.assertNull((Object)le.getStream());
        em.getTransaction().commit();
        em.close();
    }

    public void testUpdate() throws IOException {
        this.insert(this.newLobEntity(this.createLobData(), 1));
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        em.getTransaction().begin();
        LobEntity entity = (LobEntity)em.find(this.getLobEntityClass(), (Object)1);
        String string = this.createLobData2();
        this.changeStream(entity, string);
        em.getTransaction().commit();
        em.close();
        em = this.emf.createEntityManager();
        em.getTransaction().begin();
        entity = (LobEntity)em.find(this.getLobEntityClass(), (Object)1);
        AbstractLobTest.assertEquals((String)string, (String)this.getStreamContentAsString(entity.getStream()));
        em.getTransaction().commit();
        em.close();
    }

    public void testUpdateWithNull() {
        this.insert(this.newLobEntity(this.createLobData(), 1));
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        em.getTransaction().begin();
        LobEntity entity = (LobEntity)em.find(this.getLobEntityClass(), (Object)1);
        entity.setStream(null);
        em.getTransaction().commit();
        em.close();
        em = this.emf.createEntityManager();
        em.getTransaction().begin();
        entity = (LobEntity)em.find(this.getLobEntityClass(), (Object)1);
        AbstractLobTest.assertNull((Object)entity.getStream());
        em.getTransaction().commit();
        em.close();
    }

    public void testUpdateANullObjectWithoutNull() throws IOException {
        this.insert(this.newLobEntity(null, 1));
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        em.getTransaction().begin();
        LobEntity entity = (LobEntity)em.find(this.getLobEntityClass(), (Object)1);
        String string = this.createLobData2();
        this.changeStream(entity, string);
        em.getTransaction().commit();
        em.close();
        em = this.emf.createEntityManager();
        em.getTransaction().begin();
        entity = (LobEntity)em.find(this.getLobEntityClass(), (Object)1);
        AbstractLobTest.assertEquals((String)string, (String)this.getStreamContentAsString(entity.getStream()));
        em.getTransaction().commit();
        em.close();
    }

    public void testDelete() {
        this.insert(this.newLobEntity(this.createLobData(), 1));
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        em.getTransaction().begin();
        LobEntity entity = (LobEntity)em.find(this.getLobEntityClass(), (Object)1);
        em.remove((Object)entity);
        em.getTransaction().commit();
        em.close();
        em = this.emf.createEntityManager();
        em.getTransaction().begin();
        Query q = em.createQuery(this.getSelectQuery());
        AbstractLobTest.assertEquals((int)0, (int)q.getResultList().size());
        em.getTransaction().commit();
        em.close();
    }

    public void testLifeCycleInsertFlushModify() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        em.getTransaction().begin();
        LobEntity le = this.newLobEntity(this.createLobData(), 1);
        em.persist((Object)le);
        em.flush();
        this.changeStream(le, this.createLobData2());
        em.getTransaction().commit();
        em.close();
    }

    public void testLifeCycleLoadFlushModifyFlush() {
        this.insert(this.newLobEntity(this.createLobData(), 1));
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        em.getTransaction().begin();
        LobEntity entity = (LobEntity)em.find(this.getLobEntityClass(), (Object)1);
        em.flush();
        this.changeStream(entity, this.createLobData2());
        em.flush();
        em.getTransaction().commit();
        em.close();
    }

    public void testReadingMultipleTimesWithASingleConnection() throws IOException {
        this.insert(this.newLobEntity(this.createLobData(), 1));
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        em.getTransaction().begin();
        LobEntity le = (LobEntity)em.find(this.getLobEntityClass(), (Object)1);
        String string = this.createLobData2();
        this.changeStream(le, string);
        em.getTransaction().commit();
        em.close();
        em = this.emf.createEntityManager();
        em.getTransaction().begin();
        le = (LobEntity)em.find(this.getLobEntityClass(), (Object)1);
        AbstractLobTest.assertNotNull((Object)le.getStream());
        LobEntity entity = this.newLobEntity(this.createLobData(), 2);
        em.persist((Object)entity);
        AbstractLobTest.assertEquals((String)string, (String)this.getStreamContentAsString(le.getStream()));
        em.getTransaction().commit();
        em.close();
    }

    public void testDataCache() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        em.getTransaction().begin();
        LobEntity le = this.newLobEntity(this.createLobData(), 1);
        em.persist((Object)le);
        em.getTransaction().commit();
        OpenJPAConfiguration conf = this.emf.getConfiguration();
        Object o = em.getObjectId((Object)le);
        ClassMetaData meta = JPAFacadeHelper.getMetaData((Object)le);
        Object objectId = JPAFacadeHelper.toOpenJPAObjectId((ClassMetaData)meta, (Object)o);
        DataCachePCData pcd = conf.getDataCacheManagerInstance().getSystemDataCache().get(objectId);
        AbstractLobTest.assertFalse((boolean)pcd.isLoaded(meta.getField("stream").getIndex()));
        em.close();
    }

    public void testSetResetAndFlush() throws IOException {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        em.getTransaction().begin();
        LobEntity le = this.newLobEntity(this.createLobData(), 1);
        em.persist((Object)le);
        String string = this.createLobData2();
        this.changeStream(le, string);
        em.flush();
        em.getTransaction().commit();
        em.close();
        em = this.emf.createEntityManager();
        em.getTransaction().begin();
        LobEntity entity = (LobEntity)em.find(this.getLobEntityClass(), (Object)1);
        AbstractLobTest.assertEquals((String)string, (String)this.getStreamContentAsString(entity.getStream()));
        em.getTransaction().commit();
        em.close();
    }

    public void testSetFlushAndReset() throws IOException {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        em.getTransaction().begin();
        LobEntity le = this.newLobEntity(this.createLobData(), 1);
        em.persist((Object)le);
        em.flush();
        String string = this.createLobData2();
        this.changeStream(le, string);
        LobEntity entity = (LobEntity)em.find(this.getLobEntityClass(), (Object)1);
        AbstractLobTest.assertEquals((String)string, (String)this.getStreamContentAsString(entity.getStream()));
        em.getTransaction().commit();
        em.close();
    }

    protected String createLobData() {
        return StringUtils.repeat((String)"ooOOOOoo, ", (int)3000);
    }

    protected String createLobData2() {
        return StringUtils.repeat((String)"iiIIIIii, ", (int)1000);
    }

    protected abstract Class getLobEntityClass();

    protected abstract String getStreamContentAsString(Object var1) throws IOException;

    protected abstract LobEntity newLobEntity(String var1, int var2);

    protected abstract LobEntity newLobEntityForLoadContent(String var1, int var2);

    protected abstract String getSelectQuery();

    protected abstract void changeStream(LobEntity var1, String var2);
}

