/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.jdbc.meta;

import java.io.IOException;
import java.sql.SQLException;
import java.util.HashMap;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Persistence;
import junit.framework.TestCase;
import org.apache.openjpa.jdbc.conf.JDBCConfiguration;
import org.apache.openjpa.jdbc.meta.MappingTool;
import org.apache.openjpa.persistence.OpenJPAEntityManagerFactorySPI;
import org.apache.openjpa.persistence.OpenJPAEntityManagerSPI;
import org.apache.openjpa.persistence.OpenJPAPersistence;
import org.apache.openjpa.persistence.simple.AllFieldTypes;

public class TestMappingToolAutoDelete
extends TestCase {
    private JDBCConfiguration _conf;
    private OpenJPAEntityManagerFactorySPI emf;

    public void setUp() {
        HashMap<Object, Object> props = new HashMap<Object, Object>(System.getProperties());
        props.put("openjpa.MetaDataFactory", "jpa(Types=" + AllFieldTypes.class.getName() + ")");
        this.emf = (OpenJPAEntityManagerFactorySPI)OpenJPAPersistence.cast((EntityManagerFactory)Persistence.createEntityManagerFactory((String)"test", props));
        this._conf = (JDBCConfiguration)this.emf.getConfiguration();
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        em.getTransaction().begin();
        em.persist((Object)new AllFieldTypes());
        em.getTransaction().commit();
        em.close();
    }

    public void tearDown() {
        this.emf.close();
    }

    public void testMappingToolAutoDelete() throws IOException, SQLException {
        MappingTool.Flags flags = new MappingTool.Flags();
        flags.schemaAction = "add,deleteTableContents";
        MappingTool.run((JDBCConfiguration)this._conf, (String[])new String[0], (MappingTool.Flags)flags, null);
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        TestMappingToolAutoDelete.assertEquals((Object)0L, (Object)em.createQuery("select count(o) from AllFieldTypes o").getSingleResult());
        em.close();
    }
}

