/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.jdbc.kernel;

import java.util.Collection;
import java.util.Iterator;
import org.apache.openjpa.jdbc.kernel.M2MBiDepartment;
import org.apache.openjpa.jdbc.kernel.M2MBiEmployee;
import org.apache.openjpa.persistence.OpenJPAEntityManagerSPI;
import org.apache.openjpa.persistence.test.SingleEMFTestCase;

public class TestM2MBiVersion
extends SingleEMFTestCase {
    public static String SALESID = "SALES";
    public static String MARKETINGID = "MARKETING";
    public static String EMPLOYEE1ID = "EMPLOYEE1";
    public static String EMPLOYEE2ID = "EMPLOYEE2";
    public static String EMPLOYEE3ID = "EMPLOYEE3";

    public void setUp() {
        this.setUp(M2MBiDepartment.class, M2MBiEmployee.class, CLEAR_TABLES);
        this.createEntities();
    }

    void createEntities() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        em.getTransaction().begin();
        M2MBiDepartment sales = new M2MBiDepartment();
        sales.setDeptid(SALESID);
        sales.setName("SALES");
        sales.setCostCode("1000");
        M2MBiDepartment marketing = new M2MBiDepartment();
        marketing.setDeptid(MARKETINGID);
        marketing.setName("marketing");
        marketing.setCostCode("3000");
        M2MBiEmployee e1 = new M2MBiEmployee();
        M2MBiEmployee e2 = new M2MBiEmployee();
        e1.setEmpid(EMPLOYEE1ID);
        e1.setName("Gilgamesh_1");
        e2.setEmpid(EMPLOYEE2ID);
        e2.setName("Enkidu_1");
        e1.getDepartments().add(sales);
        e2.getDepartments().add(sales);
        sales.getEmployees().add(e1);
        sales.getEmployees().add(e2);
        em.persist((Object)e1);
        em.persist((Object)e2);
        em.persist((Object)sales);
        em.persist((Object)marketing);
        em.flush();
        em.getTransaction().commit();
        em.close();
    }

    public void testNonRelationalFieldInverseSideVersionUpdate() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        M2MBiDepartment sales = (M2MBiDepartment)em.find(M2MBiDepartment.class, (Object)SALESID);
        M2MBiEmployee e1 = (M2MBiEmployee)em.find(M2MBiEmployee.class, (Object)EMPLOYEE1ID);
        M2MBiEmployee e2 = (M2MBiEmployee)em.find(M2MBiEmployee.class, (Object)EMPLOYEE2ID);
        int salesVersionPre = sales.getVersion();
        int e1VersionPre = e1.getVersion();
        int e2VersionPre = e2.getVersion();
        em.getTransaction().begin();
        sales.setCostCode("1001");
        em.getTransaction().commit();
        em.close();
        em = this.emf.createEntityManager();
        sales = (M2MBiDepartment)em.find(M2MBiDepartment.class, (Object)SALESID);
        e1 = (M2MBiEmployee)em.find(M2MBiEmployee.class, (Object)EMPLOYEE1ID);
        e2 = (M2MBiEmployee)em.find(M2MBiEmployee.class, (Object)EMPLOYEE2ID);
        int salesVersionPost = sales.getVersion();
        int e1VersionPost = e1.getVersion();
        int e2VersionPost = e2.getVersion();
        em.close();
        TestM2MBiVersion.assertEquals((int)salesVersionPost, (int)(salesVersionPre + 1));
        TestM2MBiVersion.assertEquals((int)e1VersionPost, (int)e1VersionPre);
        TestM2MBiVersion.assertEquals((int)e2VersionPost, (int)e2VersionPre);
    }

    public void testNonRelationalFieldOwnerSideVersionUpdate() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        M2MBiDepartment sales = (M2MBiDepartment)em.find(M2MBiDepartment.class, (Object)SALESID);
        M2MBiEmployee e1 = (M2MBiEmployee)em.find(M2MBiEmployee.class, (Object)EMPLOYEE1ID);
        M2MBiEmployee e2 = (M2MBiEmployee)em.find(M2MBiEmployee.class, (Object)EMPLOYEE2ID);
        int salesVersionPre = sales.getVersion();
        int e1VersionPre = e1.getVersion();
        int e2VersionPre = e2.getVersion();
        em.getTransaction().begin();
        e1.setName("Gilgamesh_2");
        e2.setName("Enkidu_2");
        em.getTransaction().commit();
        em.close();
        em = this.emf.createEntityManager();
        sales = (M2MBiDepartment)em.find(M2MBiDepartment.class, (Object)SALESID);
        e1 = (M2MBiEmployee)em.find(M2MBiEmployee.class, (Object)EMPLOYEE1ID);
        e2 = (M2MBiEmployee)em.find(M2MBiEmployee.class, (Object)EMPLOYEE2ID);
        int salesVersionPost = sales.getVersion();
        int e1VersionPost = e1.getVersion();
        int e2VersionPost = e2.getVersion();
        em.close();
        TestM2MBiVersion.assertEquals((int)salesVersionPost, (int)salesVersionPre);
        TestM2MBiVersion.assertEquals((int)e1VersionPost, (int)(e1VersionPre + 1));
        TestM2MBiVersion.assertEquals((int)e2VersionPost, (int)(e2VersionPre + 1));
    }

    public void testRelationalFieldBothSidesVersionUpdate() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        M2MBiDepartment sales = (M2MBiDepartment)em.find(M2MBiDepartment.class, (Object)SALESID);
        M2MBiDepartment marketing = (M2MBiDepartment)em.find(M2MBiDepartment.class, (Object)MARKETINGID);
        M2MBiEmployee e1 = (M2MBiEmployee)em.find(M2MBiEmployee.class, (Object)EMPLOYEE1ID);
        M2MBiEmployee e2 = (M2MBiEmployee)em.find(M2MBiEmployee.class, (Object)EMPLOYEE2ID);
        int salesVersionPre = sales.getVersion();
        int marketingVersionPre = marketing.getVersion();
        int e1VersionPre = e1.getVersion();
        int e2VersionPre = e2.getVersion();
        em.getTransaction().begin();
        Collection<M2MBiDepartment> e1Departments = e1.getDepartments();
        Iterator<M2MBiDepartment> dIterator = e1Departments.iterator();
        while (dIterator.hasNext()) {
            M2MBiDepartment d = dIterator.next();
            if (!SALESID.equals(d.getDeptid())) continue;
            dIterator.remove();
            break;
        }
        Collection<M2MBiEmployee> salesEmployees = sales.getEmployees();
        Iterator<M2MBiEmployee> eIterator = salesEmployees.iterator();
        while (eIterator.hasNext()) {
            M2MBiEmployee e = eIterator.next();
            if (!EMPLOYEE1ID.equals(e.getEmpid())) continue;
            eIterator.remove();
            break;
        }
        e1.getDepartments().add(marketing);
        marketing.getEmployees().add(e1);
        em.getTransaction().commit();
        em.close();
        em = this.emf.createEntityManager();
        sales = (M2MBiDepartment)em.find(M2MBiDepartment.class, (Object)SALESID);
        marketing = (M2MBiDepartment)em.find(M2MBiDepartment.class, (Object)MARKETINGID);
        e1 = (M2MBiEmployee)em.find(M2MBiEmployee.class, (Object)EMPLOYEE1ID);
        e2 = (M2MBiEmployee)em.find(M2MBiEmployee.class, (Object)EMPLOYEE2ID);
        int salesVersionPost = sales.getVersion();
        int marketingVersionPost = marketing.getVersion();
        int e1VersionPost = e1.getVersion();
        int e2VersionPost = e2.getVersion();
        em.close();
        TestM2MBiVersion.assertEquals((int)salesVersionPost, (int)salesVersionPre);
        TestM2MBiVersion.assertEquals((int)marketingVersionPost, (int)marketingVersionPre);
        TestM2MBiVersion.assertEquals((int)e1VersionPost, (int)(e1VersionPre + 1));
        TestM2MBiVersion.assertEquals((int)e2VersionPost, (int)e2VersionPre);
    }
}

