/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.jdbc.kernel;

import org.apache.openjpa.jdbc.kernel.M21UniDepartment;
import org.apache.openjpa.jdbc.kernel.M21UniEmployee;
import org.apache.openjpa.persistence.OpenJPAEntityManagerSPI;
import org.apache.openjpa.persistence.test.SingleEMFTestCase;

public class TestM21UniVersion
extends SingleEMFTestCase {
    public static String SALESID = "SALES";
    public static String MARKETINGID = "MARKETING";
    public static String EMPLOYEE1ID = "EMPLOYEE1";
    public static String EMPLOYEE2ID = "EMPLOYEE2";
    public static String EMPLOYEE3ID = "EMPLOYEE3";

    public void setUp() {
        this.setUp(M21UniDepartment.class, M21UniEmployee.class, CLEAR_TABLES);
        this.createEntities();
    }

    void createEntities() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        em.getTransaction().begin();
        M21UniDepartment sales = new M21UniDepartment();
        sales.setDeptid(SALESID);
        sales.setName("SALES");
        sales.setCostCode("1000");
        M21UniDepartment marketing = new M21UniDepartment();
        marketing.setDeptid(MARKETINGID);
        marketing.setName("marketing");
        marketing.setCostCode("3000");
        M21UniEmployee e1 = new M21UniEmployee();
        M21UniEmployee e2 = new M21UniEmployee();
        e1.setEmpid(EMPLOYEE1ID);
        e1.setName("Gilgamesh_1");
        e2.setEmpid(EMPLOYEE2ID);
        e2.setName("Enkidu_1");
        e1.setDepartment(sales);
        e2.setDepartment(sales);
        em.persist((Object)e1);
        em.persist((Object)e2);
        em.persist((Object)sales);
        em.persist((Object)marketing);
        em.flush();
        em.getTransaction().commit();
        em.close();
    }

    public void testNonRelationalFieldInverseSideVersionUpdate() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        M21UniDepartment sales = (M21UniDepartment)em.find(M21UniDepartment.class, (Object)SALESID);
        M21UniEmployee e1 = (M21UniEmployee)em.find(M21UniEmployee.class, (Object)EMPLOYEE1ID);
        M21UniEmployee e2 = (M21UniEmployee)em.find(M21UniEmployee.class, (Object)EMPLOYEE2ID);
        int salesVersionPre = sales.getVersion();
        int e1VersionPre = e1.getVersion();
        int e2VersionPre = e2.getVersion();
        em.getTransaction().begin();
        sales.setCostCode("1001");
        em.getTransaction().commit();
        em.close();
        em = this.emf.createEntityManager();
        sales = (M21UniDepartment)em.find(M21UniDepartment.class, (Object)SALESID);
        e1 = (M21UniEmployee)em.find(M21UniEmployee.class, (Object)EMPLOYEE1ID);
        e2 = (M21UniEmployee)em.find(M21UniEmployee.class, (Object)EMPLOYEE2ID);
        int salesVersionPost = sales.getVersion();
        int e1VersionPost = e1.getVersion();
        int e2VersionPost = e2.getVersion();
        em.close();
        TestM21UniVersion.assertEquals((int)salesVersionPost, (int)(salesVersionPre + 1));
        TestM21UniVersion.assertEquals((int)e1VersionPost, (int)e1VersionPre);
        TestM21UniVersion.assertEquals((int)e2VersionPost, (int)e2VersionPre);
    }

    public void testNonRelationalFieldOwnerSideVersionUpdate() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        M21UniDepartment sales = (M21UniDepartment)em.find(M21UniDepartment.class, (Object)SALESID);
        M21UniEmployee e1 = (M21UniEmployee)em.find(M21UniEmployee.class, (Object)EMPLOYEE1ID);
        M21UniEmployee e2 = (M21UniEmployee)em.find(M21UniEmployee.class, (Object)EMPLOYEE2ID);
        int salesVersionPre = sales.getVersion();
        int e1VersionPre = e1.getVersion();
        int e2VersionPre = e2.getVersion();
        em.getTransaction().begin();
        e1.setName("Gilgamesh_2");
        e2.setName("Enkidu_2");
        em.getTransaction().commit();
        em.close();
        em = this.emf.createEntityManager();
        sales = (M21UniDepartment)em.find(M21UniDepartment.class, (Object)SALESID);
        e1 = (M21UniEmployee)em.find(M21UniEmployee.class, (Object)EMPLOYEE1ID);
        e2 = (M21UniEmployee)em.find(M21UniEmployee.class, (Object)EMPLOYEE2ID);
        int salesVersionPost = sales.getVersion();
        int e1VersionPost = e1.getVersion();
        int e2VersionPost = e2.getVersion();
        em.close();
        TestM21UniVersion.assertEquals((int)salesVersionPost, (int)salesVersionPre);
        TestM21UniVersion.assertEquals((int)e1VersionPost, (int)(e1VersionPre + 1));
        TestM21UniVersion.assertEquals((int)e2VersionPost, (int)(e2VersionPre + 1));
    }

    public void testRelationalFieldOwnerSideVersionUpdate() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        M21UniDepartment sales = (M21UniDepartment)em.find(M21UniDepartment.class, (Object)SALESID);
        M21UniDepartment marketing = (M21UniDepartment)em.find(M21UniDepartment.class, (Object)MARKETINGID);
        M21UniEmployee e1 = (M21UniEmployee)em.find(M21UniEmployee.class, (Object)EMPLOYEE1ID);
        M21UniEmployee e2 = (M21UniEmployee)em.find(M21UniEmployee.class, (Object)EMPLOYEE2ID);
        int salesVersionPre = sales.getVersion();
        int marketingVersionPre = marketing.getVersion();
        int e1VersionPre = e1.getVersion();
        int e2VersionPre = e2.getVersion();
        em.getTransaction().begin();
        e1.setDepartment(marketing);
        em.getTransaction().commit();
        em.close();
        em = this.emf.createEntityManager();
        sales = (M21UniDepartment)em.find(M21UniDepartment.class, (Object)SALESID);
        marketing = (M21UniDepartment)em.find(M21UniDepartment.class, (Object)MARKETINGID);
        e1 = (M21UniEmployee)em.find(M21UniEmployee.class, (Object)EMPLOYEE1ID);
        e2 = (M21UniEmployee)em.find(M21UniEmployee.class, (Object)EMPLOYEE2ID);
        int salesVersionPost = sales.getVersion();
        int marketingVersionPost = marketing.getVersion();
        int e1VersionPost = e1.getVersion();
        int e2VersionPost = e2.getVersion();
        em.close();
        TestM21UniVersion.assertEquals((int)salesVersionPost, (int)salesVersionPre);
        TestM21UniVersion.assertEquals((int)marketingVersionPost, (int)marketingVersionPre);
        TestM21UniVersion.assertEquals((int)e1VersionPost, (int)(e1VersionPre + 1));
        TestM21UniVersion.assertEquals((int)e2VersionPost, (int)e2VersionPre);
    }
}

