/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.jdbc.kernel;

import java.util.ArrayList;
import org.apache.openjpa.jdbc.kernel.Employee;
import org.apache.openjpa.jdbc.kernel.Story;
import org.apache.openjpa.jdbc.kernel.Task;
import org.apache.openjpa.persistence.OpenJPAEntityManagerSPI;
import org.apache.openjpa.persistence.test.SQLListenerTestCase;

public class TestInsertOrder
extends SQLListenerTestCase {
    private String empTableName;
    private String taskTableName;
    private String storyTableName;

    public void setUp() {
        this.setUp(Employee.class, Task.class, Story.class);
        this.empTableName = this.getMapping(Employee.class).getTable().getFullName();
        this.taskTableName = this.getMapping(Task.class).getTable().getFullName();
        this.storyTableName = this.getMapping(Story.class).getTable().getFullName();
    }

    public void testCascadePersist() {
        Employee e = this.newTree(10);
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        em.getTransaction().begin();
        em.persist((Object)e);
        em.getTransaction().commit();
        em.close();
        this.assertAllSQLInOrder("INSERT INTO " + this.empTableName + ".*", "INSERT INTO " + this.taskTableName + ".*", "INSERT INTO " + this.storyTableName + ".*");
    }

    public void testCascadeMerge() {
        Employee e = this.newTree(11);
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        em.getTransaction().begin();
        em.merge((Object)e);
        em.getTransaction().commit();
        em.close();
        this.assertAllSQLInOrder("INSERT INTO " + this.empTableName + ".*", "INSERT INTO " + this.taskTableName + ".*", "INSERT INTO " + this.storyTableName + ".*");
    }

    private Employee newTree(int id) {
        Employee e = new Employee();
        e.setId(id);
        Task t = new Task();
        t.setId(id);
        Story s = new Story();
        s.setId(id);
        ArrayList<Task> tasks = new ArrayList<Task>();
        tasks.add(t);
        ArrayList<Story> stories = new ArrayList<Story>();
        stories.add(s);
        e.setTasks(tasks);
        t.setEmployee(e);
        t.setStories(stories);
        s.setTask(t);
        return e;
    }
}

