/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.jdbc.kernel;

import java.util.Iterator;
import java.util.Map;
import javax.persistence.Query;
import org.apache.openjpa.jdbc.conf.JDBCConfiguration;
import org.apache.openjpa.jdbc.kernel.A;
import org.apache.openjpa.persistence.OpenJPAEntityManagerSPI;
import org.apache.openjpa.persistence.test.SingleEMFTestCase;

public class TestCollectionTracking
extends SingleEMFTestCase {
    private JDBCConfiguration _conf;

    public void setUp() {
        super.setUp(A.class, "openjpa.Compatibility", "autoOff=false");
    }

    public void testCollectTracking() {
        int initialValue = 10;
        int changedAge = 40;
        String changedName = "changed Name";
        int incrementValue = 3;
        this.modifyA(initialValue, incrementValue, changedAge, changedName);
        this.assertA(initialValue, incrementValue, changedAge, changedName);
        incrementValue = 8;
        this.modifyA(initialValue, incrementValue, changedAge, changedName);
        this.assertA(initialValue, incrementValue, changedAge, changedName);
    }

    private void assertA(int initialValue, int incrementValue, int changedAge, String changedName) {
        OpenJPAEntityManagerSPI em3 = this.emf.createEntityManager();
        Query query3 = em3.createQuery("select emp from A as emp where emp.id = :id").setParameter("id", (Object)1);
        A changedA = (A)query3.getSingleResult();
        TestCollectionTracking.assertEquals((int)changedAge, (int)changedA.getAge());
        TestCollectionTracking.assertEquals((String)changedName, (String)changedA.getName());
        TestCollectionTracking.assertEquals((int)(initialValue + incrementValue), (int)changedA.getMap().size());
        em3.close();
    }

    private void modifyA(int initialvalue, int num, int changedAge, String changedName) {
        int i;
        this.clearTables();
        OpenJPAEntityManagerSPI em1 = this.emf.createEntityManager();
        OpenJPAEntityManagerSPI em2 = this.emf.createEntityManager();
        em1.getTransaction().begin();
        A newA = new A();
        newA.setId(1);
        newA.setAge(30);
        newA.setName("Initial");
        for (int i2 = 0; i2 < initialvalue; ++i2) {
            newA.getMap().put("key:" + i2, "value:" + i2);
        }
        em1.persist((Object)newA);
        em1.getTransaction().commit();
        em1.getTransaction().begin();
        em1.merge((Object)newA);
        newA.setAge(changedAge);
        Iterator<Map.Entry<String, String>> it = newA.getMap().entrySet().iterator();
        for (i = 0; i < num; ++i) {
            it.next();
            it.remove();
        }
        for (i = initialvalue; i < initialvalue + num; ++i) {
            newA.getMap().put("key:" + i, "value:" + i);
        }
        em2.getTransaction().begin();
        Query query2 = em2.createQuery("select emp from A as emp where emp.id = :id").setParameter("id", (Object)1);
        A result2 = (A)query2.getSingleResult();
        result2.setName(changedName);
        for (int i3 = initialvalue + num; i3 < initialvalue + num + num; ++i3) {
            result2.getMap().put("key:" + i3, "value:" + i3);
        }
        em2.getTransaction().commit();
        em1.getTransaction().commit();
        em2.close();
        em1.close();
    }

    private void clearTables() {
        OpenJPAEntityManagerSPI em1 = this.emf.createEntityManager();
        em1.getTransaction().begin();
        Query query = em1.createNativeQuery("delete from JPA_A");
        query.executeUpdate();
        query = em1.createNativeQuery("delete from JPA_A_MAPS_C");
        query.executeUpdate();
        em1.getTransaction().commit();
        em1.close();
    }

    public void tearDown() throws Exception {
    }
}

