/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.enhance;

import java.lang.reflect.Proxy;
import java.util.Collection;
import org.apache.openjpa.enhance.PersistenceCapable;
import org.apache.openjpa.enhance.UnenhancedMany;
import org.apache.openjpa.enhance.UnenhancedOne;
import org.apache.openjpa.persistence.test.SingleEMTestCase;

public class TestUnenhancedOneToMany
extends SingleEMTestCase {
    public void setUp() {
        this.setUp(UnenhancedOne.class, UnenhancedMany.class, CLEAR_TABLES);
    }

    public void testOneToMany() throws Exception {
        TestUnenhancedOneToMany.assertFalse((boolean)PersistenceCapable.class.isAssignableFrom(UnenhancedOne.class));
        TestUnenhancedOneToMany.assertFalse((boolean)PersistenceCapable.class.isAssignableFrom(UnenhancedMany.class));
        this.em.getTransaction().begin();
        UnenhancedOne one = new UnenhancedOne(1000);
        UnenhancedMany manyA = new UnenhancedMany(1);
        one.getMany().add(manyA);
        manyA.setOne(one);
        UnenhancedMany manyB = new UnenhancedMany(2);
        one.getMany().add(manyB);
        manyB.setOne(one);
        UnenhancedMany manyC = new UnenhancedMany(3);
        one.getMany().add(manyC);
        manyC.setOne(one);
        TestUnenhancedOneToMany.assertFalse((boolean)this.em.contains((Object)one));
        TestUnenhancedOneToMany.assertFalse((boolean)this.em.contains((Object)manyA));
        TestUnenhancedOneToMany.assertFalse((boolean)this.em.contains((Object)manyB));
        TestUnenhancedOneToMany.assertFalse((boolean)this.em.contains((Object)manyC));
        this.em.persist((Object)one);
        this.em.persist((Object)manyA);
        this.em.persist((Object)manyB);
        this.em.persist((Object)manyC);
        this.em.flush();
        TestUnenhancedOneToMany.assertTrue((boolean)this.em.contains((Object)one));
        TestUnenhancedOneToMany.assertTrue((boolean)this.em.contains((Object)manyA));
        TestUnenhancedOneToMany.assertTrue((boolean)this.em.contains((Object)manyB));
        TestUnenhancedOneToMany.assertTrue((boolean)this.em.contains((Object)manyC));
        this.em.getTransaction().commit();
        one = null;
        manyA = null;
        manyB = null;
        manyC = null;
        this.em.close();
        this.em = this.emf.createEntityManager();
        this.em.getTransaction().begin();
        one = (UnenhancedOne)this.em.find(UnenhancedOne.class, (Object)1000);
        TestUnenhancedOneToMany.assertNotNull((String)"one is null", (Object)one);
        TestUnenhancedOneToMany.assertTrue((boolean)Proxy.isProxyClass(one.many.getClass()));
        TestUnenhancedOneToMany.assertNotNull((String)"one.getMany() is null", one.getMany());
        Collection<UnenhancedMany> many = one.getMany();
        TestUnenhancedOneToMany.assertEquals((int)3, (int)many.size());
        manyA = (UnenhancedMany)this.em.find(UnenhancedMany.class, (Object)1);
        TestUnenhancedOneToMany.assertNotNull((String)"manyA is null", (Object)manyA);
        manyB = (UnenhancedMany)this.em.find(UnenhancedMany.class, (Object)2);
        TestUnenhancedOneToMany.assertNotNull((String)"manyB is null", (Object)manyA);
        manyC = (UnenhancedMany)this.em.find(UnenhancedMany.class, (Object)3);
        TestUnenhancedOneToMany.assertNotNull((String)"manyc is null", (Object)manyA);
        TestUnenhancedOneToMany.assertNotNull((String)"manyA.getOne() is null", (Object)manyA.getOne());
        TestUnenhancedOneToMany.assertEquals((Object)one, (Object)manyA.getOne());
        TestUnenhancedOneToMany.assertNotNull((String)"manyB.getOne() is null", (Object)manyB.getOne());
        TestUnenhancedOneToMany.assertEquals((Object)one, (Object)manyB.getOne());
        TestUnenhancedOneToMany.assertNotNull((String)"manyC.getOne() is null", (Object)manyC.getOne());
        TestUnenhancedOneToMany.assertEquals((Object)one, (Object)manyC.getOne());
        TestUnenhancedOneToMany.assertTrue((boolean)many.contains(manyA));
        TestUnenhancedOneToMany.assertTrue((boolean)many.contains(manyB));
        TestUnenhancedOneToMany.assertTrue((boolean)many.contains(manyC));
        this.em.getTransaction().commit();
    }
}

