/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.enhance;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.Field;
import java.util.Collections;
import java.util.List;
import javax.persistence.EntityManagerFactory;
import org.apache.openjpa.conf.OpenJPAConfiguration;
import org.apache.openjpa.enhance.ClassRedefiner;
import org.apache.openjpa.enhance.ManagedClassSubclasser;
import org.apache.openjpa.enhance.PCEnhancer;
import org.apache.openjpa.enhance.PCRegistry;
import org.apache.openjpa.enhance.PersistenceCapable;
import org.apache.openjpa.enhance.UnenhancedSubtype;
import org.apache.openjpa.enhance.UnenhancedType;
import org.apache.openjpa.event.AbstractLifecycleListener;
import org.apache.openjpa.event.LifecycleEvent;
import org.apache.openjpa.kernel.OpenJPAStateManager;
import org.apache.openjpa.lib.log.Log;
import org.apache.openjpa.meta.AccessCode;
import org.apache.openjpa.meta.ClassMetaData;
import org.apache.openjpa.persistence.JPAFacadeHelper;
import org.apache.openjpa.persistence.OpenJPAEntityManager;
import org.apache.openjpa.persistence.OpenJPAEntityManagerSPI;
import org.apache.openjpa.persistence.test.SingleEMFTestCase;
import org.apache.openjpa.util.ImplHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractUnenhancedClassTest
extends SingleEMFTestCase {
    Log _log;

    @Override
    public void setUp() {
        this.setUp(this.getUnenhancedClass(), this.getUnenhancedSubclass(), CLEAR_TABLES);
        this.emf.createEntityManager().close();
        this._log = this.emf.getConfiguration().getLog("openjpa.Enhance");
    }

    protected abstract Class<? extends UnenhancedType> getUnenhancedClass();

    protected abstract UnenhancedType newUnenhancedInstance();

    protected abstract Class<? extends UnenhancedSubtype> getUnenhancedSubclass();

    protected abstract UnenhancedSubtype newUnenhancedSubclassInstance();

    private UnenhancedType newInstance(boolean sub) {
        return sub ? this.newUnenhancedSubclassInstance() : this.newUnenhancedInstance();
    }

    public void testMetaData() {
        ClassMetaData meta = JPAFacadeHelper.getMetaData((EntityManagerFactory)this.emf, this.getUnenhancedClass());
        AbstractUnenhancedClassTest.assertEquals((boolean)ClassRedefiner.canRedefineClasses((Log)this._log), (boolean)meta.isIntercepting());
    }

    public void testImplHelperCalls() {
        AbstractUnenhancedClassTest.assertTrue((boolean)ImplHelper.isManagedType(null, this.getUnenhancedClass()));
        UnenhancedType un = this.newUnenhancedInstance();
        AbstractUnenhancedClassTest.assertFalse((boolean)(un instanceof PersistenceCapable));
        PersistenceCapable pc = ImplHelper.toPersistenceCapable((Object)un, (Object)this.emf.getConfiguration());
        AbstractUnenhancedClassTest.assertNotNull((Object)pc);
        AbstractUnenhancedClassTest.assertTrue((boolean)ImplHelper.isManageable((Object)un));
    }

    public void testBasicPersistenceCapableBehavior() {
        UnenhancedType un = this.newUnenhancedInstance();
        un.setStringField("bar");
        PersistenceCapable pc = ImplHelper.toPersistenceCapable((Object)un, (Object)this.emf.getConfiguration());
        AbstractUnenhancedClassTest.assertFalse((boolean)pc.pcIsDeleted());
        AbstractUnenhancedClassTest.assertFalse((boolean)pc.pcIsDirty());
        AbstractUnenhancedClassTest.assertFalse((boolean)pc.pcIsNew());
        AbstractUnenhancedClassTest.assertFalse((boolean)pc.pcIsPersistent());
        AbstractUnenhancedClassTest.assertFalse((boolean)pc.pcIsTransactional());
    }

    public void testPCRegistry() {
        AbstractUnenhancedClassTest.assertTrue((boolean)PCRegistry.isRegistered(this.getUnenhancedClass()));
        PersistenceCapable pc = PCRegistry.newInstance(this.getUnenhancedClass(), null, (boolean)false);
        AbstractUnenhancedClassTest.assertNotNull((Object)pc);
        AbstractUnenhancedClassTest.assertEquals(pc.getClass(), (Object)PCRegistry.getPCType(this.getUnenhancedClass()));
    }

    public void testClearingOnSubtypeInstance() {
        UnenhancedType un = (UnenhancedType)PCRegistry.newInstance(this.getUnenhancedClass(), null, (boolean)true);
        AbstractUnenhancedClassTest.assertEquals(null, (String)un.getStringField());
    }

    public void testGetObjectIdOnOpenJPAType() {
        this.getObjectIdHelper(true, false);
    }

    public void testGetObjectIdOnOpenJPATypeSubclass() {
        this.getObjectIdHelper(false, false);
    }

    public void testGetObjectIdOnUserDefined() {
        this.getObjectIdHelper(true, true);
    }

    public void testGetObjectIdOnUserDefinedSubclass() {
        this.getObjectIdHelper(false, true);
    }

    private void getObjectIdHelper(boolean sub, boolean userDefined) {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        em.getTransaction().begin();
        UnenhancedType un = this.newInstance(sub);
        em.persist((Object)un);
        em.getTransaction().commit();
        if (!userDefined) {
            em.close();
            em = this.emf.createEntityManager();
            un = (UnenhancedType)em.find(this.getUnenhancedClass(), (Object)un.getId());
        }
        AbstractUnenhancedClassTest.assertNotNull((Object)em.getObjectId((Object)un));
    }

    public void testOperationsOnUserDefined() {
        this.opsHelper(false, true);
    }

    public void testSubclassOperationsOnUserDefined() {
        this.opsHelper(true, true);
    }

    public void testOperationsOnOpenJPADefined() {
        this.opsHelper(false, false);
    }

    public void testSubclassOperationsOnOpenJPADefined() {
        this.opsHelper(true, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void opsHelper(boolean sub, boolean userDefined) {
        OpenJPAEntityManagerSPI em = null;
        try {
            UnenhancedType un = this.newInstance(sub);
            em = this.emf.createEntityManager();
            em.getTransaction().begin();
            em.persist((Object)un);
            un.setStringField("bar");
            AbstractUnenhancedClassTest.assertEquals((String)"bar", (String)un.getStringField());
            this.assertPersistenceContext((OpenJPAEntityManager)em, un, true, true, sub);
            em.flush();
            this.assertPersistenceContext((OpenJPAEntityManager)em, un, true, true, sub);
            AbstractUnenhancedClassTest.assertTrue((un.getId() != 0 ? 1 : 0) != 0);
            UnenhancedType un2 = (UnenhancedType)em.find(this.getUnenhancedClass(), (Object)un.getId());
            AbstractUnenhancedClassTest.assertSame((Object)un, (Object)un2);
            em.getTransaction().commit();
            this.assertPersistenceContext((OpenJPAEntityManager)em, un, false, false, sub);
            un2 = (UnenhancedType)em.find(this.getUnenhancedClass(), (Object)un.getId());
            AbstractUnenhancedClassTest.assertSame((Object)un, (Object)un2);
            if (!userDefined) {
                em.close();
                em = this.emf.createEntityManager();
            }
            un = (UnenhancedType)em.find(this.getUnenhancedClass(), (Object)un.getId());
            AbstractUnenhancedClassTest.assertNotNull((Object)un);
            if (!userDefined) {
                AbstractUnenhancedClassTest.assertTrue((boolean)(un instanceof PersistenceCapable));
            }
            AbstractUnenhancedClassTest.assertEquals((String)"bar", (String)un.getStringField());
            em.getTransaction().begin();
            un.setStringField("baz");
            this.assertPersistenceContext((OpenJPAEntityManager)em, un, true, true, sub);
            AbstractUnenhancedClassTest.assertEquals((String)"baz", (String)un.getStringField());
            if (sub) {
                ((UnenhancedSubtype)un).setIntField(17);
            }
            AbstractUnenhancedClassTest.assertTrue((boolean)em.isDirty((Object)un));
            em.getTransaction().commit();
            AbstractUnenhancedClassTest.assertEquals((String)"baz", (String)un.getStringField());
            em.close();
            em = this.emf.createEntityManager();
            un = (UnenhancedType)em.find(this.getUnenhancedClass(), (Object)un.getId());
            AbstractUnenhancedClassTest.assertNotNull((Object)un);
            AbstractUnenhancedClassTest.assertTrue((boolean)(un instanceof PersistenceCapable));
            AbstractUnenhancedClassTest.assertEquals((String)"baz", (String)un.getStringField());
            if (sub) {
                AbstractUnenhancedClassTest.assertEquals((int)17, (int)((UnenhancedSubtype)un).getIntField());
            }
            em.close();
        }
        finally {
            if (em != null && em.getTransaction().isActive()) {
                em.getTransaction().rollback();
            }
            if (em != null && em.isOpen()) {
                em.close();
            }
        }
    }

    private void assertPersistenceContext(OpenJPAEntityManager em, UnenhancedType un, boolean transactional, boolean dirty, boolean sub) {
        AbstractUnenhancedClassTest.assertEquals((boolean)transactional, (boolean)em.getTransactionalObjects().contains(un));
        AbstractUnenhancedClassTest.assertEquals((boolean)dirty, (boolean)em.getDirtyObjects().contains(un));
        if (dirty) {
            Class<UnenhancedType> cls = sub ? this.getUnenhancedSubclass() : this.getUnenhancedClass();
            AbstractUnenhancedClassTest.assertTrue((em.getUpdatedClasses().contains(cls) || em.getPersistedClasses().contains(cls) ? 1 : 0) != 0);
        }
    }

    public void testRelations() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        em.getTransaction().begin();
        UnenhancedSubtype un = this.newUnenhancedSubclassInstance();
        em.persist((Object)un);
        un.setStringField("aoeu");
        UnenhancedSubtype related = this.newUnenhancedSubclassInstance();
        un.setRelated(related);
        related.setStringField("snth");
        em.getTransaction().commit();
        em.close();
        em = this.emf.createEntityManager();
        un = (UnenhancedSubtype)em.find(this.getUnenhancedClass(), (Object)un.getId());
        AbstractUnenhancedClassTest.assertEquals((String)"aoeu", (String)un.getStringField());
        AbstractUnenhancedClassTest.assertNotNull((Object)un.getRelated());
        AbstractUnenhancedClassTest.assertEquals((String)"snth", (String)un.getRelated().getStringField());
        em.close();
    }

    public void testEnhancer() throws IOException {
        List subs = ManagedClassSubclasser.prepareUnenhancedClasses((OpenJPAConfiguration)this.emf.getConfiguration(), Collections.singleton(this.getUnenhancedClass()), null);
        Class sub = (Class)subs.get(0);
        AbstractUnenhancedClassTest.assertNotNull((Object)sub);
        AbstractUnenhancedClassTest.assertEquals((String)("org.apache.openjpa.enhance." + this.getUnenhancedClass().getName().replace('.', '$') + "$pcsubclass"), (String)sub.getName());
        AbstractUnenhancedClassTest.assertTrue((boolean)PersistenceCapable.class.isAssignableFrom(sub));
        AbstractUnenhancedClassTest.assertTrue((boolean)this.getUnenhancedClass().isAssignableFrom(sub));
    }

    public void testPCSubclassName() {
        AbstractUnenhancedClassTest.assertEquals((String)("org.apache.openjpa.enhance." + this.getUnenhancedClass().getName().replace('.', '$') + "$pcsubclass"), (String)PCEnhancer.toPCSubclassName(this.getUnenhancedClass()));
    }

    public void testEvictionInUserCreatedInstance() throws NoSuchFieldException, IllegalAccessException {
        this.evictionHelper(true);
    }

    public void testEvictionInOpenJPACreatedInstance() throws NoSuchFieldException, IllegalAccessException {
        this.evictionHelper(false);
    }

    private void evictionHelper(boolean userDefined) throws NoSuchFieldException, IllegalAccessException {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        UnenhancedType un = this.newUnenhancedInstance();
        em.getTransaction().begin();
        em.persist((Object)un);
        em.getTransaction().commit();
        if (!userDefined) {
            em.close();
            em = this.emf.createEntityManager();
            un = (UnenhancedType)em.find(this.getUnenhancedClass(), (Object)un.getId());
            AbstractUnenhancedClassTest.assertTrue((this.getUnenhancedClass() != un.getClass() ? 1 : 0) != 0);
        }
        em.evict((Object)un);
        OpenJPAStateManager sm = (OpenJPAStateManager)ImplHelper.toPersistenceCapable((Object)un, null).pcGetStateManager();
        if (ClassRedefiner.canRedefineClasses((Log)this._log) || !userDefined && AccessCode.isProperty((int)sm.getMetaData().getAccessType())) {
            AbstractUnenhancedClassTest.assertFalse((boolean)sm.getLoaded().get(sm.getMetaData().getField("stringField").getIndex()));
            Field field = this.getUnenhancedClass().getDeclaredField(this.isFieldAccessTest() ? "stringField" : "sf");
            field.setAccessible(true);
            AbstractUnenhancedClassTest.assertEquals(null, (Object)field.get(un));
            AbstractUnenhancedClassTest.assertEquals((String)"foo", (String)un.getStringField());
            AbstractUnenhancedClassTest.assertTrue((boolean)sm.getLoaded().get(sm.getMetaData().getField("stringField").getIndex()));
        } else {
            AbstractUnenhancedClassTest.assertTrue((boolean)sm.getLoaded().get(sm.getMetaData().getField("stringField").getIndex()));
            Field field = this.getUnenhancedClass().getDeclaredField(this.isFieldAccessTest() ? "stringField" : "sf");
            field.setAccessible(true);
            AbstractUnenhancedClassTest.assertEquals((Object)"foo", (Object)field.get(un));
        }
        em.close();
    }

    protected abstract boolean isFieldAccessTest();

    public void testLazyLoading() throws NoSuchFieldException, IllegalAccessException {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        UnenhancedType un = this.newUnenhancedInstance();
        em.getTransaction().begin();
        em.persist((Object)un);
        em.getTransaction().commit();
        em.close();
        em = this.emf.createEntityManager();
        un = (UnenhancedType)em.find(this.getUnenhancedClass(), (Object)un.getId());
        AbstractUnenhancedClassTest.assertTrue((this.getUnenhancedClass() != un.getClass() ? 1 : 0) != 0);
        OpenJPAStateManager sm = (OpenJPAStateManager)ImplHelper.toPersistenceCapable((Object)un, null).pcGetStateManager();
        if (ClassRedefiner.canRedefineClasses((Log)this._log) || AccessCode.isProperty((int)sm.getMetaData().getAccessType())) {
            AbstractUnenhancedClassTest.assertFalse((boolean)sm.getLoaded().get(sm.getMetaData().getField("lazyField").getIndex()));
            Field field = this.getUnenhancedClass().getDeclaredField("lazyField");
            field.setAccessible(true);
            AbstractUnenhancedClassTest.assertEquals(null, (Object)field.get(un));
        } else {
            AbstractUnenhancedClassTest.assertTrue((boolean)sm.getLoaded().get(sm.getMetaData().getField("lazyField").getIndex()));
            Field field = this.getUnenhancedClass().getDeclaredField("lazyField");
            field.setAccessible(true);
            AbstractUnenhancedClassTest.assertEquals((Object)"lazy", (Object)field.get(un));
        }
        AbstractUnenhancedClassTest.assertEquals((String)"lazy", (String)un.getLazyField());
        AbstractUnenhancedClassTest.assertTrue((boolean)sm.getLoaded().get(sm.getMetaData().getField("lazyField").getIndex()));
        em.close();
    }

    public void testSerializationOfUserDefinedInstance() throws IOException, ClassNotFoundException {
        this.serializationHelper(true, false);
    }

    public void testSerializationOfUserDefinedSubclassInstance() throws IOException, ClassNotFoundException {
        this.serializationHelper(true, true);
    }

    public void testSerializationOfOpenJPADefinedInstance() throws IOException, ClassNotFoundException {
        this.serializationHelper(false, false);
    }

    public void testSerializationOfOpenJPADefinedSubclassInstance() throws IOException, ClassNotFoundException {
        this.serializationHelper(false, true);
    }

    private void serializationHelper(boolean userDefined, boolean sub) throws IOException, ClassNotFoundException {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        UnenhancedType un = this.newInstance(sub);
        em.getTransaction().begin();
        em.persist((Object)un);
        if (sub) {
            UnenhancedType related = this.newInstance(false);
            related.setStringField("related");
            ((UnenhancedSubtype)un).setRelated(related);
        }
        em.getTransaction().commit();
        if (!userDefined) {
            em.close();
            em = this.emf.createEntityManager();
        }
        un = (UnenhancedType)em.find(this.getUnenhancedClass(), (Object)un.getId());
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        ObjectOutputStream oout = new ObjectOutputStream(out);
        oout.writeObject(un);
        oout.flush();
        byte[] bytes = out.toByteArray();
        ObjectInputStream oin = new ObjectInputStream(new ByteArrayInputStream(bytes));
        UnenhancedType deserialized = (UnenhancedType)oin.readObject();
        this.copiedInstanceHelper(sub, (OpenJPAEntityManager)em, un, deserialized, false);
        em.close();
    }

    public void testCloningOfUserDefinedInstance() throws IOException, ClassNotFoundException, CloneNotSupportedException {
        this.cloneHelper(true, false);
    }

    public void testCloningOfUserDefinedSubclassInstance() throws IOException, ClassNotFoundException, CloneNotSupportedException {
        this.cloneHelper(true, true);
    }

    public void testCloningOfOpenJPADefinedInstance() throws IOException, ClassNotFoundException, CloneNotSupportedException {
        this.cloneHelper(false, false);
    }

    public void testCloningOfOpenJPADefinedSubclassInstance() throws IOException, ClassNotFoundException, CloneNotSupportedException {
        this.cloneHelper(false, true);
    }

    private void cloneHelper(boolean userDefined, boolean sub) throws IOException, ClassNotFoundException, CloneNotSupportedException {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        UnenhancedType un = this.newInstance(sub);
        em.getTransaction().begin();
        em.persist((Object)un);
        if (sub) {
            UnenhancedType related = this.newInstance(false);
            related.setStringField("related");
            ((UnenhancedSubtype)un).setRelated(related);
        }
        em.getTransaction().commit();
        if (!userDefined) {
            em.close();
            em = this.emf.createEntityManager();
        }
        un = (UnenhancedType)em.find(this.getUnenhancedClass(), (Object)un.getId());
        UnenhancedType cloned = (UnenhancedType)un.clone();
        this.copiedInstanceHelper(sub, (OpenJPAEntityManager)em, un, cloned, true);
        em.close();
    }

    private void copiedInstanceHelper(boolean sub, OpenJPAEntityManager em, UnenhancedType un, UnenhancedType copy, boolean viaClone) {
        AbstractUnenhancedClassTest.assertNotSame((Object)un, (Object)copy);
        if (!viaClone) {
            AbstractUnenhancedClassTest.assertEquals(sub ? this.getUnenhancedSubclass() : this.getUnenhancedClass(), copy.getClass());
        }
        AbstractUnenhancedClassTest.assertEquals((int)un.getId(), (int)copy.getId());
        AbstractUnenhancedClassTest.assertEquals((String)un.getStringField(), (String)copy.getStringField());
        if (sub) {
            AbstractUnenhancedClassTest.assertEquals((int)((UnenhancedSubtype)un).getIntField(), (int)((UnenhancedSubtype)copy).getIntField());
            AbstractUnenhancedClassTest.assertNotSame((Object)((UnenhancedSubtype)un).getRelated(), (Object)((UnenhancedSubtype)copy).getRelated());
            AbstractUnenhancedClassTest.assertEquals((int)((UnenhancedSubtype)un).getRelated().getId(), (int)((UnenhancedSubtype)copy).getRelated().getId());
        }
        AbstractUnenhancedClassTest.assertFalse((boolean)em.isDetached((Object)un));
        AbstractUnenhancedClassTest.assertTrue((boolean)em.isDetached((Object)copy));
        copy.setStringField("offline update");
        em.getTransaction().begin();
        AbstractUnenhancedClassTest.assertSame((Object)un, (Object)em.merge((Object)copy));
        AbstractUnenhancedClassTest.assertTrue((boolean)em.isDirty((Object)un));
        AbstractUnenhancedClassTest.assertEquals((String)"offline update", (String)un.getStringField());
        em.getTransaction().commit();
    }

    public void testListenersOnUserDefinedInstance() throws IOException, ClassNotFoundException, CloneNotSupportedException {
        this.listenerHelper(true, false);
    }

    public void testListenersOnUserDefinedSubclassInstance() throws IOException, ClassNotFoundException, CloneNotSupportedException {
        this.listenerHelper(true, true);
    }

    public void testListenersOnOpenJPADefinedInstance() throws IOException, ClassNotFoundException, CloneNotSupportedException {
        this.listenerHelper(false, false);
    }

    public void testListenersOnOpenJPADefinedSubclassInstance() throws IOException, ClassNotFoundException, CloneNotSupportedException {
        this.listenerHelper(false, true);
    }

    private void listenerHelper(boolean userDefined, boolean sub) throws IOException, ClassNotFoundException, CloneNotSupportedException {
        ListenerImpl listener = new ListenerImpl();
        this.emf.addLifecycleListener((Object)listener, (Class[])null);
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        UnenhancedType un = this.newInstance(sub);
        em.getTransaction().begin();
        em.persist((Object)un);
        em.getTransaction().commit();
        if (!userDefined) {
            em.close();
            em = this.emf.createEntityManager();
        }
        listener.invoked = false;
        un = (UnenhancedType)em.find(this.getUnenhancedClass(), (Object)un.getId());
        em.getTransaction().begin();
        un.setStringField("updated");
        em.getTransaction().commit();
        AbstractUnenhancedClassTest.assertTrue((boolean)listener.invoked);
        em.close();
        AbstractUnenhancedClassTest.assertEquals((String)"updated", (String)listener.stringField);
    }

    public void testGetMetaDataOfSubtype() {
        ClassMetaData meta = JPAFacadeHelper.getMetaData((EntityManagerFactory)this.emf, this.getUnenhancedClass());
        List subs = ManagedClassSubclasser.prepareUnenhancedClasses((OpenJPAConfiguration)this.emf.getConfiguration(), Collections.singleton(this.getUnenhancedClass()), null);
        AbstractUnenhancedClassTest.assertSame((Object)meta, (Object)JPAFacadeHelper.getMetaData((EntityManagerFactory)this.emf, (Class)((Class)subs.get(0))));
        meta = JPAFacadeHelper.getMetaData((EntityManagerFactory)this.emf, this.getUnenhancedSubclass());
        subs = ManagedClassSubclasser.prepareUnenhancedClasses((OpenJPAConfiguration)this.emf.getConfiguration(), Collections.singleton(this.getUnenhancedSubclass()), null);
        AbstractUnenhancedClassTest.assertSame((Object)meta, (Object)JPAFacadeHelper.getMetaData((EntityManagerFactory)this.emf, (Class)((Class)subs.get(0))));
    }

    private class ListenerImpl
    extends AbstractLifecycleListener {
        String stringField;
        boolean invoked;

        private ListenerImpl() {
        }

        public void afterStore(LifecycleEvent event) {
            this.invoked = true;
            this.stringField = ((UnenhancedType)event.getSource()).getStringField();
        }
    }
}

