/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.conf;

import javax.persistence.PersistenceException;
import org.apache.openjpa.conf.Specification;
import org.apache.openjpa.persistence.OpenJPAEntityManagerFactorySPI;
import org.apache.openjpa.persistence.OpenJPAPersistence;
import org.apache.openjpa.persistence.test.SingleEMFTestCase;

public class TestSpecificationConfiguration
extends SingleEMFTestCase {
    public void testSpecificationIsSet() {
        Specification spec = this.getSpecifcation();
        TestSpecificationConfiguration.assertNotNull((Object)spec);
    }

    public void testSpecificationIsJPA() {
        Specification spec = this.getSpecifcation();
        TestSpecificationConfiguration.assertTrue((boolean)spec.isSame("JPA"));
        TestSpecificationConfiguration.assertTrue((boolean)spec.isSame("jpa"));
    }

    public void testSpecificationVersionIsJPA1() {
        Specification spec = this.getSpecifcation();
        int major = spec.getVersion();
        TestSpecificationConfiguration.assertEquals((int)1, (int)major);
        TestSpecificationConfiguration.assertTrue((boolean)spec.isSame("JPA"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSpecificationVersionIsJPA2() {
        OpenJPAEntityManagerFactorySPI emf1 = null;
        try {
            emf1 = (OpenJPAEntityManagerFactorySPI)OpenJPAPersistence.createEntityManagerFactory((String)"persistence2_0", (String)"org/apache/openjpa/conf/META-INF/persistence-2_0-config.xml");
            Specification spec = emf1.getConfiguration().getSpecificationInstance();
            int major = spec.getVersion();
            TestSpecificationConfiguration.assertEquals((int)2, (int)major);
            TestSpecificationConfiguration.assertTrue((boolean)spec.isSame("JPA"));
        }
        finally {
            if (emf1 != null) {
                emf1.close();
            }
        }
    }

    public void testLowerVersionCanBeSet() {
        super.setUp("openjpa.Specification", "JPA 1.0");
        Specification spec = this.getSpecifcation();
        TestSpecificationConfiguration.assertNotNull((Object)spec);
        TestSpecificationConfiguration.assertEquals((int)1, (int)spec.getVersion());
    }

    public void testHigherVersionCanNotBeSet() {
        try {
            super.setUp("openjpa.Specification", "jpa 3.0", "openjpa.Log", "DefaultLevel=WARN");
            TestSpecificationConfiguration.fail((String)"Expected to fail with higher Spec version");
        }
        catch (IllegalArgumentException ex) {
            this.emf.getConfiguration().getLog("Tests").trace((Object)("Caught expected IllegalArgumentException = " + ex));
        }
        catch (PersistenceException pe) {
            this.emf.getConfiguration().getLog("Tests").trace((Object)("Caught expected PersistenceException = " + (Object)((Object)pe)));
        }
    }

    public void testDifferentSpecCanBeSet() {
        super.setUp("openjpa.Specification", "jdo 3.0");
    }

    public void testSpecCanBeSetToNullString() {
        Specification spec = this.getSpecifcation();
        TestSpecificationConfiguration.assertNotNull((Object)spec);
        this.emf.getConfiguration().setSpecification((String)null);
        TestSpecificationConfiguration.assertNull((Object)this.getSpecifcation());
    }

    public void testSpecCanBeSetToNullSpecification() {
        Specification spec = this.getSpecifcation();
        TestSpecificationConfiguration.assertNotNull((Object)spec);
        this.emf.getConfiguration().setSpecification((Specification)null);
        TestSpecificationConfiguration.assertNull((Object)this.getSpecifcation());
    }

    public Specification getSpecifcation() {
        return this.emf.getConfiguration().getSpecificationInstance();
    }
}

