/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.conf;

import java.util.HashMap;
import javax.persistence.EntityManager;
import javax.persistence.Persistence;
import javax.persistence.PersistenceException;
import junit.framework.TestCase;
import org.apache.openjpa.lib.util.ParseException;
import org.apache.openjpa.persistence.OpenJPAEntityManagerFactory;

public class TestBadAutoDetachProperty
extends TestCase {
    public void testEmptyValue() {
        HashMap<Object, Object> props = new HashMap<Object, Object>(System.getProperties());
        props.put("openjpa.AutoDetach", "");
        OpenJPAEntityManagerFactory emf = (OpenJPAEntityManagerFactory)Persistence.createEntityManagerFactory((String)"test", props);
        EntityManager em = emf.createEntityManager();
        em.close();
        emf.close();
    }

    public void testCommaOnlyValue() {
        try {
            HashMap<Object, Object> props = new HashMap<Object, Object>(System.getProperties());
            props.put("openjpa.AutoDetach", ",");
            OpenJPAEntityManagerFactory emf = (OpenJPAEntityManagerFactory)Persistence.createEntityManagerFactory((String)"test", props);
            EntityManager em = emf.createEntityManager();
            em.close();
            emf.close();
        }
        catch (PersistenceException e) {
            Throwable cause = e.getCause();
            if (cause != null) {
                while (cause instanceof PersistenceException) {
                    cause = ((PersistenceException)cause).getCause();
                }
                if (!(cause instanceof ParseException)) {
                    TestBadAutoDetachProperty.fail((String)("Should have caught PersistenceException whose cause was a ParseException. Instead the cause was: " + cause));
                }
            } else {
                String msg = e.getMessage();
                if (msg.indexOf("org.apache.openjpa.lib.util.ParseException") == -1) {
                    TestBadAutoDetachProperty.fail((String)("Should have caught PersistenceException whose cause was a ParseException. Instead the cause was: " + cause));
                }
            }
        }
        catch (RuntimeException e) {
            TestBadAutoDetachProperty.fail((String)("Should have caught a PersistenceException, instead caught: " + e));
        }
    }

    public void testEmptyItemValue() {
        try {
            HashMap<Object, Object> props = new HashMap<Object, Object>(System.getProperties());
            props.put("openjpa.AutoDetach", "close,,commit");
            OpenJPAEntityManagerFactory emf = (OpenJPAEntityManagerFactory)Persistence.createEntityManagerFactory((String)"test", props);
            EntityManager em = emf.createEntityManager();
            em.close();
            emf.close();
        }
        catch (PersistenceException e) {
            Throwable cause = e.getCause();
            if (cause != null) {
                while (cause instanceof PersistenceException) {
                    cause = ((PersistenceException)cause).getCause();
                }
                if (!(cause instanceof ParseException)) {
                    TestBadAutoDetachProperty.fail((String)("Should have caught PersistenceException whose cause was a ParseException. Instead the cause was: " + cause));
                }
            } else {
                String msg = e.getMessage();
                if (msg.indexOf("org.apache.openjpa.lib.util.ParseException") == -1) {
                    TestBadAutoDetachProperty.fail((String)("Should have caught PersistenceException whose cause was a ParseException. Instead the cause was: " + cause));
                }
            }
        }
        catch (RuntimeException e) {
            TestBadAutoDetachProperty.fail((String)("Should have caught a PersistenceException, instead caught: " + e));
        }
    }
}

