/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.conf;

import java.util.EnumSet;
import java.util.HashMap;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Persistence;
import junit.framework.TestCase;
import org.apache.openjpa.persistence.AutoDetachType;
import org.apache.openjpa.persistence.OpenJPAEntityManagerFactory;
import org.apache.openjpa.persistence.OpenJPAPersistence;

public class TestAutoDetachProperty
extends TestCase {
    private EntityManager em;
    private EntityManagerFactory emf;

    public void setUp() throws Exception {
        HashMap<Object, Object> props = new HashMap<Object, Object>(System.getProperties());
        props.put("openjpa.AutoDetach", "commit,close,nontx-read");
        this.emf = (OpenJPAEntityManagerFactory)Persistence.createEntityManagerFactory((String)"test", props);
        this.em = this.emf.createEntityManager();
    }

    public void tearDown() throws Exception {
        this.em.close();
        this.em = null;
    }

    public void testIsAutoDetachingOnClose() {
        TestAutoDetachProperty.assertTrue((String)"not autodetaching on close as expected", (boolean)this.isAutoDetachingOnClose());
    }

    public void testIsAutoDetachingOnCommit() {
        TestAutoDetachProperty.assertTrue((String)"not autodetaching on commit as expected", (boolean)this.isAutoDetachingOnCommit());
    }

    public void testIsAutoDetachingOnNonTxRead() {
        TestAutoDetachProperty.assertTrue((String)"not autodetaching on nontransactional read as expected", (boolean)this.isAutoDetachingOnNonTxRead());
    }

    private boolean isAutoDetachingOnClose() {
        EnumSet autoDetachFlags = OpenJPAPersistence.cast((EntityManager)this.em).getAutoDetach();
        return autoDetachFlags.contains(AutoDetachType.CLOSE);
    }

    private boolean isAutoDetachingOnCommit() {
        EnumSet autoDetachFlags = OpenJPAPersistence.cast((EntityManager)this.em).getAutoDetach();
        return autoDetachFlags.contains(AutoDetachType.COMMIT);
    }

    private boolean isAutoDetachingOnNonTxRead() {
        EnumSet autoDetachFlags = OpenJPAPersistence.cast((EntityManager)this.em).getAutoDetach();
        return autoDetachFlags.contains(AutoDetachType.NON_TRANSACTIONAL_READ);
    }
}

