/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.lib.util.git;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.apache.openjpa.lib.util.git.GitUtils;

public class TestGitUtils
extends TestCase {
    public TestGitUtils(String s) {
        super(s);
    }

    public void testNull() {
        TestGitUtils.assertEquals((int)-1, (int)GitUtils.convertGitInfoToPCEnhancerVersion(null));
    }

    public void testBasic() {
        long i = 12345678L;
        TestGitUtils.assertEquals((long)i, (long)GitUtils.convertGitInfoToPCEnhancerVersion((String)"BC614E"));
    }

    public void testBasic2() {
        int i = 267342907;
        TestGitUtils.assertEquals((int)i, (int)GitUtils.convertGitInfoToPCEnhancerVersion((String)"fef543b"));
    }

    public void testGoodTrailingString() {
        long i = 12345678L;
        TestGitUtils.assertEquals((long)i, (long)GitUtils.convertGitInfoToPCEnhancerVersion((String)"BC614Em"));
        TestGitUtils.assertEquals((long)i, (long)GitUtils.convertGitInfoToPCEnhancerVersion((String)"BC614EM"));
    }

    public void testBad() {
        long i = 12345678L;
        TestGitUtils.assertEquals((int)-1, (int)GitUtils.convertGitInfoToPCEnhancerVersion((String)(i + "BC614Ems")));
        TestGitUtils.assertEquals((int)-1, (int)GitUtils.convertGitInfoToPCEnhancerVersion((String)"ZC614EM"));
        TestGitUtils.assertEquals((int)-1, (int)GitUtils.convertGitInfoToPCEnhancerVersion((String)"ZC614E"));
    }

    public static Test suite() {
        return new TestSuite(TestGitUtils.class);
    }

    public static void main(String[] args) {
        TestRunner.run((Test)TestGitUtils.suite());
    }
}

